/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class FabricDatabaseManager {
    protected final FabricConfig fabricConfig;
    protected final DatabaseReferenceRepository databaseReferenceRepo;
    protected final DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider;

    public FabricDatabaseManager(FabricConfig fabricConfig, DatabaseContextProvider<? extends DatabaseContext> databaseContextProvider, DatabaseReferenceRepository databaseReferenceRepo) {
        this.fabricConfig = fabricConfig;
        this.databaseContextProvider = databaseContextProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
    }

    public DatabaseReferenceRepository databaseReferenceRepository() {
        return this.databaseReferenceRepo;
    }

    public DatabaseReference getDatabaseReference(String databaseNameRaw) {
        return (DatabaseReference)this.databaseReferenceRepo.getByAlias(databaseNameRaw).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
    }

    public GraphDatabaseAPI getDatabaseFacade(String databaseNameRaw) throws UnavailableException {
        DatabaseContext databaseContext = this.getDatabaseContext(databaseNameRaw);
        databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        return databaseContext.databaseFacade();
    }

    private DatabaseContext getDatabaseContext(String databaseNameRaw) {
        return (DatabaseContext)this.databaseReferenceRepo.getByAlias(databaseNameRaw).flatMap(this::getDatabaseContext).orElseThrow(FabricDatabaseManager.databaseNotFound(databaseNameRaw));
    }

    private Optional<? extends DatabaseContext> getDatabaseContext(DatabaseReference databaseReference) {
        if (databaseReference instanceof DatabaseReference.Composite) {
            return this.databaseContextProvider.getDatabaseContext(((DatabaseReference.Composite)databaseReference).databaseId());
        }
        if (databaseReference instanceof DatabaseReference.Internal) {
            return this.databaseContextProvider.getDatabaseContext(((DatabaseReference.Internal)databaseReference).databaseId());
        }
        return Optional.empty();
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found");
    }

    public boolean isFabricDatabase(NamedDatabaseId databaseId2) {
        return false;
    }

    public FabricConfig getFabricConfig() {
        return this.fabricConfig;
    }
}

