/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.common.DependencyResolver;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricDatabaseAccess;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricKernelTransaction;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.SingleDbTransaction;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.CompositeTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.virtual.MapValue;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FabricLocalExecutor {
    private final FabricConfig config;
    private final FabricDatabaseManager dbms;
    private final FabricDatabaseAccess databaseAccess;

    public FabricLocalExecutor(FabricConfig config, FabricDatabaseManager dbms, FabricDatabaseAccess databaseAccess) {
        this.config = config;
        this.dbms = dbms;
        this.databaseAccess = databaseAccess;
    }

    public LocalTransactionContext startTransactionContext(CompositeTransaction compositeTransaction, FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager) {
        return new LocalTransactionContext(compositeTransaction, transactionInfo, bookmarkManager);
    }

    public class LocalTransactionContext
    implements AutoCloseable {
        private final Map<UUID, KernelTxWrapper> kernelTransactions = new ConcurrentHashMap<UUID, KernelTxWrapper>();
        private final Set<InternalTransaction> internalTransactions = ConcurrentHashMap.newKeySet();
        private final CompositeTransaction compositeTransaction;
        private final FabricTransactionInfo transactionInfo;
        private final TransactionBookmarkManager bookmarkManager;

        private LocalTransactionContext(CompositeTransaction compositeTransaction, FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager) {
            this.compositeTransaction = compositeTransaction;
            this.transactionInfo = transactionInfo;
            this.bookmarkManager = bookmarkManager;
        }

        public StatementResult run(Location.Local location, TransactionMode transactionMode, FabricStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, Flux<Record> input, ExecutionOptions executionOptions) {
            FabricKernelTransaction kernelTransaction = this.getOrCreateTx(location, transactionMode);
            return kernelTransaction.run(query, params, input, parentLifecycle, executionOptions);
        }

        @Override
        public void close() {
        }

        public Set<InternalTransaction> getInternalTransactions() {
            return this.internalTransactions;
        }

        public FabricKernelTransaction getOrCreateTx(Location.Local location, TransactionMode transactionMode) {
            KernelTxWrapper existingTx = this.kernelTransactions.get(location.getUuid());
            if (existingTx != null) {
                this.maybeUpgradeToWritingTransaction(existingTx, transactionMode);
                return existingTx.fabricKernelTransaction;
            }
            GraphDatabaseAPI databaseFacade = this.getDatabaseFacade(location);
            this.bookmarkManager.awaitUpToDate(location);
            return this.kernelTransactions.computeIfAbsent((UUID)location.getUuid(), (Function<UUID, KernelTxWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrCreateTx$3(org.neo4j.fabric.transaction.TransactionMode org.neo4j.fabric.executor.Location$Local org.neo4j.kernel.internal.GraphDatabaseAPI java.util.UUID ), (Ljava/util/UUID;)Lorg/neo4j/fabric/executor/FabricLocalExecutor$KernelTxWrapper;)((LocalTransactionContext)this, (TransactionMode)transactionMode, (Location.Local)location, (GraphDatabaseAPI)databaseFacade)).fabricKernelTransaction;
        }

        private void maybeUpgradeToWritingTransaction(KernelTxWrapper tx, TransactionMode transactionMode) {
            if (transactionMode == TransactionMode.DEFINITELY_WRITE) {
                this.compositeTransaction.upgradeToWritingTransaction(tx);
            }
        }

        private FabricKernelTransaction beginKernelTx(GraphDatabaseAPI databaseFacade, AccessMode accessMode) {
            DependencyResolver dependencyResolver = databaseFacade.getDependencyResolver();
            ExecutionEngine executionEngine = (ExecutionEngine)dependencyResolver.resolveDependency(ExecutionEngine.class);
            InternalTransaction internalTransaction = this.beginInternalTransaction(databaseFacade, this.transactionInfo);
            TransactionalContextFactory transactionalContextFactory = (TransactionalContextFactory)dependencyResolver.resolveDependency(TransactionalContextFactory.class);
            return new FabricKernelTransaction(executionEngine, transactionalContextFactory, internalTransaction, FabricLocalExecutor.this.config);
        }

        private GraphDatabaseAPI getDatabaseFacade(Location.Local location) {
            try {
                GraphDatabaseAPI facade = FabricLocalExecutor.this.dbms.getDatabaseFacade(location.getDatabaseName());
                if (!Objects.equals(facade.databaseId().databaseId().uuid(), location.getUuid())) {
                    throw new FabricException((Status)Status.Transaction.Outdated, "The locations associated with the graph name %s have changed whilst the transaction was running.", location.getDatabaseName());
                }
                return facade;
            }
            catch (UnavailableException e) {
                throw new FabricException((Status)Status.General.DatabaseUnavailable, (Throwable)e);
            }
        }

        private InternalTransaction beginInternalTransaction(GraphDatabaseAPI databaseAPI, FabricTransactionInfo transactionInfo) {
            InternalTransaction internalTransaction;
            KernelTransaction.Type kernelTransactionType = this.getKernelTransactionType(transactionInfo);
            if (databaseAPI instanceof GraphDatabaseFacade) {
                GraphDatabaseFacade facade = (GraphDatabaseFacade)databaseAPI;
                v0 = facade.beginTransaction(kernelTransactionType, transactionInfo.getLoginContext(), transactionInfo.getClientConnectionInfo(), Long.valueOf(transactionInfo.getTxTimeout().toMillis()), this.compositeTransaction::childTransactionTerminated, this::transformTerminalOperationError);
            } else {
                v0 = internalTransaction = databaseAPI.beginTransaction(kernelTransactionType, transactionInfo.getLoginContext(), transactionInfo.getClientConnectionInfo(), transactionInfo.getTxTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
            if (transactionInfo.getTxMetadata() != null) {
                internalTransaction.setMetaData(transactionInfo.getTxMetadata());
            }
            this.internalTransactions.add(internalTransaction);
            return internalTransaction;
        }

        private KernelTransaction.Type getKernelTransactionType(FabricTransactionInfo fabricTransactionInfo) {
            if (fabricTransactionInfo.isImplicitTransaction()) {
                return KernelTransaction.Type.IMPLICIT;
            }
            return KernelTransaction.Type.EXPLICIT;
        }

        private RuntimeException transformTerminalOperationError(Exception e) {
            if (e instanceof Status.HasStatus) {
                if (e instanceof RuntimeException) {
                    return (RuntimeException)e;
                }
                return new FabricException(((Status.HasStatus)e).status(), e.getMessage(), e);
            }
            throw new TransactionFailureException("Unable to complete transaction.", (Throwable)e);
        }

        private /* synthetic */ KernelTxWrapper lambda$getOrCreateTx$3(TransactionMode transactionMode, Location.Local location, GraphDatabaseAPI databaseFacade, UUID dbUuid) {
            switch (transactionMode) {
                case DEFINITELY_WRITE: {
                    return this.compositeTransaction.startWritingTransaction(location, () -> {
                        FabricKernelTransaction tx = this.beginKernelTx(databaseFacade, AccessMode.WRITE);
                        return new KernelTxWrapper(tx, this.bookmarkManager, location);
                    });
                }
                case MAYBE_WRITE: {
                    return this.compositeTransaction.startReadingTransaction(location, () -> {
                        FabricKernelTransaction tx = this.beginKernelTx(databaseFacade, AccessMode.WRITE);
                        return new KernelTxWrapper(tx, this.bookmarkManager, location);
                    });
                }
                case DEFINITELY_READ: {
                    return this.compositeTransaction.startReadingOnlyTransaction(location, () -> {
                        FabricKernelTransaction tx = this.beginKernelTx(databaseFacade, AccessMode.READ);
                        return new KernelTxWrapper(tx, this.bookmarkManager, location);
                    });
                }
            }
            throw new IllegalArgumentException("Unexpected transaction mode: " + transactionMode);
        }
    }

    private static class KernelTxWrapper
    implements SingleDbTransaction {
        private final FabricKernelTransaction fabricKernelTransaction;
        private final TransactionBookmarkManager bookmarkManager;
        private final Location.Local location;

        KernelTxWrapper(FabricKernelTransaction fabricKernelTransaction, TransactionBookmarkManager bookmarkManager, Location.Local location) {
            this.fabricKernelTransaction = fabricKernelTransaction;
            this.bookmarkManager = bookmarkManager;
            this.location = location;
        }

        @Override
        public Mono<Void> commit() {
            return Mono.fromRunnable(this::doCommit);
        }

        @Override
        public Mono<Void> rollback() {
            return Mono.fromRunnable(this::doRollback);
        }

        private void doCommit() {
            this.fabricKernelTransaction.commit();
            this.bookmarkManager.localTransactionCommitted(this.location);
        }

        private void doRollback() {
            this.fabricKernelTransaction.rollback();
        }

        @Override
        public Mono<Void> terminate(Status reason) {
            return Mono.fromRunnable(() -> this.fabricKernelTransaction.terminate(reason));
        }

        @Override
        public Location getLocation() {
            return this.location;
        }
    }
}

