/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.io.Serializable;
import org.neo4j.configuration.helpers.NormalizedGraphName;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.CatalogName$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.fabric.eval.Catalog;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Catalog$
implements Serializable {
    public static final Catalog$ MODULE$ = new Catalog$();
    private static final Catalog graphByNameView;

    static {
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"graph", "byName"}))), (Object)new Catalog.ByNameView())}));
        Map<CatalogName, Catalog.Graph> x$2 = MODULE$.apply$default$1();
        graphByNameView = new Catalog(x$2, (Map<CatalogName, Catalog.View>)x$1);
    }

    public Map<CatalogName, Catalog.Graph> $lessinit$greater$default$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<CatalogName, Catalog.View> $lessinit$greater$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Catalog create(Seq<Catalog.Graph> internalGraphs, Seq<Catalog.Graph> externalGraphs, Seq<Catalog.Graph> graphAliases, Option<String> fabricNamespace) {
        return this.create(internalGraphs, externalGraphs, graphAliases, (Seq<Tuple2<Catalog.Composite, Seq<Catalog.Graph>>>)((Seq)package$.MODULE$.Seq().empty()), fabricNamespace);
    }

    public Catalog create(Seq<Catalog.Graph> internalGraphs, Seq<Catalog.Graph> externalGraphs, Seq<Catalog.Graph> graphAliases, Seq<Tuple2<Catalog.Composite, Seq<Catalog.Graph>>> composites, Option<String> fabricNamespace) {
        if (fabricNamespace.isEmpty()) {
            Catalog databasesAndAliases = this.byQualifiedName((Seq<Catalog.Graph>)((Seq)internalGraphs.$plus$plus(graphAliases)));
            Catalog compositesAndAliases = (Catalog)composites.foldLeft((Object)this.empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Catalog catalog = (Catalog)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Catalog.Composite composite = (Catalog.Composite)tuple22._1();
                        Seq aliases = (Seq)tuple22._2();
                        Catalog.Composite composite2 = composite;
                        Catalog byName = MODULE$.byQualifiedName((Seq<Catalog.Graph>)((Seq)aliases.$plus$colon((Object)composite2)));
                        return catalog.$plus$plus(byName);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return databasesAndAliases.$plus$plus(compositesAndAliases).$plus$plus(this.graphByNameView());
        }
        Seq allGraphs = (Seq)externalGraphs.$plus$plus(internalGraphs);
        Catalog byId = this.byIdView((Seq<Catalog.Graph>)allGraphs, (String)fabricNamespace.get());
        Catalog externalByName = this.byName(externalGraphs, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{(String)fabricNamespace.get()}));
        Catalog internalByName = this.byName(internalGraphs, (Seq<String>)Nil$.MODULE$);
        Catalog aliasesByName = this.byName(graphAliases, (Seq<String>)Nil$.MODULE$);
        return byId.$plus$plus(externalByName).$plus$plus(internalByName).$plus$plus(aliasesByName);
    }

    public Catalog empty() {
        return new Catalog((Map<CatalogName, Catalog.Graph>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), this.apply$default$2());
    }

    public Catalog byQualifiedName(Seq<Catalog.Graph> graphs) {
        return new Catalog((Map<CatalogName, Catalog.Graph>)((IterableOnceOps)graphs.flatMap((Function1 & Serializable)graph -> graph.name().map((Function1 & Serializable)name -> {
            CatalogName catalogName;
            Catalog.Graph graph = graph;
            if (graph instanceof Catalog.NamespacedGraph) {
                Catalog.NamespacedGraph namespacedGraph = (Catalog.NamespacedGraph)graph;
                catalogName = MODULE$.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{namespacedGraph.namespace(), name}));
            } else {
                catalogName = MODULE$.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
            }
            CatalogName catalogName2 = catalogName;
            return new Tuple2(name, (Object)catalogName2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                CatalogName catalogName = (CatalogName)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)catalogName), graph);
            }
            throw new MatchError((Object)tuple2);
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.apply$default$2());
    }

    public CatalogName catalogName(Catalog.Graph graph) {
        Catalog.Graph graph2 = graph;
        if (graph2 instanceof Catalog.NamespacedGraph) {
            Catalog.NamespacedGraph namespacedGraph = (Catalog.NamespacedGraph)graph2;
            return this.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{namespacedGraph.namespace(), this.graphName(namespacedGraph.graph())}));
        }
        return this.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.graphName(graph)}));
    }

    private String graphName(Catalog.Graph graph) {
        Catalog.Graph graph2 = graph;
        if (graph2 instanceof Catalog.InternalGraph) {
            Catalog.InternalGraph internalGraph = (Catalog.InternalGraph)graph2;
            return internalGraph.graphName().name();
        }
        if (graph2 instanceof Catalog.InternalAlias) {
            Catalog.InternalAlias internalAlias = (Catalog.InternalAlias)graph2;
            return internalAlias.graphName().name();
        }
        if (graph2 instanceof Catalog.ExternalAlias) {
            Catalog.ExternalAlias externalAlias = (Catalog.ExternalAlias)graph2;
            return externalAlias.graphName().name();
        }
        if (graph2 instanceof Catalog.Composite) {
            Catalog.Composite composite = (Catalog.Composite)graph2;
            return composite.databaseName().name();
        }
        throw new InternalException("Unexpected graph type: " + graph.getClass().getSimpleName());
    }

    private Catalog byName(Seq<Catalog.Graph> graphs, Seq<String> namespace) {
        return new Catalog((Map<CatalogName, Catalog.Graph>)((IterableOnceOps)graphs.flatMap((Function1 & Serializable)graph -> graph.name().map((Function1 & Serializable)name -> {
            Seq fqn = (Seq)namespace.$colon$plus(name);
            return new Tuple2(name, (Object)fqn);
        }).map((Function1 & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                Seq fqn = (Seq)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new CatalogName(fqn.toList())), graph);
            }
            throw new MatchError((Object)tuple2);
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.apply$default$2());
    }

    private Catalog byIdView(Seq<Catalog.Graph> graphs, String namespace) {
        Map x$1 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.normalizedName((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{namespace, "graph"}))), (Object)new Catalog.ByIdView(graphs))}));
        Map<CatalogName, Catalog.Graph> x$2 = this.apply$default$1();
        return new Catalog(x$2, (Map<CatalogName, Catalog.View>)x$1);
    }

    private Catalog graphByNameView() {
        return graphByNameView;
    }

    public String org$neo4j$fabric$eval$Catalog$$normalize(String graphName) {
        return new NormalizedGraphName(graphName).name();
    }

    public CatalogName org$neo4j$fabric$eval$Catalog$$normalize(CatalogName name) {
        return new CatalogName(name.parts().map((Function1 & Serializable)graphName -> MODULE$.org$neo4j$fabric$eval$Catalog$$normalize((String)graphName)));
    }

    private CatalogName normalizedName(Seq<String> parts) {
        return this.org$neo4j$fabric$eval$Catalog$$normalize(CatalogName$.MODULE$.apply(parts));
    }

    public Catalog apply(Map<CatalogName, Catalog.Graph> graphs, Map<CatalogName, Catalog.View> views) {
        return new Catalog(graphs, views);
    }

    public Map<CatalogName, Catalog.Graph> apply$default$1() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Map<CatalogName, Catalog.View> apply$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public Option<Tuple2<Map<CatalogName, Catalog.Graph>, Map<CatalogName, Catalog.View>>> unapply(Catalog x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.graphs(), x$0.views()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Catalog$.class);
    }

    private Catalog$() {
    }
}

