/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import java.util.concurrent.Executor;
import org.neo4j.fabric.stream.Record;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;

public class CompletionDelegatingOperator
extends FluxOperator<Record, Record> {
    private final Flux<Record> recordStream;
    private final Executor executor;

    public CompletionDelegatingOperator(Flux<Record> recordStream, Executor executor) {
        super(recordStream);
        this.recordStream = recordStream;
        this.executor = executor;
    }

    public void subscribe(CoreSubscriber downstreamSubscriber) {
        this.recordStream.subscribeWith((Subscriber)new UpstreamSubscriber((Subscriber<Record>)downstreamSubscriber));
    }

    private class UpstreamSubscriber
    implements Subscriber<Record> {
        private final Subscriber<Record> downstreamSubscriber;

        UpstreamSubscriber(Subscriber<Record> downstreamSubscriber) {
            this.downstreamSubscriber = downstreamSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.downstreamSubscriber.onSubscribe(subscription);
        }

        public void onNext(Record record) {
            this.downstreamSubscriber.onNext((Object)record);
        }

        public void onError(Throwable throwable) {
            CompletionDelegatingOperator.this.executor.execute(() -> this.downstreamSubscriber.onError(throwable));
        }

        public void onComplete() {
            CompletionDelegatingOperator.this.executor.execute(() -> this.downstreamSubscriber.onComplete());
        }
    }
}

