/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.executor.Exceptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.FabricKernelTransaction;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.SingleDbTransaction;
import org.neo4j.fabric.planning.StatementType;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricProcedures;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.LocationCache;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.fabric.transaction.parent.AbstractCompoundTransaction;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.time.SystemNanoClock;
import reactor.core.publisher.Mono;

public class FabricTransactionImpl
extends AbstractCompoundTransaction<SingleDbTransaction>
implements FabricTransaction,
FabricTransaction.FabricExecutionContext {
    private final FabricTransactionInfo transactionInfo;
    private final TransactionBookmarkManager bookmarkManager;
    private final Catalog catalogSnapshot;
    private final TransactionManager transactionManager;
    private final FabricRemoteExecutor.RemoteTransactionContext remoteTransactionContext;
    private final FabricLocalExecutor.LocalTransactionContext localTransactionContext;
    private final AtomicReference<StatementType> statementType = new AtomicReference();
    private final LocationCache locationCache;
    private final TransactionInitializationTrace initializationTrace;
    private final FabricKernelTransaction kernelTransaction;
    private final Procedures contextlessProcedures;

    FabricTransactionImpl(FabricTransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager, FabricRemoteExecutor remoteExecutor, FabricLocalExecutor localExecutor, FabricProcedures contextlessProcedures, ErrorReporter errorReporter, TransactionManager transactionManager, Catalog catalogSnapshot, CatalogManager catalogManager, Boolean inCompositeContext, SystemNanoClock clock, TraceProvider traceProvider) {
        super(errorReporter, clock);
        this.transactionInfo = transactionInfo;
        this.transactionManager = transactionManager;
        this.bookmarkManager = bookmarkManager;
        this.catalogSnapshot = catalogSnapshot;
        this.initializationTrace = traceProvider.getTraceInfo();
        this.contextlessProcedures = contextlessProcedures;
        this.locationCache = new LocationCache(catalogManager, transactionInfo);
        try {
            this.remoteTransactionContext = remoteExecutor.startTransactionContext(this, transactionInfo, bookmarkManager);
            this.localTransactionContext = localExecutor.startTransactionContext(this, transactionInfo, bookmarkManager);
            DatabaseReference sessionDatabaseReference = this.getSessionDatabaseReference();
            if (inCompositeContext.booleanValue()) {
                Catalog.Graph graph = catalogSnapshot.resolveGraphByNameString(sessionDatabaseReference.alias().name());
                Location location = this.locationOf(graph, false);
                this.kernelTransaction = this.localTransactionContext.getOrCreateTx((Location.Local)location, TransactionMode.DEFINITELY_READ, true);
            } else {
                this.kernelTransaction = null;
            }
        }
        catch (RuntimeException e) {
            throw Exceptions.transform((Status)Status.Transaction.TransactionStartFailed, e);
        }
    }

    @Override
    public Catalog getCatalogSnapshot() {
        return this.catalogSnapshot;
    }

    @Override
    public FabricTransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    @Override
    public FabricRemoteExecutor.RemoteTransactionContext getRemote() {
        return this.remoteTransactionContext;
    }

    @Override
    public FabricLocalExecutor.LocalTransactionContext getLocal() {
        return this.localTransactionContext;
    }

    @Override
    public void validateStatementType(StatementType type) {
        StatementType oldType;
        boolean wasNull = this.statementType.compareAndSet(null, type);
        if (!wasNull && (oldType = this.statementType.get()) != type) {
            boolean allowedCombination;
            boolean queryAfterQuery = type.isQuery() && oldType.isQuery();
            boolean readQueryAfterSchema = type.isReadQuery() && oldType.isSchemaCommand();
            boolean schemaAfterReadQuery = type.isSchemaCommand() && oldType.isReadQuery();
            boolean bl = allowedCombination = queryAfterQuery || readQueryAfterSchema || schemaAfterReadQuery;
            if (allowedCombination) {
                boolean upgrade;
                boolean writeQueryAfterReadQuery = queryAfterQuery && !type.isReadQuery() && oldType.isReadQuery();
                boolean bl2 = upgrade = writeQueryAfterReadQuery || schemaAfterReadQuery;
                if (upgrade) {
                    this.statementType.set(type);
                }
            } else {
                throw new FabricException((Status)Status.Transaction.ForbiddenDueToTransactionType, "Tried to execute %s after executing %s", type, oldType);
            }
        }
    }

    public boolean isSchemaTransaction() {
        StatementType type = this.statementType.get();
        return type != null && type.isSchemaCommand();
    }

    @Override
    public DatabaseReference getSessionDatabaseReference() {
        return this.transactionInfo.getSessionDatabaseReference();
    }

    @Override
    public Location locationOf(Catalog.Graph graph, Boolean requireWritable) {
        return this.locationCache.locationOf(graph, requireWritable);
    }

    @Override
    protected boolean isUninitialized() {
        return this.remoteTransactionContext == null && this.localTransactionContext == null;
    }

    @Override
    protected Mono<Void> childTransactionCommit(SingleDbTransaction singleDbTransaction) {
        return singleDbTransaction.commit();
    }

    @Override
    protected Mono<Void> childTransactionRollback(SingleDbTransaction singleDbTransaction) {
        return singleDbTransaction.rollback();
    }

    @Override
    protected Mono<Void> childTransactionTerminate(SingleDbTransaction singleDbTransaction, Status reason) {
        return singleDbTransaction.terminate(reason);
    }

    @Override
    protected void closeContextsAndRemoveTransaction() {
        this.remoteTransactionContext.close();
        this.localTransactionContext.close();
        this.transactionManager.removeTransaction(this);
    }

    @Override
    public StatementResult execute(Function<FabricTransaction.FabricExecutionContext, StatementResult> runLogic) {
        this.checkTransactionOpenForStatementExecution();
        try {
            return runLogic.apply(this);
        }
        catch (RuntimeException e) {
            RuntimeException transformed = Exceptions.transform((Status)Status.Statement.ExecutionFailed, e);
            try {
                this.rollback();
            }
            catch (Exception rollbackException) {
                transformed.addSuppressed(rollbackException);
            }
            throw transformed;
        }
    }

    public boolean isLocal() {
        return this.remoteTransactionContext.isEmptyContext();
    }

    @Override
    public TransactionBookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    @Override
    public void setMetaData(Map<String, Object> txMeta) {
        this.transactionInfo.setMetaData(txMeta);
        for (InternalTransaction internalTransaction : this.getInternalTransactions()) {
            internalTransaction.setMetaData(txMeta);
        }
    }

    @Override
    public ExecutingQuery.TransactionBinding transactionBinding() throws FabricException {
        if (this.kernelTransaction == null) {
            return null;
        }
        DatabaseReference sessionDatabaseReference = this.getSessionDatabaseReference();
        NamedDatabaseId namedDbId = DatabaseIdFactory.from((String)sessionDatabaseReference.alias().name(), (UUID)sessionDatabaseReference.id());
        long transactionSequenceNumber = this.kernelTransaction.transactionSequenceNumber();
        return new ExecutingQuery.TransactionBinding(namedDbId, () -> 0L, () -> 0L, () -> 0L, transactionSequenceNumber);
    }

    @Override
    public Procedures contextlessProcedures() {
        return this.contextlessProcedures;
    }

    @Override
    public CancellationChecker cancellationChecker() {
        return () -> this.checkTransactionOpenForStatementExecution();
    }

    public TransactionInitializationTrace getInitializationTrace() {
        return this.initializationTrace;
    }

    public Set<InternalTransaction> getInternalTransactions() {
        return this.localTransactionContext.getInternalTransactions();
    }

    @Override
    public void closeTransaction(SingleDbTransaction databaseTransaction) {
    }
}

