/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bootstrap;

import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.time.SystemNanoClock;

public class CommonQueryRouterBootstrap {
    private final ServiceBootstrapper serviceBootstrapper;
    protected final Dependencies dependencies;
    private final DatabaseContextProvider<? extends DatabaseContext> databaseProvider;

    public CommonQueryRouterBootstrap(LifeSupport lifeSupport, Dependencies dependencies, DatabaseContextProvider<? extends DatabaseContext> databaseProvider) {
        this.dependencies = dependencies;
        this.serviceBootstrapper = new ServiceBootstrapper(lifeSupport, dependencies);
        this.databaseProvider = databaseProvider;
    }

    protected void bootstrapCommonServices(DatabaseManagementService databaseManagementService, LogService logService) {
        if (!this.dependencies.containsDependency(LocalGraphTransactionIdTracker.class)) {
            Monitors monitors = this.resolve(Monitors.class);
            Config serverConfig = this.resolve(Config.class);
            SystemNanoClock systemNanoClock = this.resolve(SystemNanoClock.class);
            InternalLogProvider logProvider = logService.getInternalLogProvider();
            TransactionIdTracker transactionIdTracker = new TransactionIdTracker(databaseManagementService, monitors, systemNanoClock, (LogProvider)logProvider);
            DatabaseIdRepository databaseIdRepository = this.databaseProvider.databaseIdRepository();
            this.register(new LocalGraphTransactionIdTracker(transactionIdTracker, databaseIdRepository, serverConfig), LocalGraphTransactionIdTracker.class);
        }
    }

    protected <T> T register(T dependency, Class<T> dependencyType) {
        return this.serviceBootstrapper.registerService(dependency, dependencyType);
    }

    protected <T> T resolve(Class<T> type) {
        return (T)this.dependencies.resolveDependency(type);
    }

    protected <T extends Lifecycle> void registerWithLifecycle(T instance) {
        this.serviceBootstrapper.lifeSupport.add(instance);
    }

    private record ServiceBootstrapper(LifeSupport lifeSupport, Dependencies dependencies) {
        <T> T registerService(T dependency, Class<T> dependencyType) {
            this.dependencies.satisfyDependency(dependency);
            if (LifecycleAdapter.class.isAssignableFrom(dependencyType)) {
                this.lifeSupport.add((Lifecycle)((LifecycleAdapter)dependency));
            }
            return (T)this.dependencies.resolveDependency(dependencyType);
        }
    }
}

