/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.time.Clock;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class FabricProcedures
implements Procedures {
    private final ProcedureView view;
    private final Context EMPTY_CONTEXT = new EmptyProcedureContext();

    public FabricProcedures(ProcedureView view) {
        this.view = view;
    }

    private static <T> T notAvailable() {
        throw new RuntimeException("Operation not available in static context.");
    }

    public UserFunctionHandle functionGet(QualifiedName name, CypherScope scope) {
        return this.view.function(name, scope);
    }

    public Stream<UserFunctionSignature> functionGetAll(CypherScope scope) {
        return (Stream)FabricProcedures.notAvailable();
    }

    public UserFunctionHandle aggregationFunctionGet(QualifiedName name, CypherScope scope) {
        return (UserFunctionHandle)FabricProcedures.notAvailable();
    }

    public Stream<UserFunctionSignature> aggregationFunctionGetAll(CypherScope scope) {
        return (Stream)FabricProcedures.notAvailable();
    }

    public ProcedureHandle procedureGet(QualifiedName name, CypherScope scope) throws ProcedureException {
        return this.view.procedure(name, scope);
    }

    public Stream<ProcedureSignature> proceduresGetAll(CypherScope scope) throws ProcedureException {
        return (Stream)FabricProcedures.notAvailable();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallRead(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return (RawIterator)FabricProcedures.notAvailable();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallWrite(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return (RawIterator)FabricProcedures.notAvailable();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallSchema(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return (RawIterator)FabricProcedures.notAvailable();
    }

    public RawIterator<AnyValue[], ProcedureException> procedureCallDbms(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return (RawIterator)FabricProcedures.notAvailable();
    }

    public AnyValue functionCall(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.view.callFunction(this.EMPTY_CONTEXT, id, arguments);
    }

    public AnyValue builtInFunctionCall(int id, AnyValue[] arguments, ProcedureCallContext context) throws ProcedureException {
        return this.view.callFunction(this.EMPTY_CONTEXT, id, arguments);
    }

    public UserAggregationReducer aggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
        return (UserAggregationReducer)FabricProcedures.notAvailable();
    }

    public UserAggregationReducer builtInAggregationFunction(int id, ProcedureCallContext context) throws ProcedureException {
        return (UserAggregationReducer)FabricProcedures.notAvailable();
    }

    public long signatureVersion() {
        return this.view.signatureVersion();
    }

    private static class EmptyProcedureContext
    implements Context {
        private EmptyProcedureContext() {
        }

        public ValueMapper<Object> valueMapper() {
            return (ValueMapper)FabricProcedures.notAvailable();
        }

        public SecurityContext securityContext() {
            return (SecurityContext)FabricProcedures.notAvailable();
        }

        public DependencyResolver dependencyResolver() {
            return (DependencyResolver)FabricProcedures.notAvailable();
        }

        public GraphDatabaseAPI graphDatabaseAPI() {
            return (GraphDatabaseAPI)FabricProcedures.notAvailable();
        }

        public Thread thread() {
            return (Thread)FabricProcedures.notAvailable();
        }

        public Transaction transaction() {
            return (Transaction)FabricProcedures.notAvailable();
        }

        public InternalTransaction internalTransaction() {
            return (InternalTransaction)FabricProcedures.notAvailable();
        }

        public InternalTransaction internalTransactionOrNull() {
            return (InternalTransaction)FabricProcedures.notAvailable();
        }

        public KernelTransaction kernelTransaction() {
            return (KernelTransaction)FabricProcedures.notAvailable();
        }

        public Clock systemClock() throws ProcedureException {
            return (Clock)FabricProcedures.notAvailable();
        }

        public Clock statementClock() throws ProcedureException {
            return (Clock)FabricProcedures.notAvailable();
        }

        public Clock transactionClock() throws ProcedureException {
            return (Clock)FabricProcedures.notAvailable();
        }

        public URLAccessChecker urlAccessChecker() throws ProcedureException {
            return (URLAccessChecker)FabricProcedures.notAvailable();
        }

        public ProcedureCallContext procedureCallContext() {
            return (ProcedureCallContext)FabricProcedures.notAvailable();
        }
    }
}

