/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.transaction;

import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionImpl;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.FabricTransactionMonitor;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class TransactionManager
extends LifecycleAdapter {
    private final FabricRemoteExecutor remoteExecutor;
    private final FabricLocalExecutor localExecutor;
    private final ErrorReporter errorReporter;
    private final FabricConfig fabricConfig;
    private final FabricTransactionMonitor transactionMonitor;
    private final AbstractSecurityLog securityLog;
    private final Clock clock;
    private final Set<FabricTransactionImpl> openTransactions = ConcurrentHashMap.newKeySet();
    private final long awaitActiveTransactionDeadlineMillis;
    private final AvailabilityGuard availabilityGuard;

    public TransactionManager(FabricRemoteExecutor remoteExecutor, FabricLocalExecutor localExecutor, ErrorReporter errorReporter, FabricConfig fabricConfig, FabricTransactionMonitor transactionMonitor, AbstractSecurityLog securityLog, Clock clock, Config config, AvailabilityGuard availabilityGuard) {
        this.remoteExecutor = remoteExecutor;
        this.localExecutor = localExecutor;
        this.errorReporter = errorReporter;
        this.fabricConfig = fabricConfig;
        this.transactionMonitor = transactionMonitor;
        this.securityLog = securityLog;
        this.clock = clock;
        this.awaitActiveTransactionDeadlineMillis = ((Duration)config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)).toMillis();
        this.availabilityGuard = availabilityGuard;
    }

    public FabricTransaction begin(FabricTransactionInfo transactionInfo, TransactionBookmarkManager transactionBookmarkManager) {
        if (this.availabilityGuard.isShutdown()) {
            throw new DatabaseShutdownException();
        }
        transactionInfo.getLoginContext().authorize(LoginContext.IdLookup.EMPTY, transactionInfo.getSessionDatabaseId().name(), this.securityLog);
        FabricTransactionImpl fabricTransaction = new FabricTransactionImpl(transactionInfo, transactionBookmarkManager, this.remoteExecutor, this.localExecutor, this.errorReporter, this, this.fabricConfig);
        this.openTransactions.add(fabricTransaction);
        this.transactionMonitor.startMonitoringTransaction(fabricTransaction, transactionInfo);
        return fabricTransaction;
    }

    public void stop() {
        Collection<FabricTransactionImpl> nonLocalTransaction = this.collectNonLocalTransactions();
        if (nonLocalTransaction.isEmpty()) {
            return;
        }
        this.awaitTransactionsClosedWithinTimeout(nonLocalTransaction);
        nonLocalTransaction.forEach(tx -> tx.markForTermination((Status)Status.Transaction.Terminated));
    }

    private Collection<FabricTransactionImpl> collectNonLocalTransactions() {
        return this.openTransactions.stream().filter(tx -> !tx.isLocal()).collect(Collectors.toList());
    }

    private void awaitTransactionsClosedWithinTimeout(Collection<FabricTransactionImpl> nonLocalTransaction) {
        long deadline = this.clock.millis() + this.awaitActiveTransactionDeadlineMillis;
        while (TransactionManager.hasOpenTransactions(nonLocalTransaction) && this.clock.millis() < deadline) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    private static boolean hasOpenTransactions(Collection<FabricTransactionImpl> nonLocalTransaction) {
        for (FabricTransactionImpl fabricTransaction : nonLocalTransaction) {
            if (!fabricTransaction.isOpen()) continue;
            return true;
        }
        return false;
    }

    void removeTransaction(FabricTransactionImpl transaction) {
        this.openTransactions.remove(transaction);
        this.transactionMonitor.stopMonitoringTransaction(transaction);
    }

    public Set<FabricTransaction> getOpenTransactions() {
        return Collections.unmodifiableSet(this.openTransactions);
    }

    public Optional<FabricTransaction> findTransactionContaining(InternalTransaction transaction) {
        return this.openTransactions.stream().filter(tx -> tx.getInternalTransactions().stream().anyMatch(itx -> itx.kernelTransaction() == transaction.kernelTransaction())).map(FabricTransaction.class::cast).findFirst();
    }
}

