/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bootstrap;

import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.CustomBookmarkFormatParser;
import org.neo4j.bolt.txtracking.TransactionIdTracker;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.fabric.FabricDatabaseManager;
import org.neo4j.fabric.bolt.BoltFabricDatabaseManagementService;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerFactory;
import org.neo4j.fabric.bootstrap.FabricReactorHooksService;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.eval.CatalogManager;
import org.neo4j.fabric.eval.CommunityCatalogManager;
import org.neo4j.fabric.eval.DatabaseLookup;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.FabricDatabaseAccess;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.executor.FabricLocalExecutor;
import org.neo4j.fabric.executor.FabricRemoteExecutor;
import org.neo4j.fabric.executor.FabricStatementLifecycles;
import org.neo4j.fabric.executor.ThrowingFabricRemoteExecutor;
import org.neo4j.fabric.pipeline.SignatureResolver;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.FabricTransactionMonitor;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.CallableExecutor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.time.SystemNanoClock;

public abstract class FabricServicesBootstrap {
    private final FabricConfig fabricConfig;
    private final Dependencies dependencies;
    private final LogService logService;
    private final AbstractSecurityLog securityLog;
    private final ServiceBootstrapper serviceBootstrapper;
    private final Config config;
    private final AvailabilityGuard availabilityGuard;

    public FabricServicesBootstrap(LifeSupport lifeSupport, Dependencies dependencies, LogService logService, AbstractSecurityLog securityLog) {
        this.dependencies = dependencies;
        this.logService = logService;
        this.securityLog = securityLog;
        this.serviceBootstrapper = new ServiceBootstrapper(lifeSupport, dependencies);
        this.config = (Config)dependencies.resolveDependency(Config.class);
        this.availabilityGuard = (AvailabilityGuard)dependencies.resolveDependency(AvailabilityGuard.class);
        this.fabricConfig = this.bootstrapFabricConfig();
    }

    protected <T> T register(T dependency, Class<T> dependencyType) {
        return this.serviceBootstrapper.registerService(dependency, dependencyType);
    }

    protected <T> T resolve(Class<T> type) {
        return (T)this.dependencies.resolveDependency(type);
    }

    public void bootstrapServices() {
        LogProvider internalLogProvider = this.logService.getInternalLogProvider();
        DatabaseManager databaseManager = this.resolve(DatabaseManager.class);
        FabricDatabaseManager fabricDatabaseManager = this.register(this.createFabricDatabaseManager(this.fabricConfig), FabricDatabaseManager.class);
        JobScheduler jobScheduler = this.resolve(JobScheduler.class);
        Monitors monitors = this.resolve(Monitors.class);
        FabricDatabaseAccess databaseAccess = this.createFabricDatabaseAccess();
        FabricRemoteExecutor remoteExecutor = this.bootstrapRemoteStack();
        FabricLocalExecutor localExecutor = this.register(new FabricLocalExecutor(this.fabricConfig, fabricDatabaseManager, databaseAccess), FabricLocalExecutor.class);
        SystemNanoClock systemNanoClock = this.resolve(SystemNanoClock.class);
        FabricTransactionMonitor transactionMonitor = new FabricTransactionMonitor(systemNanoClock, this.logService, this.fabricConfig);
        long transactionCheckInterval = ((Duration)this.config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis();
        this.register(new TransactionMonitorScheduler((TransactionMonitor)transactionMonitor, jobScheduler, transactionCheckInterval, null), TransactionMonitorScheduler.class);
        ErrorReporter errorReporter = new ErrorReporter(this.logService);
        this.register(new TransactionManager(remoteExecutor, localExecutor, errorReporter, this.fabricConfig, transactionMonitor, this.securityLog, (Clock)systemNanoClock, this.config, this.availabilityGuard), TransactionManager.class);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)this.config);
        Supplier<GlobalProcedures> proceduresSupplier = () -> this.resolve(GlobalProcedures.class);
        CatalogManager catalogManager = this.register(this.createCatalogManger(), CatalogManager.class);
        SignatureResolver signatureResolver = new SignatureResolver(proceduresSupplier);
        FabricStatementLifecycles statementLifecycles = new FabricStatementLifecycles((DatabaseManager<DatabaseContext>)databaseManager, monitors, this.config, systemNanoClock);
        MonitoredJobExecutor monitoredExecutor = jobScheduler.monitoredJobExecutor(Group.CYPHER_CACHE);
        ExecutorBasedCaffeineCacheFactory cacheFactory = new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
        FabricPlanner planner = this.register(new FabricPlanner(this.fabricConfig, cypherConfig, monitors, (CaffeineCacheFactory)cacheFactory, signatureResolver), FabricPlanner.class);
        UseEvaluation useEvaluation = this.register(new UseEvaluation(catalogManager, proceduresSupplier, signatureResolver), UseEvaluation.class);
        this.register(new FabricReactorHooksService(errorReporter), FabricReactorHooksService.class);
        CallableExecutor fabricWorkerExecutor = jobScheduler.executor(Group.FABRIC_WORKER);
        FabricExecutor fabricExecutor = new FabricExecutor(this.fabricConfig, planner, useEvaluation, catalogManager, internalLogProvider, statementLifecycles, (Executor)fabricWorkerExecutor);
        this.register(fabricExecutor, FabricExecutor.class);
        this.register(new TransactionBookmarkManagerFactory(fabricDatabaseManager), TransactionBookmarkManagerFactory.class);
    }

    protected DatabaseLookup createDatabaseLookup() {
        Supplier<DatabaseManager<DatabaseContext>> databaseManagerProvider = () -> (DatabaseManager)this.dependencies.resolveDependency(DatabaseManager.class);
        return new DatabaseLookup.Default(databaseManagerProvider);
    }

    public BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider(final BoltGraphDatabaseManagementServiceSPI kernelDatabaseManagementService, DatabaseManagementService managementService, Monitors monitors, SystemNanoClock clock) {
        FabricExecutor fabricExecutor = (FabricExecutor)this.dependencies.resolveDependency(FabricExecutor.class);
        TransactionManager transactionManager = (TransactionManager)((Object)this.dependencies.resolveDependency(TransactionManager.class));
        final FabricDatabaseManager fabricDatabaseManager = (FabricDatabaseManager)this.dependencies.resolveDependency(FabricDatabaseManager.class);
        Config serverConfig = (Config)this.dependencies.resolveDependency(Config.class);
        TransactionIdTracker transactionIdTracker = new TransactionIdTracker(managementService, monitors, clock);
        DatabaseManager databaseManager = (DatabaseManager)this.dependencies.resolveDependency(DatabaseManager.class);
        DatabaseIdRepository.Caching databaseIdRepository = databaseManager.databaseIdRepository();
        TransactionBookmarkManagerFactory transactionBookmarkManagerFactory = (TransactionBookmarkManagerFactory)this.dependencies.resolveDependency(TransactionBookmarkManagerFactory.class);
        LocalGraphTransactionIdTracker localGraphTransactionIdTracker = new LocalGraphTransactionIdTracker(transactionIdTracker, (DatabaseIdRepository)databaseIdRepository, serverConfig);
        final BoltFabricDatabaseManagementService fabricDatabaseManagementService = (BoltFabricDatabaseManagementService)this.dependencies.satisfyDependency((Object)new BoltFabricDatabaseManagementService(fabricExecutor, this.fabricConfig, transactionManager, fabricDatabaseManager, localGraphTransactionIdTracker, transactionBookmarkManagerFactory));
        return new BoltGraphDatabaseManagementServiceSPI(){

            public BoltGraphDatabaseServiceSPI database(String databaseName, MemoryTracker memoryTracker) throws UnavailableException, DatabaseNotFoundException {
                if (fabricDatabaseManager.hasMultiGraphCapabilities(databaseName)) {
                    return fabricDatabaseManagementService.database(databaseName, memoryTracker);
                }
                return kernelDatabaseManagementService.database(databaseName, memoryTracker);
            }

            public Optional<CustomBookmarkFormatParser> getCustomBookmarkFormatParser() {
                return fabricDatabaseManagementService.getCustomBookmarkFormatParser();
            }
        };
    }

    protected abstract FabricDatabaseManager createFabricDatabaseManager(FabricConfig var1);

    protected abstract CatalogManager createCatalogManger();

    protected abstract FabricDatabaseAccess createFabricDatabaseAccess();

    protected abstract FabricRemoteExecutor bootstrapRemoteStack();

    protected abstract FabricConfig bootstrapFabricConfig();

    private static class ServiceBootstrapper {
        private final LifeSupport lifeSupport;
        private final Dependencies dependencies;

        ServiceBootstrapper(LifeSupport lifeSupport, Dependencies dependencies) {
            this.lifeSupport = lifeSupport;
            this.dependencies = dependencies;
        }

        <T> T registerService(T dependency, Class<T> dependencyType) {
            this.dependencies.satisfyDependency(dependency);
            if (LifecycleAdapter.class.isAssignableFrom(dependencyType)) {
                this.lifeSupport.add((Lifecycle)((LifecycleAdapter)dependency));
            }
            return (T)this.dependencies.resolveDependency(dependencyType);
        }
    }

    public static class Community
    extends FabricServicesBootstrap {
        public Community(LifeSupport lifeSupport, Dependencies dependencies, LogService logService) {
            super(lifeSupport, dependencies, logService, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        }

        @Override
        protected FabricDatabaseManager createFabricDatabaseManager(FabricConfig fabricConfig) {
            DatabaseManager databaseManager = this.resolve(DatabaseManager.class);
            return new FabricDatabaseManager.Community(fabricConfig, (DatabaseManager<DatabaseContext>)databaseManager);
        }

        @Override
        protected CatalogManager createCatalogManger() {
            DatabaseManagementService databaseManagementService = this.resolve(DatabaseManagementService.class);
            return new CommunityCatalogManager(this.createDatabaseLookup(), databaseManagementService);
        }

        @Override
        protected FabricDatabaseAccess createFabricDatabaseAccess() {
            return FabricDatabaseAccess.NO_RESTRICTION;
        }

        @Override
        protected FabricRemoteExecutor bootstrapRemoteStack() {
            return new ThrowingFabricRemoteExecutor();
        }

        @Override
        protected FabricConfig bootstrapFabricConfig() {
            Config config = this.resolve(Config.class);
            return FabricConfig.from(config);
        }
    }
}

