/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.config;

import java.time.Duration;
import java.util.Optional;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.fabric.config.FabricSettings;

public class FabricConfig {
    private final Duration transactionTimeout;
    private final DataStream dataStream;
    private final boolean routingEnabled;

    public FabricConfig(Duration transactionTimeout, DataStream dataStream, boolean routingEnabled) {
        this.transactionTimeout = transactionTimeout;
        this.dataStream = dataStream;
        this.routingEnabled = routingEnabled;
    }

    public Duration getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public DataStream getDataStream() {
        return this.dataStream;
    }

    public Optional<NormalizedDatabaseName> getFabricDatabaseName() {
        return Optional.empty();
    }

    public boolean isRoutingEnabled() {
        return this.routingEnabled;
    }

    public static FabricConfig from(Config config) {
        Duration transactionTimeout = (Duration)config.get(GraphDatabaseSettings.transaction_timeout);
        Integer syncBatchSize = (Integer)config.get(FabricSettings.batch_size_setting);
        DataStream dataStream = new DataStream(0, 0, syncBatchSize, 0);
        return new FabricConfig(transactionTimeout, dataStream, false);
    }

    public static class DataStream {
        private final int bufferLowWatermark;
        private final int bufferSize;
        private final int batchSize;
        private final int concurrency;

        public DataStream(int bufferLowWatermark, int bufferSize, int batchSize, int concurrency) {
            this.bufferLowWatermark = bufferLowWatermark > bufferSize ? bufferSize : bufferLowWatermark;
            this.bufferSize = bufferSize;
            this.batchSize = batchSize;
            this.concurrency = concurrency;
        }

        public int getBufferLowWatermark() {
            return this.bufferLowWatermark;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getConcurrency() {
            return this.concurrency;
        }
    }
}

