/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bookmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.fabric.bookmark.LocalBookmark;
import org.neo4j.fabric.bookmark.RemoteBookmark;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.util.VisibleForTesting;

public class TransactionBookmarkManagerImpl
implements TransactionBookmarkManager {
    private final QueryRouterBookmark submittedBookmark;
    private final Object finalBookmarkLock = new Object();
    private volatile QueryRouterBookmark finalBookmark;

    public TransactionBookmarkManagerImpl(List<QueryRouterBookmark> bookmarksSubmittedByClient) {
        this.submittedBookmark = TransactionBookmarkManagerImpl.merge(bookmarksSubmittedByClient);
        this.finalBookmark = new QueryRouterBookmark(new ArrayList<QueryRouterBookmark.InternalGraphState>(this.submittedBookmark.internalGraphStates()), new ArrayList<QueryRouterBookmark.ExternalGraphState>(this.submittedBookmark.externalGraphStates()));
    }

    @Override
    public Optional<LocalBookmark> getBookmarkForLocal(Location.Local location) {
        return this.submittedBookmark.internalGraphStates().stream().filter(egs -> egs.graphUuid().equals(location.getUuid())).map(QueryRouterBookmark.InternalGraphState::transactionId).map(LocalBookmark::new).findAny();
    }

    @Override
    public Optional<LocalBookmark> getBookmarkForLocalSystemDatabase() {
        return this.submittedBookmark.internalGraphStates().stream().filter(internalGraphState -> internalGraphState.graphUuid().equals(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID.databaseId().uuid())).map(internalGraphState -> new LocalBookmark(internalGraphState.transactionId())).findFirst();
    }

    @Override
    public List<RemoteBookmark> getBookmarksForRemote(Location.Remote location) {
        if (location instanceof Location.Remote.External) {
            return this.submittedBookmark.externalGraphStates().stream().filter(egs -> egs.graphUuid().equals(location.getUuid())).map(QueryRouterBookmark.ExternalGraphState::bookmarks).findAny().orElse(List.of());
        }
        String serializedBookmark = BookmarkFormat.serialize(this.submittedBookmark);
        return List.of(new RemoteBookmark(serializedBookmark));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remoteTransactionCommitted(Location.Remote location, RemoteBookmark bookmark) {
        if (bookmark == null) {
            return;
        }
        Object object = this.finalBookmarkLock;
        synchronized (object) {
            if (location instanceof Location.Remote.External) {
                QueryRouterBookmark.ExternalGraphState externalGraphState = new QueryRouterBookmark.ExternalGraphState(location.getUuid(), List.of(bookmark));
                QueryRouterBookmark bookmarkUpdate = new QueryRouterBookmark(List.of(), List.of(externalGraphState));
                this.finalBookmark = TransactionBookmarkManagerImpl.merge(List.of(this.finalBookmark, bookmarkUpdate));
            } else {
                QueryRouterBookmark parsedBookmark = BookmarkFormat.parse(bookmark.serializedState());
                this.finalBookmark = TransactionBookmarkManagerImpl.merge(List.of(this.finalBookmark, parsedBookmark));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localTransactionCommitted(Location.Local location, LocalBookmark bookmark) {
        Object object = this.finalBookmarkLock;
        synchronized (object) {
            QueryRouterBookmark.InternalGraphState internalGraphState = new QueryRouterBookmark.InternalGraphState(location.getUuid(), bookmark.transactionId());
            QueryRouterBookmark bookmarkUpdate = new QueryRouterBookmark(List.of(internalGraphState), List.of());
            this.finalBookmark = TransactionBookmarkManagerImpl.merge(List.of(this.finalBookmark, bookmarkUpdate));
        }
    }

    @Override
    public QueryRouterBookmark constructFinalBookmark() {
        return this.finalBookmark;
    }

    @VisibleForTesting
    public static QueryRouterBookmark merge(List<QueryRouterBookmark> queryRouterBookmarks) {
        List<QueryRouterBookmark.InternalGraphState> mergedInternalGraphStates = TransactionBookmarkManagerImpl.mergeInternalGraphStates(queryRouterBookmarks);
        List<QueryRouterBookmark.ExternalGraphState> mergedExternalGraphStates = TransactionBookmarkManagerImpl.mergeExternalGraphStates(queryRouterBookmarks);
        return new QueryRouterBookmark(mergedInternalGraphStates, mergedExternalGraphStates);
    }

    private static List<QueryRouterBookmark.InternalGraphState> mergeInternalGraphStates(List<QueryRouterBookmark> queryRouterBookmarks) {
        HashMap internalGraphTxIds = new HashMap();
        queryRouterBookmarks.stream().flatMap(fabricBookmark -> fabricBookmark.internalGraphStates().stream()).forEach(internalGraphState -> internalGraphTxIds.merge(internalGraphState.graphUuid(), internalGraphState.transactionId(), Math::max));
        return internalGraphTxIds.entrySet().stream().map(entry -> new QueryRouterBookmark.InternalGraphState((UUID)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    private static List<QueryRouterBookmark.ExternalGraphState> mergeExternalGraphStates(List<QueryRouterBookmark> queryRouterBookmarks) {
        HashMap externalGraphStates = new HashMap();
        queryRouterBookmarks.stream().flatMap(fabricBookmark -> fabricBookmark.externalGraphStates().stream()).forEach(externalGraphState -> externalGraphStates.computeIfAbsent(externalGraphState.graphUuid(), key -> new ArrayList()).addAll(externalGraphState.bookmarks()));
        return externalGraphStates.entrySet().stream().map(entry -> new QueryRouterBookmark.ExternalGraphState((UUID)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }
}

