/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.expressions.ExplicitParameter;
import org.neo4j.cypher.internal.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.logical.plans.TransactionForeach$;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.fabric.eval.Catalog;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.CallInTransactionsExecutorUtil;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FabricException;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.SingleQueryFragmentExecutor;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.planning.Fragment$Apply$;
import org.neo4j.fabric.stream.DelegatingFragmentResult;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.QueryInput;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.StatementResults;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import scala.jdk.javaapi.CollectionConverters;

class CallInTransactionsExecutor
extends SingleQueryFragmentExecutor {
    private final Fragment.Apply callInTransactions;
    private final Fragment.Exec innerFragment;
    private final QueryExecutionType resultExecutionType;
    private final int batchSize;
    private final List<BufferedInputRow> inputRowsBuffer;
    private Catalog.Graph batchGraph;
    private TransactionMode batchTransactionMode;
    private OnErrorBreakContext onErrorBreakContext;

    CallInTransactionsExecutor(Fragment.Apply callInTransactions, FabricPlanner.PlannerInstance plannerInstance, FabricTransaction.FabricExecutionContext ctx, UseEvaluation.Instance useEvaluator, FabricPlan plan, MapValue queryParams, AccessMode accessMode, QueryStatementLifecycles.StatementLifecycle lifecycle, QueryRoutingMonitor queryRoutingMonitor, SingleQueryFragmentExecutor.Tracer tracer, QueryExecutionType resultExecutionType, SingleQueryFragmentExecutor.FragmentExecutor fragmentExecutor) {
        super(plannerInstance, ctx, useEvaluator, plan, queryParams, accessMode, lifecycle, queryRoutingMonitor, tracer, fragmentExecutor);
        this.callInTransactions = callInTransactions;
        this.innerFragment = (Fragment.Exec)callInTransactions.inner();
        this.batchSize = this.batchSize();
        this.resultExecutionType = resultExecutionType;
        this.inputRowsBuffer = new ArrayList<BufferedInputRow>(this.batchSize);
        this.onErrorBreakContext = this.onErrorBreakContext();
    }

    private OnErrorBreakContext onErrorBreakContext() {
        SubqueryCall.InTransactionsParameters parameters = (SubqueryCall.InTransactionsParameters)this.callInTransactions.inTransactionsParameters().get();
        if (!CallInTransactionsExecutorUtil.isOnErrorBreak(parameters)) {
            return null;
        }
        int variableOffset = this.extractBreakReportVariableOffset(parameters);
        return new OnErrorBreakContext(variableOffset, parameters.reportParams().isEmpty(), false);
    }

    private int extractBreakReportVariableOffset(SubqueryCall.InTransactionsParameters parameters) {
        String variableName = (String)parameters.reportParams().map(reportParameters -> reportParameters.reportAs().name()).getOrElse(Fragment$Apply$.MODULE$::REPORT_VARIABLE);
        List columns = CollectionConverters.asJava(this.innerFragment.outputColumns());
        for (int i = 0; i < columns.size(); ++i) {
            if (!((String)columns.get(i)).equals(variableName)) continue;
            return i;
        }
        throw new IllegalStateException("Report variable not found among columns: " + String.valueOf(columns));
    }

    FragmentResult run(Record argument) {
        FragmentResult input = this.fragmentExecutor().run(this.callInTransactions.input(), argument);
        return new CallInTxFragmentResult(input);
    }

    private int batchSize() {
        return (Integer)this.callInTransactions.inTransactionsParameters().flatMap(SubqueryCall.InTransactionsParameters::batchParams).map(SubqueryCall.InTransactionsBatchParameters::batchSize).map(expression -> {
            if (expression instanceof SignedDecimalIntegerLiteral) {
                SignedDecimalIntegerLiteral literal = (SignedDecimalIntegerLiteral)expression;
                return literal.value().intValue();
            }
            if (expression instanceof ExplicitParameter) {
                ExplicitParameter parameter = (ExplicitParameter)expression;
                return this.batchSizeFromParam(parameter);
            }
            throw new IllegalArgumentException("Unexpected batch size expression: " + String.valueOf(expression));
        }).getOrElse(() -> (int)TransactionForeach$.MODULE$.defaultBatchSize());
    }

    private int batchSizeFromParam(ExplicitParameter parameter) {
        AnyValue paramValue = this.queryParams().get(parameter.name());
        if (paramValue instanceof LongValue) {
            LongValue longValue = (LongValue)paramValue;
            return (int)longValue.value();
        }
        if (paramValue instanceof IntegralValue) {
            IntegralValue integralValue = (IntegralValue)paramValue;
            return integralValue.intValue();
        }
        if (paramValue instanceof NoValue) {
            throw ParameterNotFoundException.expectedParam((String)parameter.name(), (Iterable)this.queryParams().keySet());
        }
        throw new FabricException((Status)Status.Statement.SyntaxError, "Type mismatch for parameter '%s': expected Integer but was %s".formatted(parameter.name(), paramValue.getTypeName()), new Object[0]);
    }

    private FragmentResult processInputRecord(Record argument) {
        if (this.onErrorBreakContext != null && this.onErrorBreakContext.breakExecution) {
            return this.produceBreakOutput(argument);
        }
        SingleQueryFragmentExecutor.PrepareResult prepareResult = this.prepare(this.innerFragment, argument);
        if (this.batchGraph == null) {
            this.batchGraph = prepareResult.graphWithNotification().graph();
            this.batchTransactionMode = prepareResult.transactionMode();
        }
        ArrayList<NotificationImplementation> notifications = new ArrayList<NotificationImplementation>();
        if (prepareResult.graphWithNotification().notification().isDefined()) {
            notifications.add((NotificationImplementation)prepareResult.graphWithNotification().notification().get());
        }
        if (!this.batchGraph.equals(prepareResult.graphWithNotification().graph())) {
            FragmentResult result = this.processBufferedInputRows(notifications);
            this.batchGraph = prepareResult.graphWithNotification().graph();
            this.batchTransactionMode = prepareResult.transactionMode();
            this.inputRowsBuffer.add(new BufferedInputRow(prepareResult.argumentValues(), argument));
            return result;
        }
        this.inputRowsBuffer.add(new BufferedInputRow(prepareResult.argumentValues(), argument));
        if (this.inputRowsBuffer.size() == this.batchSize) {
            return this.processBufferedInputRows(notifications);
        }
        return StatementResults.emptyFragment();
    }

    private FragmentResult produceBreakOutput(Record argument) {
        List columns = CollectionConverters.asJava(this.innerFragment.outputColumns());
        int columnCount = columns.size() - this.addedColumnsCount();
        ArrayList<AnyValue> values = new ArrayList<AnyValue>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (i == this.onErrorBreakContext.reportVariableOffset) {
                MapValueBuilder builder = new MapValueBuilder(4);
                builder.add("started", (AnyValue)BooleanValue.FALSE);
                builder.add("committed", (AnyValue)BooleanValue.FALSE);
                builder.add("transactionId", (AnyValue)NoValue.NO_VALUE);
                builder.add("errorMessage", (AnyValue)NoValue.NO_VALUE);
                values.add((AnyValue)builder.build());
                continue;
            }
            values.add((AnyValue)NoValue.NO_VALUE);
        }
        Record record = Records.join(argument, Records.of(values));
        return StatementResults.oneRecord(columns, record, this.resultExecutionType);
    }

    private FragmentResult processBufferedInputRows(List<NotificationImplementation> notifications) {
        if (this.inputRowsBuffer.isEmpty()) {
            return StatementResults.emptyFragment();
        }
        MapValue params = this.addParamsFromInputRows(this.batchGraph.name().name());
        FragmentResult result = this.doExecuteFragment(this.innerFragment, params, this.batchGraph, this.batchTransactionMode, StatementResults::emptyFragment, notifications);
        final ArrayList<BufferedInputRow> inputRecords = new ArrayList<BufferedInputRow>(this.inputRowsBuffer);
        DelegatingFragmentResult adjustedResult = new DelegatingFragmentResult(result){

            @Override
            public Record next() {
                Record outputRecord = super.next();
                if (outputRecord == null) {
                    return null;
                }
                if (CallInTransactionsExecutor.this.onErrorBreakContext != null) {
                    outputRecord = CallInTransactionsExecutor.this.checkBreakCondition(outputRecord);
                }
                if (CallInTransactionsExecutor.this.callInTransactions.outputColumns().isEmpty()) {
                    return CallInTransactionsExecutor.this.getMatchingInputRecord(outputRecord, inputRecords);
                }
                return Records.join(CallInTransactionsExecutor.this.getMatchingInputRecord(outputRecord, inputRecords), CallInTransactionsExecutor.this.stripAddedColumns(outputRecord));
            }
        };
        this.batchGraph = null;
        this.batchTransactionMode = null;
        this.inputRowsBuffer.clear();
        return adjustedResult;
    }

    private Record getMatchingInputRecord(Record outputRecord, List<BufferedInputRow> inputRecords) {
        int rowIdColumn = this.innerFragment.outputColumns().size() - 1;
        IntegralValue rowId = (IntegralValue)outputRecord.getValue(rowIdColumn);
        int rowIdAsInt = rowId instanceof LongValue ? (int)((LongValue)rowId).value() : rowId.intValue();
        return inputRecords.get((int)rowIdAsInt).record;
    }

    private Record stripAddedColumns(Record record) {
        int columnCount = record.size() - this.addedColumnsCount();
        AnyValue[] values = new AnyValue[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            values[i] = record.getValue(i);
        }
        return Records.of(values);
    }

    private int addedColumnsCount() {
        int addedColumnsCount = 1;
        if (this.onErrorBreakContext != null && this.onErrorBreakContext.reportVariableAdded) {
            ++addedColumnsCount;
        }
        return addedColumnsCount;
    }

    private Record checkBreakCondition(Record outputRecord) {
        AnyValue value = outputRecord.getValue(this.onErrorBreakContext.reportVariableOffset);
        MapValue mapValue = (MapValue)value;
        if (mapValue.get("errorMessage") != NoValue.NO_VALUE) {
            this.onErrorBreakContext = new OnErrorBreakContext(this.onErrorBreakContext.reportVariableOffset, this.onErrorBreakContext.reportVariableAdded, true);
        }
        return outputRecord;
    }

    private MapValue addParamsFromInputRows(String graphName) {
        List bindings = CollectionConverters.asJava(this.innerFragment.argumentColumns());
        ListValueBuilder rowListBuilder = ListValueBuilder.newListBuilder((int)this.inputRowsBuffer.size());
        for (int i = 0; i < this.inputRowsBuffer.size(); ++i) {
            MapValue rowParams = this.rowToParams(this.inputRowsBuffer.get(i), bindings, i, graphName);
            rowListBuilder.add((AnyValue)rowParams);
        }
        ListValue rows = rowListBuilder.build();
        MapValueBuilder builder = new MapValueBuilder(this.queryParams().size() + 1);
        this.queryParams().foreach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
        builder.add(Fragment$Apply$.MODULE$.CALL_IN_TX_ROWS(), (AnyValue)rows);
        return builder.build();
    }

    private MapValue rowToParams(BufferedInputRow inputRow, List<String> bindings, int rowId, String graphName) {
        MapValueBuilder builder = new MapValueBuilder(bindings.size() + 1);
        bindings.forEach(var -> builder.add(var, this.validateValue(inputRow.argumentValues().get(var), (String)var, graphName)));
        builder.add(Fragment$Apply$.MODULE$.CALL_IN_TX_ROW_ID(), (AnyValue)Values.intValue((int)rowId));
        return builder.build();
    }

    @Override
    FragmentResult runRemote(Location.Remote location, ExecutionOptions options, String query, TransactionMode transactionMode, MapValue params) {
        StatementResult result = this.ctx().getRemote().runInAutocommitTransaction(location, options, query, transactionMode, params);
        return StatementResults.toFragmentResult(result);
    }

    @Override
    FragmentResult runLocal(Location.Local location, TransactionMode transactionMode, QueryStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, final FragmentResult input, ExecutionOptions executionOptions, Boolean targetsComposite) {
        QueryInput queryInput = new QueryInput(){

            @Override
            public Record next() {
                return input.next();
            }

            @Override
            public void consume() {
                input.consume();
            }
        };
        StatementResult result = this.ctx().getLocal().runInAutocommitTransaction(location, parentLifecycle, query, params, queryInput, executionOptions);
        return StatementResults.toFragmentResult(result);
    }

    private record OnErrorBreakContext(int reportVariableOffset, boolean reportVariableAdded, boolean breakExecution) {
    }

    private class CallInTxFragmentResult
    implements FragmentResult {
        private FragmentResult currentBatch;
        private final FragmentResult input;
        private final List<Supplier<PlanlessSummary>> summaries = new ArrayList<Supplier<PlanlessSummary>>();
        private boolean inputExhausted = false;

        private CallInTxFragmentResult(FragmentResult input) {
            this.input = input;
            this.summaries.add(input::consume);
        }

        @Override
        public List<String> columns() {
            return CollectionConverters.asJava(CallInTransactionsExecutor.this.callInTransactions.outputColumns());
        }

        @Override
        public Record next() {
            Record inputRecord;
            if (this.currentBatch != null) {
                Record resultRecord = this.currentBatch.next();
                if (resultRecord != null || this.inputExhausted) {
                    return resultRecord;
                }
                this.currentBatch = null;
            }
            if ((inputRecord = this.input.next()) == null) {
                this.currentBatch = CallInTransactionsExecutor.this.processBufferedInputRows(new ArrayList<NotificationImplementation>());
                this.inputExhausted = true;
            } else {
                this.currentBatch = CallInTransactionsExecutor.this.processInputRecord(inputRecord);
            }
            this.summaries.add(this.currentBatch::consume);
            return this.next();
        }

        @Override
        public PlanlessSummary consume() {
            return this.summaries.stream().map(Supplier::get).reduce(PlanlessSummary::merge).orElse(null);
        }

        @Override
        public QueryExecutionType executionType() {
            return CallInTransactionsExecutor.this.resultExecutionType;
        }
    }

    private record BufferedInputRow(Map<String, AnyValue> argumentValues, Record record) {
    }
}

