/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.HashSet;
import java.util.List;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.MergedSummary;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.fabric.stream.summary.Summary;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.notifications.NotificationImplementation;
import org.neo4j.notifications.StandardGqlStatusObject;

class FabricExecutorResult
implements StatementResult {
    private final FragmentResult fragmentResult;
    private final List<NotificationImplementation> planNotifications;
    private final boolean produceResults;
    private final QueryStatementLifecycles.StatementLifecycle lifecycle;
    private StandardGqlStatusObject standardGqlStatusObject;

    FabricExecutorResult(FragmentResult fragmentResult, List<NotificationImplementation> planNotifications, boolean produceResults, QueryStatementLifecycles.StatementLifecycle lifecycle) {
        this.fragmentResult = fragmentResult;
        this.planNotifications = planNotifications;
        this.produceResults = produceResults;
        this.lifecycle = lifecycle;
        this.standardGqlStatusObject = produceResults ? StandardGqlStatusObject.NO_DATA : StandardGqlStatusObject.OMITTED_RESULT;
    }

    @Override
    public List<String> columns() {
        if (this.produceResults) {
            return this.fragmentResult.columns();
        }
        return List.of();
    }

    @Override
    public Record next() {
        try {
            if (this.produceResults) {
                Record record = this.fragmentResult.next();
                if (record == null) {
                    this.lifecycle.endSuccess();
                } else {
                    this.standardGqlStatusObject = StandardGqlStatusObject.SUCCESS;
                }
                return record;
            }
            while (this.fragmentResult.next() != null) {
            }
            this.lifecycle.endSuccess();
            return null;
        }
        catch (RuntimeException e) {
            this.lifecycle.endFailure(e);
            throw e;
        }
    }

    @Override
    public Summary consume() {
        PlanlessSummary executionSummary = this.fragmentResult.consume();
        HashSet<Notification> mergedNotifications = new HashSet<Notification>();
        mergedNotifications.addAll(this.planNotifications);
        mergedNotifications.addAll(executionSummary.getNotifications());
        HashSet<GqlStatusObject> mergedGqlStatusObjects = new HashSet<GqlStatusObject>();
        mergedGqlStatusObjects.addAll(this.planNotifications);
        mergedGqlStatusObjects.addAll(executionSummary.getGqlStatusObjects().stream().filter(gso -> !StandardGqlStatusObject.isStandardGqlStatusCode((String)gso.gqlStatus())).toList());
        mergedGqlStatusObjects.add((GqlStatusObject)this.standardGqlStatusObject);
        return new MergedSummary(null, executionSummary.getQueryStatistics(), mergedNotifications, mergedGqlStatusObjects);
    }

    @Override
    public QueryExecutionType executionType() {
        return this.fragmentResult.executionType();
    }
}

