/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.fabric.executor.RemoteBatchExecutor;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.graphdb.QueryExecutionType;

public class ApplyExecutor
implements FragmentResult {
    private final List<Supplier<PlanlessSummary>> summaries = new ArrayList<Supplier<PlanlessSummary>>();
    private final List<String> columns;
    private final ExtendedInput input;
    private final boolean unitInner;
    private final QueryExecutionType queryExecutionType;
    private final Function<Record, FragmentResult> fragmentExecutor;
    private final RemoteBatchExecutor remoteBatchExecutor;
    private FragmentResult currentBatch;

    public ApplyExecutor(List<String> columns, FragmentResult input, boolean unitInner, QueryExecutionType queryExecutionType, RemoteBatchExecutor remoteBatchExecutor, Function<Record, FragmentResult> fragmentExecutor, Function<Record, Boolean> targetsRemote) {
        this.columns = columns;
        this.input = new ExtendedInput(input, targetsRemote);
        this.unitInner = unitInner;
        this.queryExecutionType = queryExecutionType;
        this.remoteBatchExecutor = remoteBatchExecutor;
        this.fragmentExecutor = fragmentExecutor;
        this.summaries.add(this.input::consume);
    }

    @Override
    public List<String> columns() {
        return this.columns;
    }

    @Override
    public Record next() {
        InputRecordWithLocation nextInputRecord;
        if (this.currentBatch != null) {
            Record record = this.currentBatch.next();
            if (record != null) {
                return record;
            }
            this.currentBatch = null;
        }
        if ((nextInputRecord = this.input.peek()) == null) {
            return null;
        }
        if (nextInputRecord.targetsRemote) {
            this.currentBatch = this.remoteBatch();
        } else {
            InputRecordWithLocation inputRecord = this.input.next();
            FragmentResult inner = this.fragmentExecutor.apply(inputRecord.record);
            this.currentBatch = new LocalBatch(inputRecord.record, inner);
        }
        this.summaries.add(this.currentBatch::consume);
        return this.next();
    }

    private FragmentResult remoteBatch() {
        InputRecordWithLocation inputRecordWithLocation;
        ArrayList<Record> batchInput = new ArrayList<Record>();
        for (int i = 0; i < this.remoteBatchExecutor.batchSize() && (inputRecordWithLocation = this.input.peek()) != null && inputRecordWithLocation.targetsRemote; ++i) {
            batchInput.add(this.input.next().record);
        }
        return this.remoteBatchExecutor.execute(batchInput, this.unitInner);
    }

    @Override
    public PlanlessSummary consume() {
        return this.summaries.stream().map(Supplier::get).filter(Objects::nonNull).reduce(PlanlessSummary::merge).orElse(null);
    }

    @Override
    public QueryExecutionType executionType() {
        return this.queryExecutionType;
    }

    private static class ExtendedInput {
        private final FragmentResult input;
        private final Function<Record, Boolean> targetsRemote;
        private InputRecordWithLocation buffered;
        private boolean exhausted = false;

        private ExtendedInput(FragmentResult input, Function<Record, Boolean> targetsRemote) {
            this.input = input;
            this.targetsRemote = targetsRemote;
        }

        InputRecordWithLocation peek() {
            if (this.buffered != null) {
                return this.buffered;
            }
            if (this.exhausted) {
                return null;
            }
            this.buffered = this.readInput();
            if (this.buffered == null) {
                this.exhausted = true;
            }
            return this.buffered;
        }

        InputRecordWithLocation next() {
            if (this.buffered != null) {
                InputRecordWithLocation result = this.buffered;
                this.buffered = null;
                return result;
            }
            if (this.exhausted) {
                return null;
            }
            return this.readInput();
        }

        private InputRecordWithLocation readInput() {
            Record inputRecord = this.input.next();
            if (inputRecord == null) {
                return null;
            }
            return new InputRecordWithLocation(inputRecord, this.targetsRemote.apply(inputRecord));
        }

        PlanlessSummary consume() {
            return this.input.consume();
        }
    }

    private record InputRecordWithLocation(Record record, boolean targetsRemote) {
    }

    private class LocalBatch
    implements FragmentResult {
        private final Record inputRecord;
        private final FragmentResult innerResult;
        private boolean exhausted = false;

        LocalBatch(Record inputRecord, FragmentResult innerResult) {
            this.inputRecord = inputRecord;
            this.innerResult = innerResult;
        }

        @Override
        public List<String> columns() {
            return ApplyExecutor.this.columns;
        }

        @Override
        public Record next() {
            Record innerRecord = this.innerResult.next();
            if (innerRecord != null) {
                return Records.join(this.inputRecord, innerRecord);
            }
            if (ApplyExecutor.this.unitInner && !this.exhausted) {
                this.exhausted = true;
                return this.inputRecord;
            }
            return null;
        }

        @Override
        public PlanlessSummary consume() {
            return this.innerResult.consume();
        }

        @Override
        public QueryExecutionType executionType() {
            return this.innerResult.executionType();
        }
    }
}

