/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream.summary;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.notifications.StandardGqlStatusObject;

public record PlanlessSummary(Collection<Notification> getNotifications, Collection<GqlStatusObject> getGqlStatusObjects, QueryStatistics getQueryStatistics) {
    public static PlanlessSummary merge(PlanlessSummary summary1, PlanlessSummary summary2) {
        MergedQueryStatistics mergedStatistics = new MergedQueryStatistics();
        mergedStatistics.add(summary1.getQueryStatistics());
        mergedStatistics.add(summary2.getQueryStatistics());
        HashSet<Notification> mergedNotifications = new HashSet<Notification>();
        mergedNotifications.addAll(summary1.getNotifications());
        mergedNotifications.addAll(summary2.getNotifications());
        HashSet<GqlStatusObject> mergedGqlStatusObjects = new HashSet<GqlStatusObject>();
        mergedGqlStatusObjects.addAll(summary1.getGqlStatusObjects().stream().filter(gso -> !StandardGqlStatusObject.isStandardGqlStatusCode((String)gso.gqlStatus())).toList());
        mergedGqlStatusObjects.addAll(summary2.getGqlStatusObjects().stream().filter(gso -> !StandardGqlStatusObject.isStandardGqlStatusCode((String)gso.gqlStatus())).toList());
        return new PlanlessSummary(mergedNotifications, mergedGqlStatusObjects, mergedStatistics);
    }
}

