/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import org.neo4j.fabric.executor.FabricException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class Exceptions {
    public static RuntimeException transform(ErrorGqlStatusObject gqlStatusObject, Status defaultStatus, Throwable t) {
        return Exceptions.transform(gqlStatusObject, defaultStatus, t, null);
    }

    public static RuntimeException transform(ErrorGqlStatusObject fallbackGqlStatusObject, Status defaultStatus, Throwable t, Long queryId) {
        if (t instanceof Status.HasStatus) {
            Status.HasStatus withStatus = (Status.HasStatus)t;
            if (t instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)t;
                if (queryId == null) {
                    return runtimeException;
                }
                if (t instanceof HasQuery) {
                    HasQuery withQuery = (HasQuery)t;
                    withQuery.setQuery(queryId);
                    return runtimeException;
                }
            }
            if (t instanceof ErrorGqlStatusObject) {
                ErrorGqlStatusObject gqlStatusObjectOfUnwrapped = (ErrorGqlStatusObject)t;
                return new FabricException(gqlStatusObjectOfUnwrapped, withStatus.status(), t.getMessage(), t, queryId);
            }
            return new FabricException(withStatus.status(), t.getMessage(), t, queryId);
        }
        return new FabricException(fallbackGqlStatusObject, defaultStatus, t.getMessage(), t, queryId);
    }

    public static RuntimeException transformTransactionStartFailure(Throwable t) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N06).build();
        return Exceptions.transform(gql, (Status)Status.Transaction.TransactionStartFailed, t);
    }

    public static RuntimeException transformUnexpectedError(Status defaultStatus, Throwable t) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return Exceptions.transform(gql, defaultStatus, t);
    }

    public static RuntimeException transformUnexpectedError(Status defaultStatus, Throwable t, long queryId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N42).build();
        return Exceptions.transform(gql, defaultStatus, t, queryId);
    }
}

