/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.stream;

import org.neo4j.cypher.internal.runtime.InputCursor;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.fabric.stream.QueryInput;
import org.neo4j.fabric.stream.Record;
import org.neo4j.values.AnyValue;

public class InputDataStreamImpl
implements InputDataStream {
    private final QueryInput input;
    private InputCursor inputCursor;

    public InputDataStreamImpl(QueryInput input) {
        this.input = input;
        this.inputCursor = new Cursor();
    }

    public InputCursor nextInputBatch() {
        return this.inputCursor;
    }

    private class Cursor
    implements InputCursor {
        private Record currentRecord;

        private Cursor() {
        }

        public boolean next() {
            this.currentRecord = InputDataStreamImpl.this.input.next();
            if (this.currentRecord != null) {
                return true;
            }
            InputDataStreamImpl.this.inputCursor = null;
            return false;
        }

        public AnyValue value(int offset) {
            return this.currentRecord.getValue(offset);
        }

        public void close() {
            InputDataStreamImpl.this.input.consume();
        }
    }
}

