/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.bolt;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecution;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.fabric.bolt.BoltQueryExecutionImpl;
import org.neo4j.fabric.bolt.QueryRouterBookmark;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerImpl;
import org.neo4j.fabric.bootstrap.TestOverrides;
import org.neo4j.fabric.config.FabricConfig;
import org.neo4j.fabric.executor.FabricExecutor;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.FabricTransactionInfo;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.MapValue;

public class BoltFabricDatabaseService
implements BoltGraphDatabaseServiceSPI {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltFabricDatabaseService.class);
    private static final long BOLT_TRANSACTION_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltTransactionImpl.class);
    private final FabricExecutor fabricExecutor;
    private final DatabaseReference databaseReference;
    private final FabricConfig config;
    private final TransactionManager transactionManager;
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private final MemoryTracker memoryTracker;

    public BoltFabricDatabaseService(DatabaseReference databaseReference, FabricExecutor fabricExecutor, FabricConfig config, TransactionManager transactionManager, LocalGraphTransactionIdTracker transactionIdTracker, MemoryTracker memoryTracker) {
        this.databaseReference = databaseReference;
        this.config = config;
        this.transactionManager = transactionManager;
        this.fabricExecutor = fabricExecutor;
        this.transactionIdTracker = transactionIdTracker;
        this.memoryTracker = memoryTracker;
    }

    public BoltTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, List<String> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext, QueryExecutionConfiguration queryExecutionConfiguration) {
        this.memoryTracker.allocateHeap(BOLT_TRANSACTION_SHALLOW_SIZE);
        if (txTimeout == null) {
            txTimeout = this.config.getTransactionTimeout();
        }
        FabricTransactionInfo transactionInfo = new FabricTransactionInfo(accessMode, loginContext, clientInfo, this.databaseReference, KernelTransaction.Type.IMPLICIT == type, txTimeout, txMetadata, TestOverrides.routingContext(routingContext), queryExecutionConfiguration);
        List<QueryRouterBookmark> parsedBookmarks = BookmarkFormat.parse(bookmarks);
        TransactionBookmarkManagerImpl transactionBookmarkManager = new TransactionBookmarkManagerImpl(parsedBookmarks);
        transactionBookmarkManager.getBookmarkForLocalSystemDatabase().ifPresent(localBookmark -> this.transactionIdTracker.awaitSystemGraphUpToDate(localBookmark.transactionId()));
        FabricTransaction fabricTransaction = this.transactionManager.begin(transactionInfo, transactionBookmarkManager);
        return new BoltTransactionImpl(transactionInfo, fabricTransaction);
    }

    public DatabaseReference getDatabaseReference() {
        return this.databaseReference;
    }

    public class BoltTransactionImpl
    implements BoltTransaction {
        private final FabricTransaction fabricTransaction;

        BoltTransactionImpl(FabricTransactionInfo transactionInfo, FabricTransaction fabricTransaction) {
            this.fabricTransaction = fabricTransaction;
        }

        public void commit() {
            this.fabricTransaction.commit();
        }

        public void rollback() {
            this.fabricTransaction.rollback();
        }

        public void close() {
        }

        public void markForTermination(Status reason) {
            this.fabricTransaction.markForTermination(reason);
        }

        public void markForTermination() {
            this.fabricTransaction.markForTermination((Status)Status.Transaction.Terminated);
        }

        public Optional<Status> getReasonIfTerminated() {
            return this.fabricTransaction.getReasonIfTerminated();
        }

        public String getBookmark() {
            QueryRouterBookmark bookmark = this.fabricTransaction.getBookmarkManager().constructFinalBookmark();
            return BookmarkFormat.serialize(bookmark);
        }

        public BoltQueryExecution executeQuery(String query, MapValue parameters, boolean prePopulate, QuerySubscriber subscriber) {
            StatementResult statementResult = BoltFabricDatabaseService.this.fabricExecutor.run(this.fabricTransaction, query, parameters);
            BoltQueryExecutionImpl queryExecution = new BoltQueryExecutionImpl(statementResult, subscriber);
            try {
                queryExecution.initialize();
            }
            catch (Exception e) {
                QuerySubscriber.safelyOnError((QuerySubscriber)subscriber, (Throwable)e);
            }
            return queryExecution;
        }

        @Deprecated
        public FabricTransaction getFabricTransaction() {
            return this.fabricTransaction;
        }
    }
}

