/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.time.format.DateTimeParseException;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class TemporalParseException
extends SyntaxException {
    private TemporalParseException(ErrorGqlStatusObject gqlStatusObject, String errorMsg, Throwable cause) {
        super(gqlStatusObject, errorMsg, cause);
    }

    private TemporalParseException(ErrorGqlStatusObject gqlStatusObject, String errorMsg, String parsedData, int errorIndex) {
        super(gqlStatusObject, errorMsg, parsedData, errorIndex);
    }

    private TemporalParseException(ErrorGqlStatusObject gqlStatusObject, String errorMsg, String parsedData, int errorIndex, Throwable cause) {
        super(gqlStatusObject, errorMsg, parsedData, errorIndex, cause);
    }

    public static TemporalParseException cannotProcessDateTime(String input, Throwable e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N11).withParam(GqlParams.StringParam.input, input).build()).build();
        return new TemporalParseException(gql, e.getMessage(), e);
    }

    public static TemporalParseException cannotParseText(String type, String text) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N36((String)text, (String)type);
        return new TemporalParseException(gql, "Text cannot be parsed to a " + type, text, 0);
    }

    public static TemporalParseException cannotParseToDateHint(String input) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22007).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N35).withParam(GqlParams.StringParam.input, input).build()).build();
        return new TemporalParseException(gql, "Text cannot be parsed to a Date. Hint, year+month needs to have two digits for month (e.g. 2015-02) and ordinal dates three digits (e.g. 2015-032).", null);
    }

    public static TemporalParseException failedToProcessDateTime(String prettyValue, DateTimeParseException e) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)prettyValue);
        return new TemporalParseException(gql, e.getMessage(), e.getParsedString(), e.getErrorIndex(), (Throwable)e);
    }

    public static TemporalParseException cannotProcessCause(String value, Throwable e) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)value);
        return new TemporalParseException(gql, e.getMessage(), e);
    }

    public static TemporalParseException invalidTimeZone(String timeZone, DateTimeParseException e) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)timeZone);
        return new TemporalParseException(gql, "Invalid value for TimeZone: " + e.getMessage(), e.getParsedString(), e.getErrorIndex(), (Throwable)e);
    }
}

