/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.log4j.LogConfig;

class LoggingSettingsMigrator {
    private static final String DEFAULT_PLAIN_LAYOUT = "PatternLayout";
    private final Map<String, String> rawConfig;
    private final PrintStream out;
    private final Path destinationConfigFile;

    LoggingSettingsMigrator(PrintStream out, Path destinationConfigFile, Map<String, String> rawConfig) {
        this.out = out;
        this.destinationConfigFile = destinationConfigFile;
        this.rawConfig = rawConfig;
        if (this.rawConfig.containsKey("dbms.directories.neo4j_home")) {
            this.rawConfig.put(GraphDatabaseSettings.neo4j_home.name(), this.rawConfig.get("dbms.directories.neo4j_home"));
        }
        if (this.rawConfig.containsKey("dbms.directories.logs")) {
            this.rawConfig.put(GraphDatabaseSettings.logs_directory.name(), this.rawConfig.get("dbms.directories.logs"));
        }
    }

    public void migrate() throws IOException {
        Path userLogsXlm = this.destinationConfigFile.resolveSibling("user-logs.xml");
        this.preserveOriginal(userLogsXlm);
        String migratedUserLogs = this.migratedUserLogs();
        Files.writeString(userLogsXlm, (CharSequence)migratedUserLogs, new OpenOption[0]);
        this.out.println("User logging configuration xml file generated: " + userLogsXlm);
        Path serverLogsXlm = this.destinationConfigFile.resolveSibling("server-logs.xml");
        this.preserveOriginal(serverLogsXlm);
        String migratedServerLogs = this.migratedServerLogs();
        Files.writeString(serverLogsXlm, (CharSequence)migratedServerLogs, new OpenOption[0]);
        this.out.println("Server logging configuration xml file generated: " + serverLogsXlm);
    }

    private void preserveOriginal(Path configFile) throws IOException {
        if (Files.exists(configFile, new LinkOption[0])) {
            Path preservedFilePath = configFile.getParent().resolve(configFile.getFileName() + ".old");
            this.out.println("Keeping original " + configFile.getFileName() + " file at: " + preservedFilePath);
            Files.move(configFile, preservedFilePath, new CopyOption[0]);
        }
    }

    private String migratedUserLogs() {
        StringBuilder sb = new StringBuilder();
        this.appendHeader(sb);
        this.appendAppender(sb, "Neo4jLog", this.getRelativeFileName(OldSettings.store_user_log_path), this.getSettingValue(OldSettings.store_user_log_rotation_threshold), this.getSettingValue(OldSettings.store_user_log_max_archives), DEFAULT_PLAIN_LAYOUT, this.getSettingValue(OldSettings.store_user_log_format), "classpath:org/neo4j/logging/StructuredLayoutWithMessage.json", false);
        sb.append("\n        <!-- Only used by \"neo4j console\", will be ignored otherwise -->\n");
        sb.append(String.format("        <Console name=\"ConsoleAppender\" target=\"SYSTEM_OUT\">%n", new Object[0]));
        this.addLayout(sb, this.getSettingValue(OldSettings.store_user_log_format), DEFAULT_PLAIN_LAYOUT, "classpath:org/neo4j/logging/StructuredLayoutWithMessage.json", false);
        sb.append("        </Console>\n    </Appenders>\n\n    <Loggers>\n        <!-- Log level for the neo4j log. One of DEBUG, INFO, WARN, ERROR or OFF -->\n        <Root level=\"INFO\">\n            <AppenderRef ref=\"Neo4jLog\"/>\n            <AppenderRef ref=\"ConsoleAppender\"/>\n        </Root>\n    </Loggers>\n</Configuration>\n\n");
        return sb.toString();
    }

    private String migratedServerLogs() {
        StringBuilder sb = new StringBuilder();
        this.appendHeader(sb);
        this.appendAppender(sb, "DebugLog", this.getRelativeFileName(OldSettings.store_internal_log_path), this.getSettingValue(OldSettings.store_internal_log_rotation_threshold), this.getSettingValue(OldSettings.store_internal_log_max_archives), "Neo4jDebugLogLayout", this.getSettingValue(OldSettings.store_internal_log_format), "classpath:org/neo4j/logging/StructuredLayoutWithCategory.json", true);
        this.appendAppender(sb, "HttpLog", this.getRelativeFileName(OldSettings.http_log_path), this.getSettingValue(OldSettings.http_logging_rotation_size), this.getSettingValue(OldSettings.http_logging_rotation_keep_number), DEFAULT_PLAIN_LAYOUT, this.getSettingValue(OldSettings.http_log_format), "classpath:org/neo4j/logging/StructuredLayoutWithMessage.json", false);
        this.appendAppender(sb, "QueryLog", this.getRelativeFileName(OldSettings.log_queries_filename), this.getSettingValue(OldSettings.log_queries_rotation_threshold), this.getSettingValue(OldSettings.log_queries_max_archives), DEFAULT_PLAIN_LAYOUT, this.getSettingValue(OldSettings.log_query_format), "classpath:org/neo4j/logging/QueryLogJsonLayout.json", false);
        this.appendAppender(sb, "SecurityLog", this.getRelativeFileName(OldSettings.security_log_filename), this.getSettingValue(OldSettings.store_security_log_rotation_threshold), this.getSettingValue(OldSettings.store_security_log_max_archives), DEFAULT_PLAIN_LAYOUT, this.getSettingValue(OldSettings.security_log_format), "classpath:org/neo4j/logging/StructuredJsonLayout.json", false);
        sb.append("    </Appenders>\n\n    <Loggers>\n        <!-- Log levels. One of DEBUG, INFO, WARN, ERROR or OFF -->\n\n        <!-- The debug log is used as the root logger to catch everything -->\n");
        sb.append(String.format("        <Root level=\"%s\">%n", this.getSettingValue(OldSettings.store_internal_log_level)));
        sb.append("            <AppenderRef ref=\"DebugLog\"/> <!-- Keep this -->\n        </Root>\n\n        <!-- The query log, must be named \"QueryLogger\" -->\n        <Logger name=\"QueryLogger\" level=\"INFO\" additivity=\"false\">\n            <AppenderRef ref=\"QueryLog\"/>\n        </Logger>\n\n        <!-- The http request log, must be named \"HttpLogger\" -->\n        <Logger name=\"HttpLogger\" level=\"INFO\" additivity=\"false\">\n            <AppenderRef ref=\"HttpLog\"/>\n        </Logger>\n\n        <!-- The security log, must be named \"SecurityLogger\" -->\n");
        sb.append(String.format("        <Logger name=\"SecurityLogger\" level=\"%s\" additivity=\"false\">%n", this.getSettingValue(OldSettings.security_log_level)));
        sb.append("            <AppenderRef ref=\"SecurityLog\"/>\n        </Logger>\n    </Loggers>\n</Configuration>\n\n");
        return sb.toString();
    }

    private void appendAppender(StringBuilder sb, String appenderName, String fileName, long rotationSize, int numFiles, String plainLayout, FormattedLogFormat logFormat, String jsonTemplate, boolean includeCategory) {
        if (rotationSize == 0L) {
            sb.append(String.format("        <RandomAccessFile name=\"%s\" fileName=\"%s\">%n", appenderName, fileName));
            this.addLayout(sb, logFormat, plainLayout, jsonTemplate, includeCategory);
            sb.append(String.format("        </RandomAccessFile>%n", new Object[0]));
        } else {
            sb.append(String.format("        <RollingRandomAccessFile name=\"%s\" fileName=\"%s\"%n", appenderName, fileName));
            sb.append(String.format("                filePattern=\"%s.%%02i\">%n", fileName));
            sb.append(String.format("            <Policies>%n", new Object[0]));
            sb.append(String.format("                <SizeBasedTriggeringPolicy size=\"%s\"/>%n", FileUtils.byteCountToDisplaySize((long)rotationSize)));
            sb.append(String.format("            </Policies>%n", new Object[0]));
            sb.append(String.format("            <DefaultRolloverStrategy fileIndex=\"min\" max=\"%d\"/>%n", numFiles));
            this.addLayout(sb, logFormat, plainLayout, jsonTemplate, includeCategory);
            sb.append(String.format("        </RollingRandomAccessFile>%n", new Object[0]));
        }
    }

    private void addLayout(StringBuilder sb, FormattedLogFormat logFormat, String plainLayout, String jsonTemplate, boolean includeCategory) {
        if (logFormat == FormattedLogFormat.PLAIN) {
            sb.append("            <").append(plainLayout).append(" pattern=\"").append(LogConfig.getFormatPattern((boolean)includeCategory, (LogTimeZone)((LogTimeZone)this.getSettingValue(GraphDatabaseSettings.db_timezone)))).append(String.format("\"/>%n", new Object[0]));
        } else {
            sb.append(String.format("            <JsonTemplateLayout eventTemplateUri=\"%s\"/>%n", jsonTemplate));
        }
    }

    private void appendHeader(StringBuilder sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n    This is a log4j 2 configuration file that provides maximum flexibility.\n\n    All configuration values can be queried with the lookup prefix \"config:\". You can for example, resolve\n    the path to your neo4j home directory with ${config:dbms.directories.neo4j_home}.\n\n    Please consult https://logging.apache.org/log4j/2.x/manual/configuration.html for instructions and\n    available configuration options.\n-->\n<Configuration status=\"ERROR\" monitorInterval=\"30\" packages=\"org.neo4j.logging.log4j\">\n    <Appenders>\n");
    }

    private String getRelativeFileName(Setting<Path> pathSetting) {
        Path logDirectory = (Path)this.getSettingValue(GraphDatabaseSettings.logs_directory);
        return "${config:server.directories.logs}/" + logDirectory.relativize(this.getSettingValue(pathSetting)).toString().replace('\\', '/');
    }

    private <T> T getSettingValue(Setting<T> setting) {
        SettingImpl impl = (SettingImpl)setting;
        String value = this.rawConfig.get(impl.name());
        Object v = value != null ? impl.parse(value) : impl.defaultValue();
        SettingImpl dependency = impl.dependency();
        if (dependency != null) {
            return (T)impl.parser().solveDependency(v, this.getSettingValue((Setting<T>)dependency));
        }
        return (T)v;
    }

    private static final class OldSettings {
        private static final Setting<FormattedLogFormat> default_log_format = SettingImpl.newBuilder((String)"dbms.logs.default_format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), (Object)FormattedLogFormat.PLAIN).immutable().build();
        static final Setting<FormattedLogFormat> store_user_log_format = SettingImpl.newBuilder((String)"dbms.logs.user.format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
        static final Setting<Path> store_user_log_path = SettingImpl.newBuilder((String)"dbms.logs.user.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("neo4j.log", new String[0])).setDependency(GraphDatabaseSettings.logs_directory).immutable().build();
        static final Setting<Integer> store_user_log_max_archives = SettingImpl.newBuilder((String)"dbms.logs.user.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)7).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
        static final Setting<Long> store_user_log_rotation_threshold = SettingImpl.newBuilder((String)"dbms.logs.user.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)0L).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).build();
        static final Setting<FormattedLogFormat> store_internal_log_format = SettingImpl.newBuilder((String)"dbms.logs.debug.format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
        static final Setting<Level> store_internal_log_level = SettingImpl.newBuilder((String)"dbms.logs.debug.level", (SettingValueParser)SettingValueParsers.ofEnum(Level.class), (Object)Level.INFO).dynamic().build();
        static final Setting<Path> store_internal_log_path = SettingImpl.newBuilder((String)"dbms.logs.debug.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("debug.log", new String[0])).setDependency(GraphDatabaseSettings.logs_directory).immutable().build();
        static final Setting<Integer> store_internal_log_max_archives = SettingImpl.newBuilder((String)"dbms.logs.debug.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)7).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
        static final Setting<Long> store_internal_log_rotation_threshold = SettingImpl.newBuilder((String)"dbms.logs.debug.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).build();
        static final Setting<FormattedLogFormat> http_log_format = SettingImpl.newBuilder((String)"dbms.logs.http.format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
        static final Setting<Path> http_log_path = SettingImpl.newBuilder((String)"dbms.logs.http.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("http.log", new String[0])).setDependency(GraphDatabaseSettings.logs_directory).immutable().build();
        static final Setting<Integer> http_logging_rotation_keep_number = SettingImpl.newBuilder((String)"dbms.logs.http.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)5).build();
        static final Setting<Long> http_logging_rotation_size = SettingImpl.newBuilder((String)"dbms.logs.http.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).build();
        static final Setting<FormattedLogFormat> log_query_format = SettingImpl.newBuilder((String)"dbms.logs.query.format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
        static final Setting<Path> log_queries_filename = SettingImpl.newBuilder((String)"dbms.logs.query.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("query.log", new String[0])).setDependency(GraphDatabaseSettings.logs_directory).immutable().build();
        static final Setting<Integer> log_queries_max_archives = SettingImpl.newBuilder((String)"dbms.logs.query.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)7).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).dynamic().build();
        static final Setting<Long> log_queries_rotation_threshold = SettingImpl.newBuilder((String)"dbms.logs.query.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).dynamic().build();
        static final Setting<FormattedLogFormat> security_log_format = SettingImpl.newBuilder((String)"dbms.logs.security.format", (SettingValueParser)SettingValueParsers.ofEnum(FormattedLogFormat.class), null).setDependency(default_log_format).build();
        static final Setting<Level> security_log_level = SettingImpl.newBuilder((String)"dbms.logs.security.level", (SettingValueParser)SettingValueParsers.ofEnum(Level.class), (Object)Level.INFO).build();
        static final Setting<Path> security_log_filename = SettingImpl.newBuilder((String)"dbms.logs.security.path", (SettingValueParser)SettingValueParsers.PATH, (Object)Path.of("security.log", new String[0])).immutable().setDependency(GraphDatabaseSettings.logs_directory).build();
        static final Setting<Integer> store_security_log_max_archives = SettingImpl.newBuilder((String)"dbms.logs.security.rotation.keep_number", (SettingValueParser)SettingValueParsers.INT, (Object)7).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
        static final Setting<Long> store_security_log_rotation_threshold = SettingImpl.newBuilder((String)"dbms.logs.security.rotation.size", (SettingValueParser)SettingValueParsers.BYTES, (Object)ByteUnit.mebiBytes((long)20L)).addConstraint(SettingConstraints.range((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Long.MAX_VALUE))).build();

        private OldSettings() {
        }
    }
}

