/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.neo4j.annotations.service.Service;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StorageEngineFactory;

@Service
public interface CheckDatabase {
    public static DatabaseLayout selectAndExtract(FileSystemAbstraction fs, Source source, NormalizedDatabaseName database, PrintStream out, boolean force, IOUtils.AutoCloseables autoCloseables) throws IOException {
        for (CheckDatabase checkDatabase : CheckDatabase.all()) {
            if (!checkDatabase.containsPotentiallyCheckableDatabase(fs, source, database)) continue;
            try {
                DatabaseLayout targetLayout = checkDatabase.targetLayoutFrom(fs, source, database, autoCloseables);
                checkDatabase.tryExtract(fs, targetLayout, source, database, out, force);
                StorageEngineFactory storageEngineFactory = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)fs, (DatabaseLayout)targetLayout).orElseThrow(() -> new IllegalArgumentException("No storage engine found for '%s' with database name '%s'".formatted(targetLayout.getNeo4jLayout(), targetLayout.getDatabaseName())));
                return storageEngineFactory.formatSpecificDatabaseLayout(targetLayout);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid input for a " + checkDatabase.getClass().getSimpleName(), e);
            }
        }
        throw new IllegalArgumentException("Could not find a valid %s named '%s' to check at %s".formatted(CheckDatabase.allNames("or"), database.name(), source));
    }

    public String name();

    public boolean containsPotentiallyCheckableDatabase(FileSystemAbstraction var1, Source var2, NormalizedDatabaseName var3);

    public DatabaseLayout targetLayoutFrom(FileSystemAbstraction var1, Source var2, NormalizedDatabaseName var3, IOUtils.AutoCloseables var4) throws IOException, CannotWriteException;

    public void tryExtract(FileSystemAbstraction var1, DatabaseLayout var2, Source var3, NormalizedDatabaseName var4, PrintStream var5, boolean var6) throws Exception;

    public static Collection<CheckDatabase> all() {
        return Services.loadAll(CheckDatabase.class);
    }

    private static String allNames(String logical) {
        TreeSet namesSet = new TreeSet();
        CheckDatabase.all().forEach(check -> namesSet.add(check.name()));
        Iterator names = namesSet.iterator();
        if (!names.hasNext()) {
            throw new IllegalStateException("At least one %s is expected".formatted(CheckDatabase.class.getSimpleName()));
        }
        StringBuilder sb = new StringBuilder((String)names.next());
        while (names.hasNext()) {
            sb.append(", ");
            String name = (String)names.next();
            if (!names.hasNext()) {
                sb.append(logical).append(" ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Source {
        public final Neo4jLayout layout;

        public Source(Neo4jLayout layout) {
            this.layout = layout;
        }

        public static <S extends Source> S expected(Class<S> clazz, Source source) {
            if (!clazz.isInstance(source)) {
                throw new IllegalStateException("Expected a %s, however was given a %s.".formatted(clazz.getName(), source != null ? source.getClass().getName() : null));
            }
            return (S)((Source)clazz.cast(source));
        }

        public static final class DataTxnSource
        extends Source {
            public DataTxnSource(Config config) {
                this((Path)config.get(GraphDatabaseSettings.neo4j_home), (Path)config.get(GraphDatabaseSettings.data_directory), (Path)config.get(GraphDatabaseSettings.transaction_logs_root_path), (Path)config.get(GraphDatabaseInternalSettings.databases_root_path));
            }

            public DataTxnSource(Path dataPath, Path txnPath) {
                this(dataPath, dataPath, txnPath, dataPath);
            }

            public DataTxnSource(Path neo4jHome, Path data, Path transactionLogsRoot, Path databasesRoot) {
                super(Neo4jLayout.of((Configuration)Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)neo4jHome.toAbsolutePath().normalize()).set(GraphDatabaseSettings.data_directory, (Object)data.toAbsolutePath().normalize()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)transactionLogsRoot.toAbsolutePath().normalize()).set(GraphDatabaseInternalSettings.databases_root_path, (Object)databasesRoot.toAbsolutePath().normalize()).build()));
            }

            public String toString() {
                return "databases path: '%s', transaction log path: '%s'".formatted(this.layout.databasesDirectory(), this.layout.transactionLogsRootDirectory());
            }
        }

        public static final class PathSource
        extends Source {
            public final Path path;
            public final Path tmpRoot;

            public PathSource(Path path) {
                this(path, null);
            }

            public PathSource(Path path, Path tmpRoot) {
                super(Neo4jLayout.ofFlat((Path)path.toAbsolutePath().normalize()));
                this.path = path.toAbsolutePath().normalize();
                this.tmpRoot = tmpRoot != null ? tmpRoot.toAbsolutePath().normalize() : null;
            }

            public TempDir createTemporaryDirectory(FileSystemAbstraction fs) throws CannotWriteException, IOException {
                if (fs.fileExists(this.tmpRoot) && !Files.isWritable(this.tmpRoot)) {
                    throw new CannotWriteException(this.tmpRoot);
                }
                return new TempDir(fs, this.tmpRoot);
            }

            public String toString() {
                return "path: '%s'".formatted(this.path);
            }
        }
    }

    public static class TempDir
    implements AutoCloseable {
        private final FileSystemAbstraction fs;
        public final Path path;

        public TempDir(FileSystemAbstraction fs) throws IOException {
            this(fs, null);
        }

        public TempDir(FileSystemAbstraction fs, Path dir) throws IOException {
            this.fs = fs;
            this.path = dir != null ? fs.createTempDirectory(dir, null) : fs.createTempDirectory(null);
        }

        @Override
        public void close() throws IOException {
            this.fs.deleteRecursively(this.path);
        }
    }
}

