/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.jutils.jprocesses.JProcesses;
import org.jutils.jprocesses.model.ProcessInfo;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.Converters;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseNamePattern;
import org.neo4j.dbms.diagnostics.jmx.JMXDumper;
import org.neo4j.dbms.diagnostics.jmx.JmxDump;
import org.neo4j.dbms.diagnostics.profile.ProfileCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSource;
import org.neo4j.kernel.diagnostics.DiagnosticsReportSources;
import org.neo4j.kernel.diagnostics.DiagnosticsReporter;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;
import org.neo4j.kernel.diagnostics.InteractiveProgress;
import org.neo4j.kernel.diagnostics.NonInteractiveProgress;
import picocli.CommandLine;

@CommandLine.Command(name="report", header={"Produces a zip/tar of the most common information needed for remote assessments."}, description={"Will collect information about the system and package everything in an archive. If you specify 'all', everything will be included. You can also fine tune the selection by passing classifiers to the tool, e.g 'logs tx threads'."}, subcommands={ProfileCommand.class})
public class DiagnosticsReportCommand
extends AbstractAdminCommand {
    static final String[] DEFAULT_CLASSIFIERS = new String[]{"logs", "config", "plugins", "tree", "metrics", "threads", "sysprop", "ps", "version"};
    private static final DateTimeFormatter filenameDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmmss");
    @CommandLine.Option(names={"--database"}, paramLabel="<database>", defaultValue="*", description={"Name of the database to report for. Can contain * and ? for globbing. Note that * and ? have special meaning in some shells and might need to be escaped or used with quotes."}, converter={Converters.DatabaseNamePatternConverter.class})
    private DatabaseNamePattern database;
    @CommandLine.Option(names={"--list"}, description={"List all available classifiers."})
    private boolean list;
    @CommandLine.Option(names={"--ignore-disk-space-check"}, defaultValue="false", arity="0..1", paramLabel="true|false", fallbackValue="true", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, description={"Ignore disk full warning."})
    private boolean ignoreDiskSpaceCheck;
    @CommandLine.Option(names={"--to-path"}, paramLabel="<path>", description={"Destination directory for reports. Defaults to a system tmp directory."})
    private Path reportDir;
    @CommandLine.Parameters(arity="0..*", paramLabel="<classifier>")
    private Set<String> classifiers = new TreeSet<String>(List.of(DEFAULT_CLASSIFIERS));
    private JMXDumper jmxDumper;

    public DiagnosticsReportCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() {
        Config config = this.getConfig();
        this.jmxDumper = new JMXDumper(config, this.ctx.fs(), this.ctx.out(), this.ctx.err(), this.verbose);
        Set dbNames = DiagnosticsReportCommand.getDbNames((Config)config, (FileSystemAbstraction)this.ctx.fs(), (DatabaseNamePattern)this.database);
        DiagnosticsReporter reporter = this.createAndRegisterSources(config, dbNames);
        if (this.list) {
            this.listClassifiers(reporter.getAvailableClassifiers());
            return;
        }
        this.validateClassifiers(reporter);
        DiagnosticsReporterProgress progress = this.buildProgress();
        try {
            if (this.reportDir == null) {
                this.reportDir = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("reports").toAbsolutePath();
            }
            Path reportFile = this.reportDir.resolve(DiagnosticsReportCommand.getDefaultFilename());
            this.ctx.out().println("Writing report to " + String.valueOf(reportFile.toAbsolutePath()));
            reporter.dump(this.classifiers, reportFile, progress, this.ignoreDiskSpaceCheck);
        }
        catch (IOException e) {
            throw new CommandFailedException("Creating archive failed", (Throwable)e);
        }
    }

    private static String getDefaultFilename() throws UnknownHostException {
        String hostName = InetAddress.getLocalHost().getHostName();
        String safeFilename = hostName.replaceAll("[^a-zA-Z0-9._]+", "_");
        return safeFilename + "-" + LocalDateTime.now().format(filenameDateTimeFormatter) + ".zip";
    }

    private DiagnosticsReporterProgress buildProgress() {
        return System.console() == null ? new NonInteractiveProgress(this.ctx.out(), this.verbose) : new InteractiveProgress(this.ctx.out(), this.verbose);
    }

    private void validateClassifiers(DiagnosticsReporter reporter) {
        Set availableClassifiers = reporter.getAvailableClassifiers();
        if (this.classifiers.contains("all")) {
            if (this.classifiers.size() != 1) {
                this.classifiers.remove("all");
                throw new CommandFailedException("If you specify 'all' this has to be the only classifier. Found ['" + String.join((CharSequence)"','", this.classifiers) + "'] as well.");
            }
        } else {
            if (this.classifiers.equals(Set.of(DEFAULT_CLASSIFIERS))) {
                this.classifiers = new HashSet<String>(this.classifiers);
                this.classifiers.retainAll(availableClassifiers);
            }
            DiagnosticsReportCommand.validateOrphanClassifiers(availableClassifiers, this.classifiers);
        }
    }

    private static void validateOrphanClassifiers(Set<String> availableClassifiers, Set<String> orphans) {
        for (String classifier : orphans) {
            if (availableClassifiers.contains(classifier)) continue;
            throw new CommandFailedException("Unknown classifier: " + classifier);
        }
    }

    private void listClassifiers(Set<String> availableClassifiers) {
        this.ctx.out().println("All available classifiers:");
        for (String classifier : availableClassifiers) {
            this.ctx.out().printf("  %-10s %s%n", classifier, DiagnosticsReportCommand.describeClassifier(classifier));
        }
    }

    private DiagnosticsReporter createAndRegisterSources(Config config, Set<String> databaseNames) {
        Path userLogsConfig;
        Path serverLogsConfig;
        DiagnosticsReporter reporter = new DiagnosticsReporter();
        FileSystemAbstraction fs = this.ctx.fs();
        reporter.registerAllOfflineProviders(config, fs, databaseNames);
        if (fs.isDirectory(this.ctx.confDir())) {
            try {
                Path[] configs;
                for (Path cfg : configs = fs.listFiles(this.ctx.confDir(), path -> {
                    String fileName = path.getFileName().toString();
                    return fileName.startsWith("neo4j") && fileName.endsWith(".conf");
                })) {
                    String destination = "config/" + String.valueOf(cfg.getFileName());
                    if (fs.isDirectory(cfg)) {
                        DiagnosticsReportSources.newDiagnosticsMatchingFiles((String)(destination + "/"), (FileSystemAbstraction)fs, (Path)cfg, path -> !fs.isDirectory(path) && !path.getFileName().toString().startsWith(".")).forEach(conf -> reporter.registerSource("config", conf));
                        continue;
                    }
                    reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)destination, (FileSystemAbstraction)fs, (Path)cfg));
                }
            }
            catch (IOException e) {
                reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsString((String)"config error", () -> "Error reading files in directory: " + e.getMessage()));
                throw new RuntimeException(e);
            }
        }
        if (fs.fileExists(serverLogsConfig = (Path)config.get(GraphDatabaseSettings.server_logging_config_path))) {
            reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"config/server-logs.xml", (FileSystemAbstraction)fs, (Path)serverLogsConfig));
        }
        if (fs.fileExists(userLogsConfig = (Path)config.get(GraphDatabaseSettings.user_logging_config_path))) {
            reporter.registerSource("config", DiagnosticsReportSources.newDiagnosticsFile((String)"config/user-logs.xml", (FileSystemAbstraction)fs, (Path)userLogsConfig));
        }
        reporter.registerSource("ps", DiagnosticsReportCommand.runningProcesses());
        this.registerJMXSources(reporter);
        return reporter;
    }

    private void registerJMXSources(DiagnosticsReporter reporter) {
        Optional<JmxDump> jmxDump = this.jmxDumper.getJMXDump();
        jmxDump.ifPresent(jmx -> {
            reporter.registerSource("threads", jmx.threadDumpSource());
            reporter.registerSource("heap", jmx.heapDump());
            reporter.registerSource("sysprop", jmx.systemProperties());
        });
    }

    private Config getConfig() {
        return this.createPrefilledConfigBuilder().build();
    }

    static String describeClassifier(String classifier) {
        return switch (classifier) {
            case "logs" -> "include log files";
            case "config" -> "include configuration files";
            case "plugins" -> "include a view of the plugin directory";
            case "tree" -> "include a view of the tree structure of the data directory";
            case "tx" -> "include transaction logs";
            case "metrics" -> "include metrics";
            case "threads" -> "include a thread dump of the running instance";
            case "heap" -> "include a heap dump";
            case "sysprop" -> "include a list of java system properties";
            case "raft" -> "include the raft log";
            case "ccstate" -> "include the current cluster state";
            case "ps" -> "include a list of running processes";
            case "version" -> "include version of neo4j";
            default -> throw new IllegalArgumentException("Unknown classifier: " + classifier);
        };
    }

    private static DiagnosticsReportSource runningProcesses() {
        return DiagnosticsReportSources.newDiagnosticsString((String)"ps.csv", () -> {
            List processesList = JProcesses.getProcessList();
            StringBuilder sb = new StringBuilder();
            sb.append(StringEscapeUtils.escapeCsv((String)"Process PID")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Name")).append(',').append(StringEscapeUtils.escapeCsv((String)"Process Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"User")).append(',').append(StringEscapeUtils.escapeCsv((String)"Virtual Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"Physical Memory")).append(',').append(StringEscapeUtils.escapeCsv((String)"CPU usage")).append(',').append(StringEscapeUtils.escapeCsv((String)"Start Time")).append(',').append(StringEscapeUtils.escapeCsv((String)"Priority")).append(',').append(StringEscapeUtils.escapeCsv((String)"Full command")).append('\n');
            for (ProcessInfo processInfo : processesList) {
                sb.append(processInfo.getPid()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getName())).append(',').append(processInfo.getTime()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getUser())).append(',').append(processInfo.getVirtualMemory()).append(',').append(processInfo.getPhysicalMemory()).append(',').append(processInfo.getCpuUsage()).append(',').append(processInfo.getStartTime()).append(',').append(processInfo.getPriority()).append(',').append(StringEscapeUtils.escapeCsv((String)processInfo.getCommand())).append('\n');
            }
            return sb.toString();
        });
    }
}

