/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.printer;

import java.io.PrintStream;
import java.util.Objects;
import org.neo4j.dbms.archive.printer.OutputProgressPrinter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.NullLog;

public class ProgressPrinters {
    private ProgressPrinters() {
    }

    public static OutputProgressPrinter printStreamPrinter(PrintStream printStream) {
        Objects.requireNonNull(printStream);
        return new PrintStreamOutputProgressPrinter(printStream);
    }

    public static OutputProgressPrinter emptyPrinter() {
        return EmptyOutputProgressPrinter.EMPTY_PROGRESS_PRINTER;
    }

    public static OutputProgressPrinter logProviderPrinter(InternalLog log) {
        Objects.requireNonNull(log);
        if (log instanceof NullLog) {
            return ProgressPrinters.emptyPrinter();
        }
        return new LogOutputProgressPrinter(log);
    }

    private static class PrintStreamOutputProgressPrinter
    implements OutputProgressPrinter {
        private final PrintStream printStream;
        private final boolean interactive;

        PrintStreamOutputProgressPrinter(PrintStream printStream) {
            this.printStream = printStream;
            this.interactive = System.console() != null;
        }

        @Override
        public void print(String message) {
            this.printStream.print(this.lineSeparator() + message);
        }

        @Override
        public void complete() {
            this.printStream.print(System.lineSeparator());
        }

        private char lineSeparator() {
            return this.interactive ? (char)'\r' : '\n';
        }
    }

    public static final class EmptyOutputProgressPrinter
    implements OutputProgressPrinter {
        static EmptyOutputProgressPrinter EMPTY_PROGRESS_PRINTER = new EmptyOutputProgressPrinter();

        private EmptyOutputProgressPrinter() {
        }

        @Override
        public void print(String message) {
        }
    }

    private static class LogOutputProgressPrinter
    implements OutputProgressPrinter {
        private final InternalLog log;

        LogOutputProgressPrinter(InternalLog log) {
            this.log = log;
        }

        @Override
        public void print(String message) {
            this.log.info(message);
        }
    }
}

