/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.monitoring.DatabaseHealth;

@FunctionalInterface
public interface SystemDatabaseProvider {
    public GraphDatabaseAPI database() throws SystemDatabaseUnavailableException;

    default public void execute(Consumer<Transaction> consumer) throws SystemDatabaseUnavailableException {
        GraphDatabaseAPI facade = this.database();
        if (!facade.isAvailable(1000L)) {
            throw new SystemDatabaseUnavailableException();
        }
        try (Transaction tx = facade.beginTx();){
            consumer.accept(tx);
            tx.commit();
        }
    }

    default public <T> T query(Function<Transaction, T> function) throws SystemDatabaseUnavailableException {
        GraphDatabaseAPI facade = this.database();
        if (!facade.isAvailable(1000L)) {
            Boolean hasNotPanicked = this.dependency(DatabaseHealth.class).map(DatabaseHealth::hasNoPanic).orElse(true);
            if (hasNotPanicked.booleanValue()) {
                throw new SystemDatabaseUnavailableException();
            }
            throw new SystemDatabasePanickedException();
        }
        try (Transaction tx = facade.beginTx();){
            T result = function.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    default public <T> Optional<T> dependency(Class<T> type) throws SystemDatabaseUnavailableException {
        DependencyResolver dependencies = this.database().getDependencyResolver();
        if (dependencies.containsDependency(type)) {
            return Optional.of(dependencies.resolveDependency(type));
        }
        return Optional.empty();
    }

    public static class SystemDatabaseUnavailableException
    extends RuntimeException {
    }

    public static class SystemDatabasePanickedException
    extends SystemDatabaseUnavailableException {
    }
}

