/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import java.util.Set;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.systemgraph.InstanceModeConstraint;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;

public record ServerDetails(ServerId serverId, String name, Optional<SocketAddress> boltAddress, Optional<SocketAddress> httpAddress, Optional<SocketAddress> httpsAddress, Set<String> tags, State state, Health health, Set<String> hostedDatabases, Set<String> desiredDatabases, Set<String> allowedDatabases, Set<String> deniedDatabases, InstanceModeConstraint modeConstraint, Optional<String> neo4jVersion) {

    public static enum State {
        FREE,
        ENABLED,
        CORDONED,
        DEALLOCATING,
        DEALLOCATED,
        DROPPED;


        public static State fromInstanceStatus(TopologyGraphDbmsModel.InstanceStatus status) {
            return switch (status) {
                default -> throw new IncompatibleClassChangeError();
                case TopologyGraphDbmsModel.InstanceStatus.ENABLED -> ENABLED;
                case TopologyGraphDbmsModel.InstanceStatus.CORDONED -> CORDONED;
                case TopologyGraphDbmsModel.InstanceStatus.DEALLOCATING -> DEALLOCATING;
            };
        }

        public String prettyPrint() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FREE -> "Free";
                case ENABLED -> "Enabled";
                case CORDONED -> "Cordoned";
                case DEALLOCATING -> "Deallocating";
                case DEALLOCATED -> "Deallocated";
                case DROPPED -> "Dropped";
            };
        }
    }

    public static enum Health {
        AVAILABLE,
        UNAVAILABLE;


        public String prettyPrint() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case AVAILABLE -> "Available";
                case UNAVAILABLE -> "Unavailable";
            };
        }
    }
}

