/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.routing;

import java.util.Optional;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.helpers.SocketAddressParser;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class RoutingTableServiceHelpers {
    public static final String ADDRESS_CONTEXT_KEY = "address";
    public static final String FROM_ALIAS_KEY = "alias";

    public static Optional<SocketAddress> findClientProvidedAddress(MapValue routingContext, int defaultBoltPort, InternalLog log) throws RoutingException {
        AnyValue address = routingContext.get(ADDRESS_CONTEXT_KEY);
        if (address == null || address == Values.NO_VALUE) {
            return Optional.empty();
        }
        if (address instanceof TextValue) {
            try {
                String clientProvidedAddress = ((TextValue)address).stringValue();
                if (clientProvidedAddress != null && !clientProvidedAddress.isEmpty() && !clientProvidedAddress.isBlank()) {
                    return Optional.of(SocketAddressParser.socketAddress((String)clientProvidedAddress, (int)defaultBoltPort, SocketAddress::new));
                }
            }
            catch (Exception e) {
                log.warn("Exception attempting to determine address value from routing context", (Throwable)e);
            }
        }
        throw new RoutingException((Status)Status.Procedure.ProcedureCallFailed, "An address key is included in the query string provided to the GetRoutingTableProcedure, but its value could not be parsed.");
    }

    public static RoutingException databaseNotFoundException(String databaseName) {
        return new RoutingException((Status)Status.Database.DatabaseNotFound, "Unable to get a routing table for database '" + databaseName + "' because this database does not exist");
    }

    public static RoutingException databaseNotAvailableException(String databaseName) {
        return new RoutingException((Status)Status.General.DatabaseUnavailable, "Unable to get a routing table for database '" + databaseName + "' because this database is unavailable");
    }
}

