/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.util.Optional;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.commandline.Util;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.LockChecker;
import org.neo4j.commandline.dbms.StoreVersionLoader;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.locker.FileLockException;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;

public class LoadDumpExecutor {
    private final Config config;
    private final FileSystemAbstraction fs;
    private final PrintStream errorOutput;
    private final Loader loader;

    public LoadDumpExecutor(Config config, FileSystemAbstraction fs, PrintStream errorOutput, Loader loader) {
        this.config = config;
        this.fs = fs;
        this.errorOutput = errorOutput;
        this.loader = loader;
    }

    public void execute(DumpInput dumpInput, String database, boolean force) throws IOException {
        CursorContextFactory contextFactory = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
        DatabaseLayout databaseLayout = Neo4jLayout.of((Configuration)this.config).databaseLayout(database);
        this.fs.mkdirs(databaseLayout.databaseDirectory());
        this.fs.mkdirs(databaseLayout.getNeo4jLayout().transactionLogsRootDirectory());
        try (Closeable ignore = LockChecker.checkDatabaseLock(databaseLayout);){
            LoadDumpExecutor.deleteIfNecessary(databaseLayout, force);
            this.load(dumpInput, databaseLayout);
        }
        catch (FileLockException e) {
            throw new CommandFailedException("The database is in use. Stop database '" + database + "' and try again.", (Throwable)e);
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
        catch (CannotWriteException e) {
            throw new CommandFailedException("You do not have permission to load the database'" + database + "'.", (Throwable)e);
        }
        StoreVersionLoader.Result result = this.loader.getStoreVersion(this.fs, this.config, databaseLayout, contextFactory);
        if (result.migrationNeeded) {
            this.errorOutput.printf("The loaded database '%s' is not on a supported version (current format: %s introduced in %s). Use the 'neo4j-admin database migrate' command%n", database, result.currentFormat.getStoreVersionUserString(), result.currentFormatIntroductionVersion);
        }
    }

    private void load(DumpInput dumpInput, DatabaseLayout databaseLayout) {
        try {
            this.loader.load(databaseLayout, dumpInput.streamSupplier, dumpInput.description);
        }
        catch (FileAlreadyExistsException e) {
            throw new CommandFailedException("Database already exists: " + databaseLayout.getDatabaseName(), (Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new CommandFailedException(String.format("You do not have permission to load the database '%s'.", databaseLayout.getDatabaseName()), (Throwable)e);
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
        catch (IncorrectFormat incorrectFormat) {
            throw new CommandFailedException("Not a valid Neo4j archive: " + dumpInput.description, (Throwable)incorrectFormat);
        }
    }

    private static void deleteIfNecessary(DatabaseLayout databaseLayout, boolean force) {
        try {
            if (force) {
                FileUtils.deleteDirectory((Path)databaseLayout.databaseDirectory(), path -> !path.equals(databaseLayout.databaseLockFile()));
                FileUtils.deleteDirectory((Path)databaseLayout.getTransactionLogsDirectory());
            }
        }
        catch (IOException e) {
            Util.wrapIOException((IOException)e);
        }
    }

    public record DumpInput(ThrowingSupplier<InputStream, IOException> streamSupplier, Optional<Path> file, String description) {
    }
}

