/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseInfo;
import org.neo4j.dbms.database.DatabaseInfoService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.ExtendedDatabaseInfo;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.storageengine.StoreFileClosedException;
import org.neo4j.storageengine.api.TransactionIdStore;

public class StandaloneDatabaseInfoService
implements DatabaseInfoService {
    private static final String ROLE_LABEL = "standalone";
    private final DatabaseIdRepository idRepository;
    private final ReadOnlyDatabases readOnlyDatabases;
    private final ServerId serverId;
    private final SocketAddress address;
    private final DatabaseManager<?> databaseManager;
    private final DatabaseStateService stateService;

    public StandaloneDatabaseInfoService(ServerId serverId, SocketAddress address, DatabaseManager<?> databaseManager, DatabaseStateService stateService, ReadOnlyDatabases readOnlyDatabases) {
        this.serverId = serverId;
        this.address = address;
        this.databaseManager = databaseManager;
        this.stateService = stateService;
        this.idRepository = databaseManager.databaseIdRepository();
        this.readOnlyDatabases = readOnlyDatabases;
    }

    @Override
    public List<DatabaseInfo> lookupCachedInfo(Set<String> databaseNames) {
        return this.createDatabaseInfoStream(databaseNames).collect(Collectors.toList());
    }

    @Override
    public List<ExtendedDatabaseInfo> requestDetailedInfo(Set<String> databaseNames) {
        return this.createDatabaseInfoStream(databaseNames).map(databaseInfo -> databaseInfo.extendWith(this.getLastCommittedTransactionForDatabase(databaseInfo.namedDatabaseId()))).collect(Collectors.toList());
    }

    private Stream<DatabaseInfo> createDatabaseInfoStream(Set<String> databaseNames) {
        return databaseNames.stream().map(arg_0 -> ((DatabaseIdRepository)this.idRepository).getByName(arg_0)).flatMap(Optional::stream).map(this::createInfoForDatabase);
    }

    private long getLastCommittedTransactionForDatabase(NamedDatabaseId namedDatabaseId) {
        return this.databaseManager.getDatabaseContext(namedDatabaseId).map(DatabaseContext::dependencies).map(dependencies -> (TransactionIdStore)dependencies.resolveDependency(TransactionIdStore.class)).flatMap(transactionIdStore -> {
            try {
                return Optional.of(transactionIdStore.getLastCommittedTransactionId());
            }
            catch (StoreFileClosedException e) {
                return Optional.empty();
            }
        }).orElse(-1L);
    }

    private DatabaseInfo createInfoForDatabase(NamedDatabaseId namedDatabaseId) {
        String status = this.stateService.stateOfDatabase(namedDatabaseId).operatorState().description();
        String error = this.stateService.causeOfFailure(namedDatabaseId).map(Throwable::getMessage).orElse("");
        TopologyGraphDbmsModel.DatabaseAccess access = this.readOnlyDatabases.isReadOnly(namedDatabaseId) ? TopologyGraphDbmsModel.DatabaseAccess.READ_ONLY : TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE;
        return new DatabaseInfo(namedDatabaseId, this.serverId, access, this.address, null, ROLE_LABEL, status, error);
    }
}

