/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.GroupSettingSupport;
import org.neo4j.kernel.configuration.Settings;

public class ClientConnectorSettings {
    public static HttpConnector httpConnector(String key) {
        return new HttpConnector(key, HttpConnector.Encryption.NONE);
    }

    public static Optional<HttpConnector> httpConnector(Config config, HttpConnector.Encryption encryption) {
        List<Object> httpConnectors = ((Stream)config.view(GroupSettingSupport.enumerate(GraphDatabaseSettings.Connector.class))).map(key -> new HttpConnector((String)key, encryption)).filter(connConfig -> connConfig.group.groupKey.equals(encryption.uriScheme) || config.get(connConfig.type) == GraphDatabaseSettings.Connector.ConnectorType.HTTP && config.get(connConfig.encryption) == encryption).collect(Collectors.toList());
        if (httpConnectors.isEmpty()) {
            httpConnectors = Collections.singletonList(new HttpConnector(encryption));
        }
        return httpConnectors.stream().filter(connConfig -> (Boolean)config.get(connConfig.enabled)).findFirst();
    }

    @Description(value="Configuration options for HTTP connectors. \"(http-connector-key)\" is a placeholder for a unique name for the connector, for instance \"http-public\" or some other name that describes what the connector is for.")
    public static class HttpConnector
    extends GraphDatabaseSettings.Connector {
        @Description(value="Enable TLS for this connector")
        public final Setting<Encryption> encryption;
        @Description(value="Address the connector should bind to. This setting is deprecated and will be replaced by `+listen_address+`")
        public final Setting<ListenSocketAddress> address;
        @Description(value="Address the connector should bind to")
        public final Setting<ListenSocketAddress> listen_address;
        @Description(value="Advertised address for this connector")
        public final Setting<AdvertisedSocketAddress> advertised_address;

        public HttpConnector() {
            this(Encryption.NONE);
        }

        public HttpConnector(Encryption encryptionLevel) {
            this("(http-connector-key)", encryptionLevel);
        }

        public HttpConnector(String key, Encryption encryptionLevel) {
            super(key, null);
            this.encryption = this.group.scope(Settings.setting((String)"encryption", (Function)Settings.options(Encryption.class), (String)Settings.NO_DEFAULT));
            Setting legacyAddressSetting = Settings.listenAddress((String)"address", (int)encryptionLevel.defaultPort);
            Setting listenAddressSetting = Settings.legacyFallback((Setting)legacyAddressSetting, (Setting)Settings.listenAddress((String)"listen_address", (int)encryptionLevel.defaultPort));
            this.address = this.group.scope(legacyAddressSetting);
            this.listen_address = this.group.scope(listenAddressSetting);
            this.advertised_address = this.group.scope(Settings.advertisedAddress((String)"advertised_address", (Setting)listenAddressSetting));
        }

        public static enum Encryption {
            NONE("http", 7474),
            TLS("https", 7473);

            final String uriScheme;
            final int defaultPort;

            private Encryption(String uriScheme, int defaultPort) {
                this.uriScheme = uriScheme;
                this.defaultPort = defaultPort;
            }
        }
    }
}

