/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.internal.StoreLocker;

class StoreLockChecker {
    StoreLockChecker() {
    }

    Closeable withLock(Path databaseDirectory) throws CommandFailed, CannotWriteException {
        Path lockFile = databaseDirectory.resolve("store_lock");
        if (Files.exists(lockFile, new LinkOption[0])) {
            if (Files.isWritable(lockFile)) {
                StoreLocker storeLocker = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
                storeLocker.checkLock(databaseDirectory.toFile());
                return storeLocker;
            }
            throw new CannotWriteException(lockFile);
        }
        return () -> {};
    }
}

