/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive.backup;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.dbms.archive.backup.BackupDescription;
import org.neo4j.dbms.archive.backup.BackupMetadataV1;

public class BackupMetadataV2
extends BackupMetadataV1 {
    public static final String METADATA_SCRIPT_FIELD = "metadataScript";
    public static final String TOPOLOGY_VERSION_FIELD = "topology_version";
    public static final String VIRTUAL_NAME_FIELD = "virtual_name";
    public static final String VIRTUAL_ID_FIELD = "virtual_id";
    public static final String INDEX_FIELD = "shard_index";
    public static final String SHARD_COUNT_FIELD = "shard_count";
    public static final int METADATA_SCRIPT_MAX_LENGTH = 0x100000;
    public static final int VERSION = 2;
    private final BackupMetadataV1 backupMetadataV1;
    private final Map<String, String> additionalFields;

    public static BackupMetadataV2 readFromStream(InputStream inputStream) throws IOException {
        return BackupMetadataV2.readMetadataV2(inputStream);
    }

    public static BackupMetadataV2 from(BackupDescription description) {
        BackupMetadataV1 backupMetadataV1 = new BackupMetadataV1(description);
        String metadataScript = description.getMetadataScript();
        HashMap<String, String> additionalFields = new HashMap<String, String>();
        if (metadataScript != null) {
            additionalFields.put(METADATA_SCRIPT_FIELD, metadataScript);
        }
        description.getTopology().ifPresent(t -> BackupMetadataV2.writeTopology(t, additionalFields));
        return new BackupMetadataV2(backupMetadataV1, additionalFields);
    }

    private static void writeTopology(BackupDescription.Topology topology, HashMap<String, String> additionalFields) {
        additionalFields.put(TOPOLOGY_VERSION_FIELD, "1");
        additionalFields.put(VIRTUAL_NAME_FIELD, topology.virtualName());
        additionalFields.put(VIRTUAL_ID_FIELD, topology.virtualId().toString());
        additionalFields.put(SHARD_COUNT_FIELD, String.valueOf(topology.shardCount()));
        topology.index().ifPresent(index -> additionalFields.put(INDEX_FIELD, String.valueOf(index)));
    }

    static BackupMetadataV2 readMetadataV2(InputStream inputStream) throws IOException {
        BackupMetadataV1 backupMetadataV1 = BackupMetadataV2.readMetadataV1(inputStream);
        Map<String, String> additionalFields = BackupMetadataV2.readMap(inputStream);
        return new BackupMetadataV2(backupMetadataV1, additionalFields);
    }

    private BackupMetadataV2(BackupMetadataV1 backupMetadataV1, Map<String, String> additionalFields) {
        super(backupMetadataV1.getDatabaseName(), backupMetadataV1.getStoreId(), backupMetadataV1.getDatabaseId(), backupMetadataV1.getBackupTime(), backupMetadataV1.getLowestAppendIndex(), backupMetadataV1.getHighestAppendIndex(), backupMetadataV1.isRecovered(), backupMetadataV1.isCompressed(), backupMetadataV1.isFull());
        this.backupMetadataV1 = backupMetadataV1;
        this.additionalFields = additionalFields;
    }

    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    public void writeToStreamV2(OutputStream compressionStream) throws IOException {
        this.writeToStreamV1(compressionStream);
        this.writeMap(compressionStream, this.getAdditionalFields());
    }

    private void writeMap(OutputStream compressionStream, Map<String, String> additionalFields) throws IOException {
        DataOutputStream dataStream = new DataOutputStream(compressionStream);
        int mapSize = additionalFields.size();
        dataStream.writeInt(mapSize);
        for (Map.Entry<String, String> field : additionalFields.entrySet()) {
            BackupMetadataV2.writeString(dataStream, field.getKey());
            BackupMetadataV2.writeString(dataStream, field.getValue());
        }
        dataStream.flush();
    }

    private static Map<String, String> readMap(InputStream inputStream) throws IOException {
        HashMap<String, String> deserializedMap = new HashMap<String, String>();
        DataInputStream dataStream = new DataInputStream(inputStream);
        int mapSize = dataStream.readInt();
        for (int i = 0; i < mapSize; ++i) {
            String key = BackupMetadataV2.readString(dataStream, Integer.MAX_VALUE);
            int maxValueLength = METADATA_SCRIPT_FIELD.equals(key) ? 0x100000 : Integer.MAX_VALUE;
            String value = BackupMetadataV2.readString(dataStream, maxValueLength);
            if (value == null) continue;
            deserializedMap.put(key, value);
        }
        return deserializedMap;
    }

    private static void writeString(DataOutputStream outputStream, String value) throws IOException {
        byte[] data = value.getBytes(StandardCharsets.UTF_8);
        outputStream.writeInt(data.length);
        outputStream.write(data);
    }

    private static String readString(DataInputStream inputStream, int maxLength) throws IOException {
        int length = inputStream.readInt();
        if (length > maxLength) {
            inputStream.skipBytes(length);
            return null;
        }
        return new String(inputStream.readNBytes(length), StandardCharsets.UTF_8);
    }

    @Override
    public BackupDescription toBackupDescription() {
        String metadataScript = this.additionalFields.get(METADATA_SCRIPT_FIELD);
        String topology = this.additionalFields.get(TOPOLOGY_VERSION_FIELD);
        if (topology != null && topology.equals("1")) {
            BackupDescription.Topology toplogyObject = this.readV1topology();
            return super.toBackupDescription().withMetadataScript(metadataScript).withTopology(toplogyObject);
        }
        return super.toBackupDescription().withMetadataScript(metadataScript);
    }

    private BackupDescription.Topology readV1topology() {
        String virtualName = this.additionalFields.get(VIRTUAL_NAME_FIELD);
        UUID virtualId = UUID.fromString(this.additionalFields.get(VIRTUAL_ID_FIELD));
        int shardCount = Integer.parseInt(this.additionalFields.get(SHARD_COUNT_FIELD));
        Optional<Integer> shardIndex = Optional.ofNullable(this.additionalFields.get(INDEX_FIELD)).map(Integer::parseInt);
        return new BackupDescription.Topology(virtualName, virtualId, shardCount, shardIndex);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupMetadataV2 that = (BackupMetadataV2)o;
        return Objects.equals(this.backupMetadataV1, that.backupMetadataV1) && Objects.equals(this.additionalFields, that.additionalFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backupMetadataV1, this.additionalFields);
    }
}

