/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Collections;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.collector.QueryCollector;
import org.neo4j.internal.collector.RecentQueryBuffer;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;

public class DataCollector
extends LifecycleAdapter {
    private final Database database;
    private final QueryCollector queryCollector;

    public DataCollector(Database database, JobScheduler jobScheduler, Monitors monitors, Config config, RecentQueryBuffer recentQueryBuffer) {
        this.database = database;
        this.queryCollector = new QueryCollector(database.getNamedDatabaseId(), jobScheduler, recentQueryBuffer, (Integer)config.get(GraphDatabaseInternalSettings.data_collector_max_query_text_size));
        try {
            this.queryCollector.collect(Collections.emptyMap());
        }
        catch (InvalidArgumentsException e) {
            throw new IllegalStateException("An empty config cannot be invalid", e);
        }
        monitors.addMonitorListener((Object)this.queryCollector, new String[0]);
    }

    public void stop() {
        this.queryCollector.doStop();
    }

    public Kernel getKernel() {
        return this.database.getKernel();
    }

    QueryCollector getQueryCollector() {
        return this.queryCollector;
    }
}

