/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Collections;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.collector.QueryCollector;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.ValueMapper;

public class DataCollector
implements AutoCloseable {
    final Kernel kernel;
    final JobScheduler jobScheduler;
    final ValueMapper.JavaMapper valueMapper;
    final QueryCollector queryCollector;

    DataCollector(Kernel kernel, JobScheduler jobScheduler, Monitors monitors, ValueMapper.JavaMapper valueMapper, Config config) {
        this.kernel = kernel;
        this.jobScheduler = jobScheduler;
        this.valueMapper = valueMapper;
        this.queryCollector = new QueryCollector(jobScheduler, (Integer)config.get(GraphDatabaseSettings.data_collector_max_recent_query_count), (Integer)config.get(GraphDatabaseSettings.data_collector_max_query_text_size));
        try {
            this.queryCollector.collect(Collections.emptyMap());
        }
        catch (InvalidArgumentsException e) {
            throw new IllegalStateException("An empty config cannot be invalid", e);
        }
        monitors.addMonitorListener((Object)this.queryCollector, new String[0]);
    }

    @Override
    public void close() {
    }
}

