/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.collector.CollectorStateMachine;
import org.neo4j.internal.collector.QueryCollectorConfig;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;

class QueryCollector
extends CollectorStateMachine<Iterator<QuerySnapshot>>
implements QueryExecutionMonitor {
    private volatile boolean isCollecting;
    private final ConcurrentLinkedQueue<QuerySnapshot> queries;
    private final JobScheduler jobScheduler;

    QueryCollector(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.isCollecting = false;
        this.queries = new ConcurrentLinkedQueue();
    }

    @Override
    CollectorStateMachine.Result doCollect(Map<String, Object> config, long collectionId) throws InvalidArgumentsException {
        int collectSeconds = QueryCollectorConfig.of(config).collectSeconds;
        this.jobScheduler.schedule(Group.DATA_COLLECTOR, () -> this.stop(collectionId), (long)collectSeconds, TimeUnit.SECONDS);
        this.isCollecting = true;
        return QueryCollector.success("Collection started.");
    }

    @Override
    CollectorStateMachine.Result doStop() {
        this.isCollecting = false;
        return QueryCollector.success("Collection stopped.");
    }

    @Override
    CollectorStateMachine.Result doClear() {
        this.queries.clear();
        return QueryCollector.success("Data cleared.");
    }

    @Override
    Iterator<QuerySnapshot> doGetData() {
        return this.queries.iterator();
    }

    public void endFailure(ExecutingQuery query, Throwable failure) {
    }

    public void endSuccess(ExecutingQuery query) {
        if (this.isCollecting) {
            this.queries.add(query.snapshot());
        }
    }
}

