/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import java.time.Clock;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.CommunityCompilerFactory;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.cache.CacheFactory;
import org.neo4j.cypher.internal.cache.CacheSize;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.CombinedQueryCacheStatistics;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.CypherParsingConfig;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.config.ObservableSetting;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.GraphDatabaseCypherService;
import org.neo4j.cypher.internal.javacompat.MultiVersionExecutionEngine;
import org.neo4j.cypher.internal.javacompat.SnapshotExecutionEngine;
import org.neo4j.cypher.internal.javacompat.SystemExecutionEngine;
import org.neo4j.cypher.internal.runtime.CypherRuntimeConfiguration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryCacheStatistics;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.MonitoredJobExecutor;
import scala.Function0;

public class CommunityCypherEngineProvider
extends QueryEngineProvider {
    protected int enginePriority() {
        return 42;
    }

    protected CompilerFactory makeCompilerFactory(GraphDatabaseCypherService queryService, QueryEngineProvider.SPI spi, CypherParsingConfig parsingConfig, CypherPlannerConfiguration plannerConfig, CypherRuntimeConfiguration runtimeConfig, CypherQueryCaches queryCaches) {
        return new CommunityCompilerFactory((GraphDatabaseQueryService)queryService, spi.monitors(), spi.logProvider(), parsingConfig, plannerConfig, runtimeConfig, queryCaches);
    }

    protected CacheFactory getCacheFactory(Dependencies deps, QueryEngineProvider.SPI spi) {
        return CommunityCypherEngineProvider.makeNonUnifiedCacheFactory(spi);
    }

    protected ObservableSetting<Integer> getCacheSize(QueryEngineProvider.SPI spi) {
        return new ObservableSetting((Config)spi.databaseConfig(), GraphDatabaseSettings.query_cache_size);
    }

    protected QueryExecutionEngine createEngine(Dependencies deps, GraphDatabaseAPI graphAPI, boolean isSystemDatabase, QueryEngineProvider.SPI spi) {
        GraphDatabaseCypherService queryService = (GraphDatabaseCypherService)deps.satisfyDependency((Object)new GraphDatabaseCypherService((GraphDatabaseService)graphAPI));
        deps.satisfyDependency((Object)Neo4jTransactionalContextFactory.create((GraphDatabaseQueryService)queryService));
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)spi.databaseConfig());
        CypherParsingConfig parsingConfig = CypherParsingConfig.fromCypherConfiguration((CypherConfiguration)cypherConfig);
        CypherPlannerConfiguration plannerConfig = CypherPlannerConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig, (Config)spi.databaseConfig(), (boolean)isSystemDatabase, (boolean)false);
        CypherRuntimeConfiguration runtimeConfig = CypherRuntimeConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig);
        CacheFactory cacheFactory = this.getCacheFactory(deps, spi);
        Clock clock = Clock.systemUTC();
        ObservableSetting<Integer> cacheSizeSetting = this.getCacheSize(spi);
        CacheSize.Dynamic cacheSize = new CacheSize.Dynamic(cacheSizeSetting);
        CypherQueryCaches queryCaches = this.makeCypherQueryCaches(spi, queryService, cypherConfig, (CacheSize)cacheSize, cacheFactory, clock);
        CompilerFactory compilerFactory = this.makeCompilerFactory(queryService, spi, parsingConfig, plannerConfig, runtimeConfig, queryCaches);
        QueryCacheStatistics cacheStatistics = queryCaches.statistics();
        if (!isSystemDatabase) {
            deps.satisfyDependency((Object)cacheStatistics);
        }
        if (isSystemDatabase) {
            CypherPlannerConfiguration innerPlannerConfig = CypherPlannerConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig, (Config)spi.databaseConfig(), (boolean)false, (boolean)false);
            CypherQueryCaches innerQueryCaches = this.makeCypherQueryCaches(spi, queryService, cypherConfig, (CacheSize)cacheSize, cacheFactory, clock);
            QueryCacheStatistics innerCacheStatistics = innerQueryCaches.statistics();
            CombinedQueryCacheStatistics combinedCacheStatistics = new CombinedQueryCacheStatistics(cacheStatistics, innerCacheStatistics);
            deps.satisfyDependency((Object)combinedCacheStatistics);
            CompilerFactory innerCompilerFactory = this.makeCompilerFactory(queryService, spi, parsingConfig, innerPlannerConfig, runtimeConfig, innerQueryCaches);
            return new SystemExecutionEngine((GraphDatabaseQueryService)queryService, spi.logProvider(), queryCaches, compilerFactory, innerQueryCaches, innerCompilerFactory);
        }
        if (((Boolean)spi.databaseConfig().get(GraphDatabaseInternalSettings.snapshot_query)).booleanValue()) {
            return new SnapshotExecutionEngine((GraphDatabaseQueryService)queryService, (Config)spi.databaseConfig(), queryCaches, spi.logProvider(), compilerFactory);
        }
        String dbFormat = (String)spi.databaseConfig().get(GraphDatabaseSettings.db_format);
        if (dbFormat != null && dbFormat.contains("multiversion")) {
            return new MultiVersionExecutionEngine((GraphDatabaseQueryService)queryService, (Config)spi.databaseConfig(), queryCaches, spi.logProvider(), compilerFactory);
        }
        return new ExecutionEngine((GraphDatabaseQueryService)queryService, queryCaches, spi.logProvider(), compilerFactory);
    }

    private CypherQueryCaches makeCypherQueryCaches(QueryEngineProvider.SPI spi, GraphDatabaseCypherService queryService, CypherConfiguration cypherConfig, CacheSize cacheSize, CacheFactory cacheFactory, Clock clock) {
        return new CypherQueryCaches(new CypherQueryCaches.Config(cypherConfig, cacheSize), (Function0<Object>)new LastCommittedTxIdProvider((GraphDatabaseQueryService)queryService), cacheFactory, clock, spi.monitors(), spi.logProvider());
    }

    private static CaffeineCacheFactory makeNonUnifiedCacheFactory(QueryEngineProvider.SPI spi) {
        MonitoredJobExecutor monitoredExecutor = spi.jobScheduler().monitoredJobExecutor(Group.CYPHER_CACHE);
        return new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
    }
}

