/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.constraint;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.ast.CreateConstraintType;
import org.neo4j.cypher.internal.ast.NodeKey;
import org.neo4j.cypher.internal.ast.NodePropertyExistence$;
import org.neo4j.cypher.internal.ast.NodePropertyType;
import org.neo4j.cypher.internal.ast.NodePropertyUniqueness;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.RelationshipKey;
import org.neo4j.cypher.internal.ast.RelationshipPropertyExistence$;
import org.neo4j.cypher.internal.ast.RelationshipPropertyType;
import org.neo4j.cypher.internal.ast.RelationshipPropertyUniqueness;
import org.neo4j.cypher.internal.ast.prettifier.Prettifier$;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.notification.IndexOrConstraintAlreadyExistsNotification;
import org.neo4j.cypher.internal.notification.IndexOrConstraintDoesNotExistNotification;
import org.neo4j.cypher.internal.notification.InternalNotification;
import org.neo4j.cypher.internal.optionsmap.CreateIndexProviderOnlyOptions;
import org.neo4j.cypher.internal.optionsmap.IndexBackedConstraintsOptionsConverter;
import org.neo4j.cypher.internal.optionsmap.OptionsConverterResult;
import org.neo4j.cypher.internal.optionsmap.PropertyExistenceOrTypeConstraintOptionsConverter;
import org.neo4j.cypher.internal.plandescription.LogicalPlan2PlanDescription$;
import org.neo4j.cypher.internal.plandescription.PrettyString;
import org.neo4j.cypher.internal.plandescription.asPrettyString$;
import org.neo4j.cypher.internal.plandescription.asPrettyString$PrettyStringInterpolator$;
import org.neo4j.cypher.internal.procs.IgnoredResult;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.procs.SchemaExecutionResult;
import org.neo4j.cypher.internal.procs.SuccessResult;
import org.neo4j.cypher.internal.procs.SuccessResult$;
import org.neo4j.cypher.internal.runtime.ConstraintInformation;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.Procedures;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;

public final class ConstraintCommandPlanner$ {
    public static final ConstraintCommandPlanner$ MODULE$ = new ConstraintCommandPlanner$();

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodeKeyConstraint(NodeKey nodeKey, LabelName label, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$22;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodeKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$22 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$2 -> x$2.provider());
            int labelId = ctx.getOrCreateLabelId(label.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createNodeKeyConstraint$3(ctx, p)));
            ctx.createNodeKeyConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipKeyConstraint(RelationshipKey relKey, RelTypeName relType, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$42;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(relKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$42 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$4 -> x$4.provider());
            int relId = ctx.getOrCreateRelTypeId(relType.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createRelationshipKeyConstraint$3(ctx, p)));
            ctx.createRelationshipKeyConstraint(relId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyUniquenessConstraint(NodePropertyUniqueness nodePropUnique, LabelName label, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodePropUnique.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$6 -> x$6.provider());
            int labelId = ctx.getOrCreateLabelId(label.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createNodePropertyUniquenessConstraint$3(ctx, p)));
            ctx.createNodeUniqueConstraint(labelId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyUniquenessConstraint(RelationshipPropertyUniqueness relPropUnique, RelTypeName relType, Seq<Property> props, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<Procedures> x$5;
            Option<Config> x$4;
            MapValue x$3;
            Options x$2;
            CypherVersion x$1;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(relPropUnique.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            Tuple2<Option<CreateIndexProviderOnlyOptions>, Set<InternalNotification>> tuple2 = qual$1.convert(x$1 = cypherVersion, x$2 = options, x$3 = params, x$4 = qual$1.convert$default$4(), x$5 = qual$1.convert$default$5()).toOptionNotification();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option maybeIndexProvider = (Option)tuple2._1();
            Set notifications = (Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)maybeIndexProvider, (Object)notifications);
            Option maybeIndexProvider2 = (Option)tuple22._1();
            Set notifications2 = (Set)tuple22._2();
            Option indexProvider = maybeIndexProvider2.flatMap((Function1 & Serializable)x$8 -> x$8.provider());
            int relTypeId = ctx.getOrCreateRelTypeId(relType.name());
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$createRelationshipPropertyUniquenessConstraint$3(ctx, p)));
            ctx.createRelationshipUniqueConstraint(relTypeId, propertyKeyIds, constraintName, indexProvider);
            return new SuccessResult((Set<InternalNotification>)notifications2);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyExistenceConstraint(LabelName label, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            ((Function3 & Serializable)(Function3 & Serializable)(x$9, x$10, x$11) -> {
                ctx.createNodePropertyExistenceConstraint(BoxesRunTime.unboxToInt((Object)x$9), BoxesRunTime.unboxToInt((Object)x$10), x$11, false);
                return BoxedUnit.UNIT;
            }).tupled().apply(MODULE$.labelPropWithName((QueryContext)ctx, label, ((Property)prop.head()).propertyKey(), constraintName));
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyExistenceConstraint(RelTypeName relType, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            ((Function3 & Serializable)(Function3 & Serializable)(x$12, x$13, x$14) -> {
                ctx.createRelationshipPropertyExistenceConstraint(BoxesRunTime.unboxToInt((Object)x$12), BoxesRunTime.unboxToInt((Object)x$13), x$14, false);
                return BoxedUnit.UNIT;
            }).tupled().apply(MODULE$.typePropWithName((QueryContext)ctx, relType, ((Property)prop.head()).propertyKey(), constraintName));
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createNodePropertyTypeConstraint(CypherType propertyType, LabelName label, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            Tuple3<Object, Object, Option<String>> tuple3 = MODULE$.labelPropWithName((QueryContext)ctx, label, ((Property)prop.head()).propertyKey(), constraintName);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int labelId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(labelId, propId);
            int labelId2 = sp2._1$mcI$sp();
            int propId2 = sp2._2$mcI$sp();
            ctx.createNodePropertyTypeConstraint(labelId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName, false);
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> createRelationshipPropertyTypeConstraint(CypherType propertyType, RelTypeName relType, Seq<Property> prop, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            PropertyExistenceOrTypeConstraintOptionsConverter qual$1 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
            CypherVersion x$1 = cypherVersion;
            Options x$2 = options;
            MapValue x$3 = params;
            Option<Config> x$4 = qual$1.convert$default$4();
            Option<Procedures> x$5 = qual$1.convert$default$5();
            qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            Tuple3<Object, Object, Option<String>> tuple3 = MODULE$.typePropWithName((QueryContext)ctx, relType, ((Property)prop.head()).propertyKey(), constraintName);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int relTypeId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int propId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(relTypeId, propId);
            int relTypeId2 = sp2._1$mcI$sp();
            int propId2 = sp2._2$mcI$sp();
            ctx.createRelationshipPropertyTypeConstraint(relTypeId2, propId2, PropertyTypeMapper$.MODULE$.asPropertyTypeSet(propertyType), constraintName, false);
            return new SuccessResult(SuccessResult$.MODULE$.apply$default$1());
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> dropConstraint(Either<String, Parameter> name, boolean ifExists) {
        return (Function2 & Serializable)(ctx, params) -> {
            Set set;
            String constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            if (!ifExists || ctx.constraintExists(constraintName)) {
                ctx.dropNamedConstraint(constraintName, false);
                set = Predef$.MODULE$.Set().empty();
            } else {
                set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InternalNotification[]{new IndexOrConstraintDoesNotExistNotification("DROP CONSTRAINT " + Prettifier$.MODULE$.escapeName((Either)new Left((Object)constraintName)) + " IF EXISTS", constraintName)}));
            }
            Set notifications = set;
            return new SuccessResult((Set<InternalNotification>)notifications);
        };
    }

    public Function2<QueryContext, MapValue, SchemaExecutionResult> doNothingIfExists(ElementTypeName entityName, Seq<Property> props, CreateConstraintType assertion, Option<Either<String, Parameter>> name, Options options, CypherVersion cypherVersion) {
        return (Function2 & Serializable)(ctx, params) -> {
            OptionsConverterResult<Product> optionsConverterResult;
            Option<String> constraintName = SchemaCommandRuntime$.MODULE$.getName(name, (MapValue)params);
            CreateConstraintType createConstraintType = assertion;
            if (createConstraintType instanceof NodeKey) {
                NodeKey nodeKey = (NodeKey)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$1 = new IndexBackedConstraintsOptionsConverter(nodeKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$1 = cypherVersion;
                Options x$2 = options;
                MapValue x$3 = params;
                Option<Config> x$4 = qual$1.convert$default$4();
                Option<Procedures> x$5 = qual$1.convert$default$5();
                optionsConverterResult = qual$1.convert(x$1, x$2, x$3, x$4, x$5);
            } else if (createConstraintType instanceof RelationshipKey) {
                RelationshipKey relationshipKey = (RelationshipKey)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$2 = new IndexBackedConstraintsOptionsConverter(relationshipKey.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$6 = cypherVersion;
                Options x$7 = options;
                MapValue x$8 = params;
                Option<Config> x$9 = qual$2.convert$default$4();
                Option<Procedures> x$10 = qual$2.convert$default$5();
                optionsConverterResult = qual$2.convert(x$6, x$7, x$8, x$9, x$10);
            } else if (createConstraintType instanceof NodePropertyUniqueness) {
                NodePropertyUniqueness nodePropertyUniqueness = (NodePropertyUniqueness)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$3 = new IndexBackedConstraintsOptionsConverter(nodePropertyUniqueness.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$11 = cypherVersion;
                Options x$12 = options;
                MapValue x$13 = params;
                Option<Config> x$14 = qual$3.convert$default$4();
                Option<Procedures> x$15 = qual$3.convert$default$5();
                optionsConverterResult = qual$3.convert(x$11, x$12, x$13, x$14, x$15);
            } else if (createConstraintType instanceof RelationshipPropertyUniqueness) {
                RelationshipPropertyUniqueness relationshipPropertyUniqueness = (RelationshipPropertyUniqueness)createConstraintType;
                IndexBackedConstraintsOptionsConverter qual$4 = new IndexBackedConstraintsOptionsConverter(relationshipPropertyUniqueness.description() + " constraint", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$16 = cypherVersion;
                Options x$17 = options;
                MapValue x$18 = params;
                Option<Config> x$19 = qual$4.convert$default$4();
                Option<Procedures> x$20 = qual$4.convert$default$5();
                optionsConverterResult = qual$4.convert(x$16, x$17, x$18, x$19, x$20);
            } else if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$5 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$21 = cypherVersion;
                Options x$22 = options;
                MapValue x$23 = params;
                Option<Config> x$24 = qual$5.convert$default$4();
                Option<Procedures> x$25 = qual$5.convert$default$5();
                optionsConverterResult = qual$5.convert(x$21, x$22, x$23, x$24, x$25);
            } else if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$6 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "existence", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$26 = cypherVersion;
                Options x$27 = options;
                MapValue x$28 = params;
                Option<Config> x$29 = qual$6.convert$default$4();
                Option<Procedures> x$30 = qual$6.convert$default$5();
                optionsConverterResult = qual$6.convert(x$26, x$27, x$28, x$29, x$30);
            } else if (createConstraintType instanceof NodePropertyType) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$7 = new PropertyExistenceOrTypeConstraintOptionsConverter("node", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$31 = cypherVersion;
                Options x$32 = options;
                MapValue x$33 = params;
                Option<Config> x$34 = qual$7.convert$default$4();
                Option<Procedures> x$35 = qual$7.convert$default$5();
                optionsConverterResult = qual$7.convert(x$31, x$32, x$33, x$34, x$35);
            } else if (createConstraintType instanceof RelationshipPropertyType) {
                PropertyExistenceOrTypeConstraintOptionsConverter qual$8 = new PropertyExistenceOrTypeConstraintOptionsConverter("relationship", "type", SchemaCommandRuntime$.MODULE$.indexContext((QueryContext)ctx));
                CypherVersion x$36 = cypherVersion;
                Options x$37 = options;
                MapValue x$38 = params;
                Option<Config> x$39 = qual$8.convert$default$4();
                Option<Procedures> x$40 = qual$8.convert$default$5();
                optionsConverterResult = qual$8.convert(x$36, x$37, x$38, x$39, x$40);
            } else {
                throw new MatchError((Object)createConstraintType);
            }
            OptionsConverterResult<CreateIndexProviderOnlyOptions> conversionResult = optionsConverterResult;
            Set optionConverterNotifications = (Set)conversionResult.toOptionNotification()._2();
            Tuple2<Object, EntityType> tuple2 = SchemaCommandRuntime$.MODULE$.getEntityInfo(entityName, (QueryContext)ctx);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int entityId = tuple2._1$mcI$sp();
            int entityId2 = entityId;
            Seq propertyKeyIds = (Seq)props.map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ConstraintCommandPlanner$.$anonfun$doNothingIfExists$2(ctx, p)));
            Function1<ConstraintDescriptor, Object> constraintMatcher = MODULE$.convertConstraintTypeToConstraintMatcher(assertion);
            if (ctx.constraintExists(constraintMatcher, entityId2, propertyKeyIds)) {
                String constraintDescription = MODULE$.constraintInfo(constraintName, entityName, props, assertion, options);
                String conflictingConstraint = MODULE$.existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation(constraintMatcher, entityId2, propertyKeyIds), cypherVersion);
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            if (constraintName.exists((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ctx.constraintExists(name)))) {
                String constraintDescription = MODULE$.constraintInfo(constraintName, entityName, props, assertion, options);
                String conflictingConstraint = MODULE$.existingConstraintInfo((QueryContext)ctx, (Function0<ConstraintInformation>)(Function0 & Serializable)() -> ctx.getConstraintInformation((String)constraintName.get()), cypherVersion);
                IndexOrConstraintAlreadyExistsNotification notification = new IndexOrConstraintAlreadyExistsNotification("CREATE " + constraintDescription, conflictingConstraint);
                return new IgnoredResult((Set<InternalNotification>)((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new IndexOrConstraintAlreadyExistsNotification[]{notification}))).$plus$plus((IterableOnce)optionConverterNotifications)));
            }
            return new SuccessResult((Set<InternalNotification>)optionConverterNotifications);
        };
    }

    private Tuple3<Object, Object, Option<String>> labelPropWithName(QueryContext ctx, LabelName label, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(label.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    private Tuple3<Object, Object, Option<String>> typePropWithName(QueryContext ctx, RelTypeName relType, PropertyKeyName prop, Option<String> name) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relType.name())), (Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreatePropertyKeyId(prop.name())), name);
    }

    private Function1<ConstraintDescriptor, Object> convertConstraintTypeToConstraintMatcher(CreateConstraintType assertion) {
        CreateConstraintType createConstraintType = assertion;
        if (NodePropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodePropertyExistenceConstraint());
        }
        if (RelationshipPropertyExistence$.MODULE$.equals(createConstraintType)) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipPropertyExistenceConstraint());
        }
        if (createConstraintType instanceof NodePropertyUniqueness) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeUniquenessConstraint());
        }
        if (createConstraintType instanceof RelationshipPropertyUniqueness) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipUniquenessConstraint());
        }
        if (createConstraintType instanceof NodeKey) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isNodeKeyConstraint());
        }
        if (createConstraintType instanceof RelationshipKey) {
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.isRelationshipKeyConstraint());
        }
        if (createConstraintType instanceof NodePropertyType) {
            NodePropertyType nodePropertyType = (NodePropertyType)createConstraintType;
            CypherType propType = nodePropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ConstraintCommandPlanner$.$anonfun$convertConstraintTypeToConstraintMatcher$7(propType, c));
        }
        if (createConstraintType instanceof RelationshipPropertyType) {
            RelationshipPropertyType relationshipPropertyType = (RelationshipPropertyType)createConstraintType;
            CypherType propType = relationshipPropertyType.propType();
            return (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)ConstraintCommandPlanner$.$anonfun$convertConstraintTypeToConstraintMatcher$8(propType, c));
        }
        throw new MatchError((Object)createConstraintType);
    }

    private String constraintInfo(Option<String> nameOption, ElementTypeName entityName, Seq<Property> properties, CreateConstraintType constraintType, Options options) {
        PrettyString name = SchemaCommandRuntime$.MODULE$.getPrettyName(nameOption);
        PrettyString pattern = SchemaCommandRuntime$.MODULE$.getPrettyEntityPattern(entityName);
        PrettyString propertyString = SchemaCommandRuntime$.MODULE$.getPrettyPropertyPattern((Seq<PropertyKeyName>)((Seq)properties.map((Function1 & Serializable)p -> p.propertyKey())), "(", ")");
        PrettyString prettyAssertion = asPrettyString$.MODULE$.raw(constraintType.predicate());
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " IF NOT EXISTS FOR ", " REQUIRE ", " ", "", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{name, pattern, propertyString, prettyAssertion, LogicalPlan2PlanDescription$.MODULE$.prettyOptions(options)})).prettifiedString();
    }

    private String existingConstraintInfo(QueryContext ctx, Function0<ConstraintInformation> getInfoParts, CypherVersion cypherVersion) {
        String string;
        block17: {
            try {
                Object object;
                ctx.assertShowConstraintAllowed();
                ConstraintInformation constraintInformation = (ConstraintInformation)getInfoParts.apply();
                if (constraintInformation == null) {
                    throw new MatchError((Object)constraintInformation);
                }
                boolean isNode = constraintInformation.isNode();
                ConstraintType constraintType = constraintInformation.constraintType();
                String name = constraintInformation.name();
                String entityName = constraintInformation.labelOrRelType();
                List properties = constraintInformation.properties();
                Option propertyType = constraintInformation.propertyType();
                Option impliedLabel = constraintInformation.impliedLabel();
                Option forSourceNode = constraintInformation.forSourceNode();
                Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToBoolean((boolean)isNode), (Object)constraintType, (Object)name, (Object)entityName, (Object)properties, (Object)propertyType, (Object)impliedLabel, (Object)forSourceNode);
                boolean isNode2 = BoxesRunTime.unboxToBoolean((Object)tuple8._1());
                ConstraintType constraintType2 = (ConstraintType)tuple8._2();
                String name2 = (String)tuple8._3();
                String entityName2 = (String)tuple8._4();
                List properties2 = (List)tuple8._5();
                Option propertyType2 = (Option)tuple8._6();
                Option impliedLabel2 = (Option)tuple8._7();
                Option forSourceNode2 = (Option)tuple8._8();
                PrettyString nameString = SchemaCommandRuntime$.MODULE$.getPrettyName((Option<String>)new Some((Object)name2));
                PrettyString pattern = SchemaCommandRuntime$.MODULE$.getPrettyEntityPattern(isNode2, entityName2);
                PrettyString propertyString = SchemaCommandRuntime$.MODULE$.getPrettyPropertyPattern((List<String>)properties2, "(", ")");
                ConstraintType constraintType3 = constraintType2;
                if (ConstraintType.EXISTS.equals(constraintType3)) {
                    object = "IS NOT NULL";
                } else if (ConstraintType.UNIQUE_EXISTS.equals(constraintType3)) {
                    CypherVersion cypherVersion2 = cypherVersion;
                    CypherVersion cypherVersion3 = CypherVersion.Cypher5;
                    object = !(cypherVersion2 != null ? !cypherVersion2.equals(cypherVersion3) : cypherVersion3 != null) ? (isNode2 ? "IS NODE KEY" : "IS RELATIONSHIP KEY") : "IS KEY";
                } else if (ConstraintType.UNIQUE.equals(constraintType3)) {
                    object = "IS UNIQUE";
                } else if (ConstraintType.PROPERTY_TYPE.equals(constraintType3)) {
                    object = "IS :: " + propertyType2.get();
                } else if (ConstraintType.RELATIONSHIP_ENDPOINT_LABEL.equals(constraintType3)) {
                    object = "";
                } else if (ConstraintType.NODE_LABEL_EXISTENCE.equals(constraintType3)) {
                    object = "";
                } else {
                    throw new MatchError((Object)constraintType3);
                }
                String assertion = object;
                PrettyString prettyAssertion = asPrettyString$.MODULE$.raw(assertion);
                ConstraintType constraintType4 = constraintType2;
                ConstraintType constraintType5 = ConstraintType.RELATIONSHIP_ENDPOINT_LABEL;
                if (!(constraintType4 != null ? !constraintType4.equals(constraintType5) : constraintType5 != null)) {
                    string = BoxesRunTime.unboxToBoolean((Object)forSourceNode2.get()) ? asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(:", ")-[:", " =>]->()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((String)impliedLabel2.get()), asPrettyString$.MODULE$.apply(entityName2)})).prettifiedString() : asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[:", " =>]->(:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName2), asPrettyString$.MODULE$.apply((String)impliedLabel2.get())})).prettifiedString();
                    break block17;
                }
                ConstraintType constraintType6 = constraintType2;
                ConstraintType constraintType7 = ConstraintType.NODE_LABEL_EXISTENCE;
                if (!(constraintType6 != null ? !constraintType6.equals(constraintType7) : constraintType7 != null)) {
                    string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(:", " => :", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName2), asPrettyString$.MODULE$.apply((String)impliedLabel2.get())})).prettifiedString();
                    break block17;
                }
                string = asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CONSTRAINT", " FOR ", " REQUIRE ", " ", ""}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{nameString, pattern, propertyString, prettyAssertion})).prettifiedString();
            }
            catch (AuthorizationViolationException authorizationViolationException) {
                string = "constraint";
            }
        }
        return string;
    }

    public static final /* synthetic */ int $anonfun$createNodeKeyConstraint$3(QueryContext ctx$1, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$1, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createRelationshipKeyConstraint$3(QueryContext ctx$2, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$2, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createNodePropertyUniquenessConstraint$3(QueryContext ctx$3, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$3, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$createRelationshipPropertyUniquenessConstraint$3(QueryContext ctx$4, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$4, p.propertyKey()).id();
    }

    public static final /* synthetic */ int $anonfun$doNothingIfExists$2(QueryContext ctx$7, Property p) {
        return SchemaCommandRuntime$.MODULE$.propertyToId(ctx$7, p.propertyKey()).id();
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$7(CypherType propType$1, ConstraintDescriptor c) {
        return c.isNodePropertyTypeConstraint() && SchemaCommandRuntime$.MODULE$.checkTypes(propType$1, c.asPropertyTypeConstraint().propertyType());
    }

    public static final /* synthetic */ boolean $anonfun$convertConstraintTypeToConstraintMatcher$8(CypherType propType$2, ConstraintDescriptor c) {
        return c.isRelationshipPropertyTypeConstraint() && SchemaCommandRuntime$.MODULE$.checkTypes(propType$2, c.asPropertyTypeConstraint().propertyType());
    }

    private ConstraintCommandPlanner$() {
    }
}

