/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.procs;

import java.io.Serializable;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import org.neo4j.cypher.internal.util.symbols.BooleanType;
import org.neo4j.cypher.internal.util.symbols.ClosedDynamicUnionType;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.DateType;
import org.neo4j.cypher.internal.util.symbols.DurationType;
import org.neo4j.cypher.internal.util.symbols.Float32Type;
import org.neo4j.cypher.internal.util.symbols.FloatType;
import org.neo4j.cypher.internal.util.symbols.Integer16Type;
import org.neo4j.cypher.internal.util.symbols.Integer32Type;
import org.neo4j.cypher.internal.util.symbols.Integer8Type;
import org.neo4j.cypher.internal.util.symbols.IntegerType;
import org.neo4j.cypher.internal.util.symbols.ListType;
import org.neo4j.cypher.internal.util.symbols.LocalDateTimeType;
import org.neo4j.cypher.internal.util.symbols.LocalTimeType;
import org.neo4j.cypher.internal.util.symbols.PointType;
import org.neo4j.cypher.internal.util.symbols.StringType;
import org.neo4j.cypher.internal.util.symbols.ZonedDateTimeType;
import org.neo4j.cypher.internal.util.symbols.ZonedTimeType;
import org.neo4j.internal.schema.constraints.ConstrainableType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.internal.schema.constraints.VectorType;
import org.neo4j.values.storable.Vector;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PropertyTypeMapper$ {
    public static final PropertyTypeMapper$ MODULE$ = new PropertyTypeMapper$();

    public PropertyTypeSet asPropertyTypeSet(CypherType propertyType2) {
        .colon.colon colon2;
        CypherType cypherType = propertyType2;
        if (cypherType instanceof ClosedDynamicUnionType) {
            ClosedDynamicUnionType closedDynamicUnionType = (ClosedDynamicUnionType)cypherType;
            colon2 = closedDynamicUnionType.sortedInnerTypes().map((Function1 & Serializable)propertyType -> MODULE$.asSingleConstrainableType((CypherType)propertyType));
        } else {
            colon2 = new .colon.colon((Object)this.asSingleConstrainableType(propertyType2), (List)Nil$.MODULE$);
        }
        .colon.colon constrainableTypes = colon2;
        return PropertyTypeSet.of((ConstrainableType[])((ConstrainableType[])constrainableTypes.toArray(ClassTag$.MODULE$.apply(ConstrainableType.class))));
    }

    private ConstrainableType asSingleConstrainableType(CypherType propertyType) {
        boolean bl = false;
        org.neo4j.cypher.internal.util.symbols.VectorType vectorType = null;
        boolean bl2 = false;
        ListType listType = null;
        CypherType cypherType = propertyType;
        if (cypherType instanceof BooleanType) {
            return SchemaValueType.BOOLEAN;
        }
        if (cypherType instanceof StringType) {
            return SchemaValueType.STRING;
        }
        if (cypherType instanceof IntegerType) {
            return SchemaValueType.INTEGER;
        }
        if (cypherType instanceof FloatType) {
            return SchemaValueType.FLOAT;
        }
        if (cypherType instanceof DateType) {
            return SchemaValueType.DATE;
        }
        if (cypherType instanceof LocalTimeType) {
            return SchemaValueType.LOCAL_TIME;
        }
        if (cypherType instanceof ZonedTimeType) {
            return SchemaValueType.ZONED_TIME;
        }
        if (cypherType instanceof LocalDateTimeType) {
            return SchemaValueType.LOCAL_DATETIME;
        }
        if (cypherType instanceof ZonedDateTimeType) {
            return SchemaValueType.ZONED_DATETIME;
        }
        if (cypherType instanceof DurationType) {
            return SchemaValueType.DURATION;
        }
        if (cypherType instanceof PointType) {
            return SchemaValueType.POINT;
        }
        if (cypherType instanceof org.neo4j.cypher.internal.util.symbols.VectorType) {
            Integer8Type integer8Type;
            boolean bl3;
            Some some;
            CypherType cypherType2;
            bl = true;
            vectorType = (org.neo4j.cypher.internal.util.symbols.VectorType)cypherType;
            Option option = vectorType.innerType();
            Option option2 = vectorType.dimension();
            if (option instanceof Some && (cypherType2 = (CypherType)(some = (Some)option).value()) instanceof Integer8Type && !(bl3 = (integer8Type = (Integer8Type)cypherType2).isNullable()) && option2 instanceof Some) {
                Some some2 = (Some)option2;
                long dim = BoxesRunTime.unboxToLong((Object)some2.value());
                return VectorType.int8Vector((int)((int)dim));
            }
        }
        if (bl) {
            Integer16Type integer16Type;
            boolean bl4;
            Some some;
            CypherType cypherType3;
            Option option = vectorType.innerType();
            Option option3 = vectorType.dimension();
            if (option instanceof Some && (cypherType3 = (CypherType)(some = (Some)option).value()) instanceof Integer16Type && !(bl4 = (integer16Type = (Integer16Type)cypherType3).isNullable()) && option3 instanceof Some) {
                Some some3 = (Some)option3;
                long dim = BoxesRunTime.unboxToLong((Object)some3.value());
                return VectorType.int16Vector((int)((int)dim));
            }
        }
        if (bl) {
            Integer32Type integer32Type;
            boolean bl5;
            Some some;
            CypherType cypherType4;
            Option option = vectorType.innerType();
            Option option4 = vectorType.dimension();
            if (option instanceof Some && (cypherType4 = (CypherType)(some = (Some)option).value()) instanceof Integer32Type && !(bl5 = (integer32Type = (Integer32Type)cypherType4).isNullable()) && option4 instanceof Some) {
                Some some4 = (Some)option4;
                long dim = BoxesRunTime.unboxToLong((Object)some4.value());
                return VectorType.int32Vector((int)((int)dim));
            }
        }
        if (bl) {
            IntegerType integerType;
            boolean bl6;
            Some some;
            CypherType cypherType5;
            Option option = vectorType.innerType();
            Option option5 = vectorType.dimension();
            if (option instanceof Some && (cypherType5 = (CypherType)(some = (Some)option).value()) instanceof IntegerType && !(bl6 = (integerType = (IntegerType)cypherType5).isNullable()) && option5 instanceof Some) {
                Some some5 = (Some)option5;
                long dim = BoxesRunTime.unboxToLong((Object)some5.value());
                return VectorType.int64Vector((int)((int)dim));
            }
        }
        if (bl) {
            Float32Type float32Type;
            boolean bl7;
            Some some;
            CypherType cypherType6;
            Option option = vectorType.innerType();
            Option option6 = vectorType.dimension();
            if (option instanceof Some && (cypherType6 = (CypherType)(some = (Some)option).value()) instanceof Float32Type && !(bl7 = (float32Type = (Float32Type)cypherType6).isNullable()) && option6 instanceof Some) {
                Some some6 = (Some)option6;
                long dim = BoxesRunTime.unboxToLong((Object)some6.value());
                return VectorType.float32Vector((int)((int)dim));
            }
        }
        if (bl) {
            FloatType floatType;
            boolean bl8;
            Some some;
            CypherType cypherType7;
            Option option = vectorType.innerType();
            Option option7 = vectorType.dimension();
            if (option instanceof Some && (cypherType7 = (CypherType)(some = (Some)option).value()) instanceof FloatType && !(bl8 = (floatType = (FloatType)cypherType7).isNullable()) && option7 instanceof Some) {
                Some some7 = (Some)option7;
                long dim = BoxesRunTime.unboxToLong((Object)some7.value());
                return VectorType.float64Vector((int)((int)dim));
            }
        }
        if (cypherType instanceof ListType) {
            bl2 = true;
            listType = (ListType)cypherType;
            if (listType.innerType() instanceof BooleanType) {
                return SchemaValueType.LIST_BOOLEAN;
            }
        }
        if (bl2 && listType.innerType() instanceof StringType) {
            return SchemaValueType.LIST_STRING;
        }
        if (bl2 && listType.innerType() instanceof IntegerType) {
            return SchemaValueType.LIST_INTEGER;
        }
        if (bl2 && listType.innerType() instanceof FloatType) {
            return SchemaValueType.LIST_FLOAT;
        }
        if (bl2 && listType.innerType() instanceof DateType) {
            return SchemaValueType.LIST_DATE;
        }
        if (bl2 && listType.innerType() instanceof LocalTimeType) {
            return SchemaValueType.LIST_LOCAL_TIME;
        }
        if (bl2 && listType.innerType() instanceof ZonedTimeType) {
            return SchemaValueType.LIST_ZONED_TIME;
        }
        if (bl2 && listType.innerType() instanceof LocalDateTimeType) {
            return SchemaValueType.LIST_LOCAL_DATETIME;
        }
        if (bl2 && listType.innerType() instanceof ZonedDateTimeType) {
            return SchemaValueType.LIST_ZONED_DATETIME;
        }
        if (bl2 && listType.innerType() instanceof DurationType) {
            return SchemaValueType.LIST_DURATION;
        }
        if (bl2 && listType.innerType() instanceof PointType) {
            return SchemaValueType.LIST_POINT;
        }
        throw new IllegalStateException("Invalid property type: " + cypherType.description());
    }

    public CypherType asCypherType(PropertyTypeSet propertyTypeSet) {
        List cypherTypeList = Predef$.MODULE$.wrapRefArray((Object[])propertyTypeSet.values()).toList().map((Function1 & Serializable)x0$1 -> {
            ConstrainableType constrainableType = x0$1;
            if (SchemaValueType.BOOLEAN.equals(constrainableType)) {
                return new BooleanType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.STRING.equals(constrainableType)) {
                return new StringType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.INTEGER.equals(constrainableType)) {
                return new IntegerType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.FLOAT.equals(constrainableType)) {
                return new FloatType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.DATE.equals(constrainableType)) {
                return new DateType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LOCAL_TIME.equals(constrainableType)) {
                return new LocalTimeType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.ZONED_TIME.equals(constrainableType)) {
                return new ZonedTimeType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LOCAL_DATETIME.equals(constrainableType)) {
                return new LocalDateTimeType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.ZONED_DATETIME.equals(constrainableType)) {
                return new ZonedDateTimeType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.DURATION.equals(constrainableType)) {
                return new DurationType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.POINT.equals(constrainableType)) {
                return new PointType(true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (constrainableType instanceof VectorType) {
                Integer8Type integer8Type;
                VectorType vectorType = (VectorType)constrainableType;
                Vector.CoordinateType coordinateType = vectorType.coordinateType();
                if (Vector.CoordinateType.INTEGER8.equals(coordinateType)) {
                    integer8Type = new Integer8Type(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else if (Vector.CoordinateType.INTEGER16.equals(coordinateType)) {
                    integer8Type = new Integer16Type(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else if (Vector.CoordinateType.INTEGER32.equals(coordinateType)) {
                    integer8Type = new Integer32Type(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else if (Vector.CoordinateType.INTEGER64.equals(coordinateType)) {
                    integer8Type = new IntegerType(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else if (Vector.CoordinateType.FLOAT32.equals(coordinateType)) {
                    integer8Type = new Float32Type(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else if (Vector.CoordinateType.FLOAT64.equals(coordinateType)) {
                    integer8Type = new FloatType(false, (InputPosition)InputPosition$.MODULE$.NONE());
                } else {
                    throw new MatchError((Object)coordinateType);
                }
                Integer8Type innerType = integer8Type;
                return new org.neo4j.cypher.internal.util.symbols.VectorType((Option)new Some((Object)innerType), (Option)new Some((Object)BoxesRunTime.boxToLong((long)vectorType.dimensions())), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_BOOLEAN.equals(constrainableType)) {
                return new ListType((CypherType)new BooleanType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_STRING.equals(constrainableType)) {
                return new ListType((CypherType)new StringType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_INTEGER.equals(constrainableType)) {
                return new ListType((CypherType)new IntegerType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_FLOAT.equals(constrainableType)) {
                return new ListType((CypherType)new FloatType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_DATE.equals(constrainableType)) {
                return new ListType((CypherType)new DateType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_LOCAL_TIME.equals(constrainableType)) {
                return new ListType((CypherType)new LocalTimeType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_ZONED_TIME.equals(constrainableType)) {
                return new ListType((CypherType)new ZonedTimeType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_LOCAL_DATETIME.equals(constrainableType)) {
                return new ListType((CypherType)new LocalDateTimeType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_ZONED_DATETIME.equals(constrainableType)) {
                return new ListType((CypherType)new ZonedDateTimeType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_DURATION.equals(constrainableType)) {
                return new ListType((CypherType)new DurationType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (SchemaValueType.LIST_POINT.equals(constrainableType)) {
                return new ListType((CypherType)new PointType(false, (InputPosition)InputPosition$.MODULE$.NONE()), true, (InputPosition)InputPosition$.MODULE$.NONE());
            }
            throw new IllegalStateException("Invalid property type: " + constrainableType.userDescription());
        });
        if (cypherTypeList.size() == 1) {
            return (CypherType)cypherTypeList.head();
        }
        return new ClosedDynamicUnionType(cypherTypeList.toSet(), (InputPosition)InputPosition$.MODULE$.NONE());
    }

    private PropertyTypeMapper$() {
    }
}

