/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.expressions.DynamicLabelExpression;
import org.neo4j.cypher.internal.expressions.DynamicRelTypeExpression;
import org.neo4j.cypher.internal.expressions.ElementTypeName;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.plandescription.LogicalPlan2PlanDescription$;
import org.neo4j.cypher.internal.plandescription.PrettyString;
import org.neo4j.cypher.internal.plandescription.asPrettyString$;
import org.neo4j.cypher.internal.plandescription.asPrettyString$PrettyStringInterpolator$;
import org.neo4j.cypher.internal.procs.PropertyTypeMapper$;
import org.neo4j.cypher.internal.runtime.IndexProviderContext;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.ParameterWrongTypeException;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SchemaCommandRuntime$ {
    public static final SchemaCommandRuntime$ MODULE$ = new SchemaCommandRuntime$();

    public Option<String> getName(Option<Either<String, Parameter>> name, MapValue params) {
        return name.map((Function1 & Serializable)x$1 -> MODULE$.getName((Either<String, Parameter>)x$1, params));
    }

    public String getName(Either<String, Parameter> name, MapValue params) {
        Either<String, Parameter> either = name;
        if (either instanceof Left) {
            Left left = (Left)either;
            String stringName = (String)left.value();
            return stringName;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Parameter paramName = (Parameter)right.value();
            AnyValue anyValue = params.get(paramName.name());
            if (anyValue instanceof StringValue) {
                StringValue stringValue = (StringValue)anyValue;
                return stringValue.stringValue();
            }
            throw ParameterWrongTypeException.expectedStringButGotType((String)paramName.name(), (String)anyValue.getTypeName(), (String)anyValue.prettify());
        }
        throw new MatchError(either);
    }

    public Tuple2<Object, EntityType> getEntityInfo(ElementTypeName entityName, QueryContext ctx) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateLabelId(labelName.name())), (Object)EntityType.NODE);
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)ctx.getOrCreateRelTypeId(relTypeName.name())), (Object)EntityType.RELATIONSHIP);
        }
        if (elementTypeName instanceof DynamicLabelExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        if (elementTypeName instanceof DynamicRelTypeExpression) {
            throw new IllegalStateException("Did not expect Dynamic Relationships here");
        }
        throw new MatchError((Object)elementTypeName);
    }

    public boolean checkTypes(CypherType askedForType, PropertyTypeSet preExistingTypes) {
        return preExistingTypes.equals((Object)PropertyTypeMapper$.MODULE$.asPropertyTypeSet(askedForType));
    }

    public PropertyKeyId propertyToId(QueryContext ctx, PropertyKeyName property) {
        return new PropertyKeyId(ctx.getOrCreatePropertyKeyId(property.name()));
    }

    public PrettyString getPrettyName(Option<String> nameOption) {
        return LogicalPlan2PlanDescription$.MODULE$.getPrettyStringName((Option<Either<String, Parameter>>)nameOption.map((Function1 & Serializable)x$2 -> new Left(x$2)));
    }

    public PrettyString getPrettyEntityPattern(ElementTypeName entityName) {
        ElementTypeName elementTypeName = entityName;
        if (elementTypeName instanceof LabelName) {
            LabelName labelName = (LabelName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)labelName)}));
        }
        if (elementTypeName instanceof RelTypeName) {
            RelTypeName relTypeName = (RelTypeName)elementTypeName;
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply((SymbolicName)relTypeName)}));
        }
        if (elementTypeName instanceof DynamicLabelExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        if (elementTypeName instanceof DynamicRelTypeExpression) {
            throw new IllegalStateException("Did not expect Dynamic Labels here");
        }
        throw new MatchError((Object)elementTypeName);
    }

    public PrettyString getPrettyEntityPattern(boolean isNode, String entityName) {
        if (isNode) {
            return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(e:", ")"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
        }
        return asPrettyString$PrettyStringInterpolator$.MODULE$.pretty$extension(asPrettyString$.MODULE$.PrettyStringInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"()-[e:", "]-()"}))), (Seq<PrettyString>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PrettyString[]{asPrettyString$.MODULE$.apply(entityName)}));
    }

    public PrettyString getPrettyPropertyPattern(Seq<PropertyKeyName> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)((IterableOnce)properties.map((Function1 & Serializable)x$3 -> asPrettyString$.MODULE$.apply((SymbolicName)x$3)))).mkPrettyString(start + "e.", ", e.", end);
    }

    public PrettyString getPrettyPropertyPattern(List<String> properties, String start, String end) {
        return asPrettyString$.MODULE$.PrettyStringMaker((IterableOnce<PrettyString>)properties.map((Function1 & Serializable)x$4 -> asPrettyString$.MODULE$.apply((String)x$4))).mkPrettyString(start + "e.", ", e.", end);
    }

    public IndexProviderContext indexContext(QueryContext ctx) {
        return ctx;
    }

    private SchemaCommandRuntime$() {
    }
}

