/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Closeable;
import java.io.Serializable;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.DefaultQueryLanguageScope;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.ast.semantics.SemanticFeature;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.planning.CompilationException$;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.cypher.internal.preparser.InputQuery;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig;
import org.neo4j.cypher.internal.runtime.QueryRuntimeConfig$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.dbms.systemgraph.DefaultQueryLanguageLookup;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.StaticAccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r%g!B\u001a5\u0003\u0003i\u0004\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\t\u0011Q\u0003!\u0011!Q\u0001\n9C\u0001\"\u0016\u0001\u0003\u0006\u0004%\tA\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005/\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003a\u0011!9\u0007A!b\u0001\n\u0003A\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011=\u0004!Q1A\u0005\u0002AD\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\tm\u0002\u0011)\u0019!C\u0001o\"Aa\u0010\u0001B\u0001B\u0003%\u0001\u0010C\u0005\u0000\u0001\t\u0015\r\u0011\"\u0001\u0002\u0002!Q\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u0015\u0005E\u0001A!b\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\"\u0001\u0011\t\u0011)A\u0005\u0003+Aq!a\t\u0001\t\u0003\t)\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0001\u0002<!A\u0011Q\n\u0001!\u0002\u0013\ti\u0004C\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\u0002R!A\u0011\u0011\f\u0001!\u0002\u0013\t\u0019\u0006C\u0005\u0002\\\u0001\u0011\r\u0011\"\u0003\u0002^!A\u0011q\u000e\u0001!\u0002\u0013\ty\u0006C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011q\u0017\u0001!\u0002\u0013\t)\bC\u0005\u0002:\u0002\u0011\r\u0011\"\u0003\u0002<\"A\u00111\u0019\u0001!\u0002\u0013\ti\fC\u0004\u0002F\u0002!\t!a2\t\u0013\t\u0005\u0002!%A\u0005\u0002\t\r\u0002bBAc\u0001\u0011\u0005!\u0011\b\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011%\u0011)\bAI\u0001\n\u0003\u0011\u0019\u0003C\u0004\u0003x\u0001!IA!\u001f\t\u000f\t]\u0006\u0001\"\u0003\u0003:\"9!1\u001d\u0001\u0005\n\t\u0015\bbBB\u0006\u0001\u0011%1Q\u0002\u0005\b\u00077\u0001A\u0011AB\u000f\u0011\u001d\u0019)\u0003\u0001C\u0001\u0007;Aqaa\n\u0001\t\u0003\u0019i\u0002C\u0004\u0004*\u0001!\ta!\b\t\u000f\r-\u0002\u0001\"\u0001\u0004.!91Q\r\u0001\u0005\u0002\r\u001d\u0004bBB=\u0001\u0011\u000531\u0010\u0005\b\u0007{\u0002A\u0011BB@\u000f\u001d\u0019I\u000b\u000eE\u0001\u0007W3aa\r\u001b\t\u0002\r5\u0006bBA\u0012]\u0011\u00051Q\u0017\u0005\n\u0007os#\u0019!C\u0001\u0007sC\u0001b!1/A\u0003%11\u0018\u0005\n\u0007\u0007t\u0013\u0013!C\u0001\u0007\u000b\u0014q\"\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a\u0006\u0003kY\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003oa\naaY=qQ\u0016\u0014(BA\u001d;\u0003\u0015qWm\u001c\u001bk\u0015\u0005Y\u0014aA8sO\u000e\u00011c\u0001\u0001?\rB\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005Y\u0006twMC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%AB(cU\u0016\u001cG\u000f\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\u0005\u0006\u0011\u0011n\\\u0005\u0003\u0017\"\u0013\u0011b\u00117pg\u0016\f'\r\\3\u0002\u0019E,XM]=TKJ4\u0018nY3\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\u001d\u0002\r-,'O\\3m\u0013\t\u0019\u0006KA\rHe\u0006\u0004\b\u000eR1uC\n\f7/Z)vKJL8+\u001a:wS\u000e,\u0017!D9vKJL8+\u001a:wS\u000e,\u0007%\u0001\blKJtW\r\\'p]&$xN]:\u0016\u0003]\u0003\"\u0001W.\u000e\u0003eS!A\u0017\u001d\u0002\u00155|g.\u001b;pe&tw-\u0003\u0002]3\nAQj\u001c8ji>\u00148/A\blKJtW\r\\'p]&$xN]:!\u0003\u0019!(/Y2feV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002di\u00059AO]1dS:<\u0017BA3c\u0005E\u0019u.\u001c9jY\u0006$\u0018n\u001c8Ue\u0006\u001cWM]\u0001\biJ\f7-\u001a:!\u0003\u0019\u0019wN\u001c4jOV\t\u0011\u000e\u0005\u0002kY6\t1N\u0003\u0002hi%\u0011Qn\u001b\u0002\u0014\u0007f\u0004\b.\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u00039i\u0017m\u001d;fe\u000e{W\u000e]5mKJ,\u0012!\u001d\t\u0003eNl\u0011\u0001N\u0005\u0003iR\u0012a\"T1ti\u0016\u00148i\\7qS2,'/A\bnCN$XM]\"p[BLG.\u001a:!\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.Z:\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a\u001f\u001b\u0002\u000b\r\f7\r[3\n\u0005uT(!E\"za\",'/U;fef\u001c\u0015m\u00195fg\u0006a\u0011/^3ss\u000e\u000b7\r[3tA\u0005YAn\\4Qe>4\u0018\u000eZ3s+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001O\u0001\bY><w-\u001b8h\u0013\u0011\ti!a\u0002\u0003'%sG/\u001a:oC2dun\u001a)s_ZLG-\u001a:\u0002\u00191|w\r\u0015:pm&$WM\u001d\u0011\u0002\u000b\rdwnY6\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\u0007\u0005m!)\u0001\u0003uS6,\u0017\u0002BA\u0010\u00033\u0011Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002(\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0002C\u0001:\u0001\u0011\u0015a\u0015\u00031\u0001O\u0011\u0015)\u0016\u00031\u0001X\u0011\u0015q\u0016\u00031\u0001a\u0011\u00159\u0017\u00031\u0001j\u0011\u0015y\u0017\u00031\u0001r\u0011\u00151\u0018\u00031\u0001y\u0011\u0019y\u0018\u00031\u0001\u0002\u0004!I\u0011\u0011C\t\u0011\u0002\u0003\u0007\u0011QC\u0001\u001dI\u00164\u0017-\u001e7u#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8s+\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u000bE,XM]=\u000b\u0007\u0005\u001d\u0003+\u0001\u0003j[Bd\u0017\u0002BA&\u0003\u0003\u0012Q#U;fef,\u00050Z2vi&|g.T8oSR|'/A\u000feK\u001a\fW\u000f\u001c;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8N_:LGo\u001c:!\u0003%\u0001(/\u001a)beN,'/\u0006\u0002\u0002TA\u0019!/!\u0016\n\u0007\u0005]CG\u0001\tDC\u000eD\u0017N\\4Qe\u0016\u0004\u0016M]:fe\u0006Q\u0001O]3QCJ\u001cXM\u001d\u0011\u0002+\u0011,g-Y;mi2\u000bgnZ;bO\u0016dun\\6vaV\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003-\u0019\u0018p\u001d;f[\u001e\u0014\u0018\r\u001d5\u000b\u0007\u0005%\u0004(\u0001\u0003eE6\u001c\u0018\u0002BA7\u0003G\u0012!\u0004R3gCVdG/U;fefd\u0015M\\4vC\u001e,Gj\\8lkB\fa\u0003Z3gCVdG\u000fT1oOV\fw-\u001a'p_.,\b\u000fI\u0001\u000bcV,'/_\"bG\",WCAA;!\u001d\u0011\u0018qOA>\u0003cK1!!\u001f5\u0005)\tV/\u001a:z\u0007\u0006\u001c\u0007.\u001a\t\u0007\u0003{\nI*a(\u000f\t\u0005}\u0014Q\u0013\b\u0005\u0003\u0003\u000b\u0019J\u0004\u0003\u0002\u0004\u0006Ee\u0002BAC\u0003\u001fsA!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017c\u0014A\u0002\u001fs_>$h(C\u0001<\u0013\tI$(\u0003\u00028q%\u0011QGN\u0005\u0004\u0003/#\u0014AC)vKJL8)Y2iK&!\u00111TAO\u0005!\u0019\u0015m\u00195f\u0017\u0016L(bAALiA!\u0011\u0011UAW\u001d\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATi\u0005I\u0001O]3qCJ\u001cXM]\u0005\u0005\u0003W\u000b)+\u0001\u0006J]B,H/U;fefLA!a'\u00020*!\u00111VAS!\r\u0011\u00181W\u0005\u0004\u0003k#$aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u0017E,XM]=DC\u000eDW\rI\u0001\rg\u000eDW-\\1IK2\u0004XM]\u000b\u0003\u0003{\u00032A]A`\u0013\r\t\t\r\u000e\u0002\r'\u000eDW-\\1IK2\u0004XM]\u0001\u000eg\u000eDW-\\1IK2\u0004XM\u001d\u0011\u0002\u000f\u0015DXmY;uKR\u0001\u0012\u0011ZAh\u0003K\fIPa\u0001\u0003\u0010\tM!Q\u0004\t\u0005\u0003\u007f\tY-\u0003\u0003\u0002N\u0006\u0005#AD)vKJLX\t_3dkRLwN\u001c\u0005\b\u0003\u0007b\u0002\u0019AAi!\u0011\t\u0019.a8\u000f\t\u0005U\u00171\u001c\t\u0005\u0003\u000f\u000b9N\u0003\u0002\u0002Z\u0006)1oY1mC&!\u0011Q\\Al\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011]Ar\u0005\u0019\u0019FO]5oO*!\u0011Q\\Al\u0011\u001d\t9\u000f\ba\u0001\u0003S\fa\u0001]1sC6\u001c\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\bm&\u0014H/^1m\u0015\r\t\u0019\u0010O\u0001\u0007m\u0006dW/Z:\n\t\u0005]\u0018Q\u001e\u0002\t\u001b\u0006\u0004h+\u00197vK\"9\u00111 \u000fA\u0002\u0005u\u0018aB2p]R,\u0007\u0010\u001e\t\u0005\u0003\u007f\ty0\u0003\u0003\u0003\u0002\u0005\u0005#\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0003\u0006q\u0001\rAa\u0002\u0002\u000fA\u0014xNZ5mKB!!\u0011\u0002B\u0006\u001b\t\t9.\u0003\u0003\u0003\u000e\u0005]'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005#a\u0002\u0019\u0001B\u0004\u0003-\u0001(/\u001a)paVd\u0017\r^3\t\u000f\tUA\u00041\u0001\u0003\u0018\u0005Q1/\u001e2tGJL'-\u001a:\u0011\t\u0005}\"\u0011D\u0005\u0005\u00057\t\tEA\bRk\u0016\u0014\u0018pU;cg\u000e\u0014\u0018NY3s\u0011%\u0011y\u0002\bI\u0001\u0002\u0004\ti$A\u0004n_:LGo\u001c:\u0002#\u0015DXmY;uK\u0012\"WMZ1vYR$s'\u0006\u0002\u0003&)\"\u0011Q\bB\u0014W\t\u0011I\u0003\u0005\u0003\u0003,\tURB\u0001B\u0017\u0015\u0011\u0011yC!\r\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B\u001a\u0003/\f!\"\u00198o_R\fG/[8o\u0013\u0011\u00119D!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\t\u0002J\nm\"1\tB#\u0005\u000f\u0012IE!\u0017\u0003^!9\u00111\t\u0010A\u0002\tu\u0002\u0003BAR\u0005\u007fIAA!\u0011\u0002&\n\u0001b)\u001e7msB\u000b'o]3e#V,'/\u001f\u0005\b\u0003Ot\u0002\u0019AAu\u0011\u001d\tYP\ba\u0001\u0003{DqA!\u0005\u001f\u0001\u0004\u00119\u0001C\u0004\u0003Ly\u0001\rA!\u0014\u0002\u000b%t\u0007/\u001e;\u0011\t\t=#QK\u0007\u0003\u0005#R1Aa\u00155\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0016\u0003R\ty\u0011J\u001c9vi\u0012\u000bG/Y*ue\u0016\fW\u000eC\u0004\u0003\\y\u0001\r!!\u0010\u0002\u0019E,XM]=N_:LGo\u001c:\t\u000f\tUa\u00041\u0001\u0003\u0018\u0005yQ\r_3dkR,7+\u001e2rk\u0016\u0014\u0018\u0010\u0006\n\u0002J\n\r$Q\rB4\u0005S\u0012iGa\u001c\u0003r\tM\u0004bBA\"?\u0001\u0007\u0011\u0011\u001b\u0005\b\u0003O|\u0002\u0019AAu\u0011\u001d\tYp\ba\u0001\u0003{DqAa\u001b \u0001\u0004\u00119!\u0001\tjg>+H/\u001a:n_N$\u0018+^3ss\"9!QA\u0010A\u0002\t\u001d\u0001b\u0002B\t?\u0001\u0007!q\u0001\u0005\b\u0005+y\u0002\u0019\u0001B\f\u0011%\u0011yb\bI\u0001\u0002\u0004\ti$A\rfq\u0016\u001cW\u000f^3Tk\n\fX/\u001a:zI\u0011,g-Y;mi\u0012B\u0014aB2m_NLgnZ\u000b\u0005\u0005w\u0012\u0019\t\u0006\u0004\u0003~\t}%\u0011\u0015\u000b\u0005\u0005\u007f\u0012)\n\u0005\u0003\u0003\u0002\n\rE\u0002\u0001\u0003\b\u0005\u000b\u000b#\u0019\u0001BD\u0005\u0005!\u0016\u0003\u0002BE\u0005\u001f\u0003BA!\u0003\u0003\f&!!QRAl\u0005\u001dqu\u000e\u001e5j]\u001e\u0004BA!\u0003\u0003\u0012&!!1SAl\u0005\r\te.\u001f\u0005\t\u0005/\u000bC\u00111\u0001\u0003\u001a\u0006!1m\u001c3f!\u0019\u0011IAa'\u0003\u0000%!!QTAl\u0005!a$-\u001f8b[\u0016t\u0004bBA~C\u0001\u0007\u0011Q \u0005\b\u0005G\u000b\u0003\u0019\u0001BS\u0003)!(/Y2f\u000bZ,g\u000e\u001e\t\u0005\u0005O\u0013\tL\u0004\u0003\u0003*\n5f\u0002BA@\u0005WK!a\u0019\u001b\n\u0007\t=&-A\tD_6\u0004\u0018\u000e\\1uS>tGK]1dKJLAAa-\u00036\n)\u0012+^3ss\u000e{W\u000e]5mCRLwN\\#wK:$(b\u0001BXE\u0006IAm\\#yK\u000e,H/\u001a\u000b\u0017\u0003\u0013\u0014YLa1\u0003F\n\u001d'\u0011\u001aBf\u0005\u001b\u0014yM!5\u0003T\"9\u00111\t\u0012A\u0002\tu\u0006\u0003BAR\u0005\u007fKAA!1\u0002&\nQ\u0011J\u001c9viF+XM]=\t\u000f\u0005\u001d(\u00051\u0001\u0002j\"9\u00111 \u0012A\u0002\u0005u\bb\u0002B6E\u0001\u0007!q\u0001\u0005\b\u0005#\u0011\u0003\u0019\u0001B\u0004\u0011\u001d\u0011YE\ta\u0001\u0005\u001bBqAa\u0017#\u0001\u0004\ti\u0004\u0003\u0004_E\u0001\u0007!Q\u0015\u0005\b\u0005+\u0011\u0003\u0019\u0001B\f\u0011\u001d\u0011)N\ta\u0001\u0005/\f!C\\8uS\u001aL7-\u0019;j_:dunZ4feB!!\u0011\u001cBp\u001b\t\u0011YNC\u0002\u0003^R\nA!\u001e;jY&!!\u0011\u001dBn\u0005iIe\u000e^3s]\u0006dgj\u001c;jM&\u001c\u0017\r^5p]2{wmZ3s\u0003\r\u001aw.\u001c9jY\u0016\u0014x+\u001b;i\u000bb\u0004(/Z:tS>t7i\u001c3f\u000f\u0016tw\n\u001d;j_:$bBa:\u0003n\nE(1\u001fB|\u0005s\u0014Y\u0010E\u0003s\u0005S\f\t,C\u0002\u0003lR\u00121eQ8na&dWM],ji\",\u0005\u0010\u001d:fgNLwN\\\"pI\u0016<UM\\(qi&|g\u000eC\u0004\u0003p\u000e\u0002\rA!0\u0002\u0015%t\u0007/\u001e;Rk\u0016\u0014\u0018\u0010\u0003\u0004_G\u0001\u0007!Q\u0015\u0005\b\u0005k\u001c\u0003\u0019AA\u007f\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{g\u000e^3yi\"9\u0011q]\u0012A\u0002\u0005%\bb\u0002BkG\u0001\u0007!q\u001b\u0005\b\u0005{\u001c\u0003\u0019\u0001B\u0000\u0003=\u0019Xm]:j_:$\u0015\r^1cCN,\u0007\u0003BB\u0001\u0007\u000fi!aa\u0001\u000b\u0007\r\u0015\u0001+\u0001\u0005eCR\f'-Y:f\u0013\u0011\u0019Iaa\u0001\u0003#\u0011\u000bG/\u00192bg\u0016\u0014VMZ3sK:\u001cW-\u0001\u0007hKR|%oQ8na&dW\r\u0006\u0007\u00022\u000e=1\u0011CB\u000b\u0007/\u0019I\u0002C\u0004\u0002|\u0012\u0002\r!!@\t\u000f\rMA\u00051\u0001\u0003>\u0006\t\u0012N\\5uS\u0006d\u0017J\u001c9viF+XM]=\t\ry#\u0003\u0019\u0001BS\u0011\u001d\t9\u000f\na\u0001\u0003SDqA!6%\u0001\u0004\u00119.\u0001\tdY\u0016\f'/U;fef\u001c\u0015m\u00195fgR\u00111q\u0004\t\u0005\u0005\u0013\u0019\t#\u0003\u0003\u0004$\u0005]'\u0001\u0002'p]\u001e\f1c\u00197fCJ\u0004&/\u001a)beN,'oQ1dQ\u0016\f\u0011d\u00197fCJ,\u00050Z2vi\u0006\u0014G.Z)vKJL8)Y2iK\u0006\u00192\r\\3be\u000e{W\u000e]5mKJ\u001c\u0015m\u00195fg\u0006y\u0011N\\:feRLe\u000e^8DC\u000eDW\r\u0006\u0006\u00040\rU2qHB!\u0007+\u0002BA!\u0003\u00042%!11GAl\u0005\u0011)f.\u001b;\t\u000f\r]\u0012\u00061\u0001\u0004:\u0005q\u0001O]3QCJ\u001cX\rZ)vKJL\b\u0003BAR\u0007wIAa!\u0010\u0002&\nq\u0001K]3QCJ\u001cX\rZ)vKJL\bbBAtS\u0001\u0007\u0011\u0011\u001e\u0005\b\u0007\u0007J\u0003\u0019AB#\u0003-\u0001\u0018M]:fIF+XM]=\u0011\t\r\u001d3\u0011K\u0007\u0003\u0007\u0013RAaa\u0013\u0004N\u00051\u0001\u000f[1tKNT1aa\u00145\u0003!1'o\u001c8uK:$\u0017\u0002BB*\u0007\u0013\u0012\u0011BQ1tKN#\u0018\r^3\t\u000f\r]\u0013\u00061\u0001\u0004Z\u0005!\u0002/\u0019:tS:<gj\u001c;jM&\u001c\u0017\r^5p]N\u0004b!a5\u0004\\\r}\u0013\u0002BB/\u0003G\u00141aU3u!\u0011\u0011In!\u0019\n\t\r\r$1\u001c\u0002\u0015\u0013:$XM\u001d8bY:{G/\u001b4jG\u0006$\u0018n\u001c8\u0002%\u001d,GoQ=qQ\u0016\u0014h)\u001e8di&|gn]\u000b\u0003\u0007S\u0002baa\u001b\u0004p\rMTBAB7\u0015\r\u0011iNQ\u0005\u0005\u0007c\u001aiG\u0001\u0003MSN$\b\u0003BA \u0007kJAaa\u001e\u0002B\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006)1\r\\8tKR\u00111qF\u0001\u0010G\",7m\u001b)be\u0006lW\r^3sgRA1qFBA\u0007\u0017\u001by\tC\u0004\u0004\u00042\u0002\ra!\"\u0002\u0017E,XM]=QCJ\fWn\u001d\t\u0007\u0005\u0013\u00199)!5\n\t\r%\u0015q\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0007\u001bc\u0003\u0019AAu\u0003-9\u0017N^3o!\u0006\u0014\u0018-\\:\t\u000f\rEE\u00061\u0001\u0002j\u0006yQ\r\u001f;sC\u000e$X\r\u001a)be\u0006l7\u000fK\u0003-\u0007+\u001b9\u000b\u0005\u0004\u0003\n\r]51T\u0005\u0005\u00073\u000b9N\u0001\u0004uQJ|wo\u001d\t\u0005\u0007;\u001b\u0019+\u0004\u0002\u0004 *\u00191\u0011\u0015\u001d\u0002\u0015\u0015D8-\u001a9uS>t7/\u0003\u0003\u0004&\u000e}%A\u0007)be\u0006lW\r^3s\u001d>$hi\\;oI\u0016C8-\u001a9uS>t7EABN\u0003=)\u00050Z2vi&|g.\u00128hS:,\u0007C\u0001:/'\rq3q\u0016\t\u0005\u0005\u0013\u0019\t,\u0003\u0003\u00044\u0006]'AB!osJ+g\r\u0006\u0002\u0004,\u0006\u0019\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'V\u001111\u0018\t\u0005\u0005\u0013\u0019i,\u0003\u0003\u0004@\u0006]'aA%oi\u0006!\u0002\u000bT!O?\n+\u0016\n\u0014#J\u001d\u001e{FKU%F'\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTCABdU\u0011\t)Ba\n")
public abstract class ExecutionEngine
implements Closeable {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final DefaultQueryLanguageLookup defaultLanguageLookup;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private DefaultQueryLanguageLookup defaultLanguageLookup() {
        return this.defaultLanguageLookup;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            DefaultQueryLanguageScope queryLangScope = context.kernelTransaction().defaultQueryLanguageScope();
            CypherVersion defaultLanguage = this.defaultLanguageLookup().dbDefaultQueryLanguage(queryLangScope, context.databaseId(), this.config().systemDefaultLanguage());
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, defaultLanguage, profile, couldContainSensitiveFields, TransactionalContext.DatabaseMode.COMPOSITE.equals((Object)context.databaseMode()));
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        ExecutableQuery executableQuery;
        context.executingQuery().onPreparseReady(query.resolvedLanguage());
        try {
            executableQuery = this.getOrCompile(context, query, tracer, params, notificationLogger);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ErrorGqlStatusObject) {
                Throwable throwable3 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable4 = throwable3;
                    if (throwable4 instanceof Status.HasStatus) {
                        Throwable throwable5 = throwable4;
                        status = ((Status.HasStatus)throwable5).status();
                    } else {
                        status = null;
                    }
                    Status status2 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable3.getMessage(), status2, (ErrorGqlStatusObject)throwable3);
                }
                throw throwable3;
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                if (isOutermostQuery) {
                    Status status;
                    Throwable throwable7 = throwable6;
                    if (throwable7 instanceof Status.HasStatus) {
                        Throwable throwable8 = throwable7;
                        status = ((Status.HasStatus)throwable8).status();
                    } else {
                        status = null;
                    }
                    Status status3 = status;
                    queryMonitor.endFailure(context.executingQuery(), throwable6.getMessage(), status3, null);
                }
                throw throwable6;
            }
            throw throwable;
        }
        ExecutableQuery executableQuery2 = executableQuery;
        String string = query.options().queryOptions().executionMode().name();
        String string2 = "explain";
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.checkParameters(executableQuery2.paramNames(), params, executableQuery2.extractedParams());
        }
        MapValue combinedParams = params.updatedWith(executableQuery2.extractedParams());
        if (isOutermostQuery) {
            context.executingQuery().onObfuscatorReady(executableQuery2.queryObfuscator(), query.options().offset().offset());
            context.executingQuery().onCompilationCompleted(executableQuery2.compilerInfo(), executableQuery2.planDescriptionSupplier(), executableQuery2.deprecationNotificationsProvider(query.options().offset()), executableQuery2.executionPlanCacheKeyHash());
        }
        QueryRuntimeConfig queryConfig = QueryRuntimeConfig$.MODULE$.createFrom(query.options().queryOptions(), query.options().derivedOptions(), this.config());
        return executableQuery2.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber, queryConfig);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger, DatabaseReference sessionDatabase) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount, Function0<Object> shouldRecompile) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() && shouldRecompile.apply$mcZ$sp()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)StaticAccessMode.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(inputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges(), inputQuery.resolvedLanguage());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger, new DatabaseReference(null, context){
                            private final TransactionalContext context$3;

                            public String name() {
                                return super.name();
                            }

                            public NormalizedDatabaseName alias() {
                                throw new NotImplementedError();
                            }

                            public Optional<NormalizedDatabaseName> namespace() {
                                throw new NotImplementedError();
                            }

                            public boolean isPrimary() {
                                throw new NotImplementedError();
                            }

                            public UUID id() {
                                throw new NotImplementedError();
                            }

                            public NamedDatabaseId namedDatabaseId() {
                                throw new NotImplementedError();
                            }

                            public String toPrettyString() {
                                throw new NotImplementedError();
                            }

                            public NormalizedDatabaseName fullName() {
                                return this.context$3.databaseId().normalizedName();
                            }

                            public boolean isComposite() {
                                return this.context$3.databaseMode().equals((Object)TransactionalContext.DatabaseMode.COMPOSITE);
                            }

                            public int compareTo(DatabaseReference o) {
                                throw new NotImplementedError();
                            }

                            public String owningDatabaseName() {
                                return this.fullName().name();
                            }

                            public NormalizedCatalogEntry catalogEntry() {
                                throw new NotImplementedError();
                            }

                            public boolean isShard() {
                                return false;
                            }
                            {
                                this.context$3 = context$3;
                            }
                        });
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw CompilationException$.MODULE$.tooFrequentSchemaChanges();
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public long clearPreParserCache() {
        return this.preParser().clearCache();
    }

    public long clearExecutableQueryCache() {
        return this.queryCache().clear();
    }

    public long clearCompilerCaches() {
        return this.masterCompiler().clearCaches();
    }

    public void insertIntoCache(PreParsedQuery preParsedQuery, MapValue params, BaseState parsedQuery, Set<InternalNotification> parsingNotifications) {
        this.preParser().insertIntoCache(preParsedQuery);
        this.masterCompiler().insertIntoCache(preParsedQuery, params, parsedQuery, parsingNotifications);
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = this.config().vectorTypeEnabled() ? Function$.MODULE$.functionInfoWithFeatureFlags((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{SemanticFeature.VectorType$.MODULE$.productPrefix()}))).map((Function1)FunctionWithInformation$.MODULE$) : Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    @Override
    public void close() {
        this.queryCaches().close();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw ParameterNotFoundException.expectedParam((String)Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "), (Iterable)givenParams.keySet());
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.defaultLanguageLookup = (DefaultQueryLanguageLookup)queryService.getDependencyResolver().resolveDependency(DefaultQueryLanguageLookup.class);
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

