/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.javacompat;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.CompilerFactory;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.javacompat.ExecutionEngine;
import org.neo4j.cypher.internal.javacompat.MaterialisedResult;
import org.neo4j.cypher.internal.javacompat.ResultSubscriber;
import org.neo4j.cypher.internal.javacompat.UnstableSnapshotException;
import org.neo4j.cypher.internal.preparser.FullyParsedQuery;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.graphdb.Result;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.values.virtual.MapValue;

public class SnapshotExecutionEngine
extends ExecutionEngine {
    private final int maxQueryExecutionAttempts;

    SnapshotExecutionEngine(GraphDatabaseQueryService queryService, Config config, CypherQueryCaches queryCaches, InternalLogProvider logProvider, CompilerFactory compilerFactory) {
        super(queryService, queryCaches, logProvider, compilerFactory);
        this.maxQueryExecutionAttempts = (Integer)config.get(GraphDatabaseInternalSettings.snapshot_query_retries);
    }

    @Override
    public Result executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, querySubscriber);
        ResultSubscriber resultSubscriber = new ResultSubscriber(context);
        MaterialisedResult materialisedResult = this.executeWithRetries(query, context, queryExecutor);
        QueryExecution queryExecution = materialisedResult.stream(resultSubscriber);
        resultSubscriber.init(queryExecution);
        return resultSubscriber;
    }

    @Override
    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, querySubscriber, monitor);
        MaterialisedResult materialisedResult = this.executeWithRetries(query, context, queryExecutor);
        return materialisedResult.stream(subscriber);
    }

    @Override
    public QueryExecution executeQuery(String query, MapValue parameters, TransactionalContext context, boolean prePopulate, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        return this.executeQuery(query, parameters, context, prePopulate, subscriber, this.cypherExecutionEngine.defaultQueryExecutionMonitor());
    }

    @Override
    public QueryExecution executeQuery(FullyParsedQuery query, MapValue parameters, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) throws QueryExecutionKernelException {
        QueryExecutor queryExecutor = querySubscriber -> super.executeQuery(query, parameters, context, prePopulate, input, queryMonitor, querySubscriber);
        MaterialisedResult materialisedResult = this.executeWithRetries(query.description(), context, queryExecutor);
        return materialisedResult.stream(subscriber);
    }

    protected MaterialisedResult executeWithRetries(String query, TransactionalContext context, QueryExecutor executor) throws QueryExecutionKernelException {
        MaterialisedResult materialisedResult;
        boolean dirtySnapshot;
        VersionContext versionContext = SnapshotExecutionEngine.getCursorContext(context);
        int attempt = 0;
        do {
            if (attempt == this.maxQueryExecutionAttempts) {
                throw QueryExecutionKernelException.wrapError((Throwable)((Object)UnstableSnapshotException.internalError(this.getClass().getSimpleName(), "Unable to get clean data snapshot for query '%s' after %d attempts.", query, attempt)));
            }
            if (attempt > 0) {
                context.executingQuery().onRetryAttempted();
            }
            ++attempt;
            versionContext.initRead();
            context.kernelTransaction().reportVisibilityBoundaryRefresh();
            materialisedResult = new MaterialisedResult();
            QueryExecution queryExecution = executor.execute(materialisedResult);
            materialisedResult.consumeAll(queryExecution);
            if (context.transaction().terminationReason().isEmpty() && context.transaction().kernelTransaction().isSchemaTransaction()) {
                return materialisedResult;
            }
            dirtySnapshot = versionContext.isDirty();
            if (!this.isUnstableSnapshot(materialisedResult, dirtySnapshot)) continue;
            throw QueryExecutionKernelException.wrapError((Throwable)((Object)UnstableSnapshotException.internalError(this.getClass().getSimpleName(), "Unable to get clean data snapshot for query '%s' that performs updates.", query, attempt)));
        } while (dirtySnapshot);
        return materialisedResult;
    }

    private boolean isUnstableSnapshot(MaterialisedResult materialisedResult, boolean dirtySnapshot) {
        return dirtySnapshot && materialisedResult.getQueryStatistics().containsUpdates();
    }

    private static VersionContext getCursorContext(TransactionalContext context) {
        return context.kernelTransaction().cursorContext().getVersionContext();
    }

    @FunctionalInterface
    protected static interface QueryExecutor {
        public QueryExecution execute(MaterialisedResult var1) throws QueryExecutionKernelException;
    }
}

