/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.MinimumGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.histogram.Histogram;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundGraphStatistics$;
import org.neo4j.cypher.internal.util.Cardinality;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.NameId$;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.Selectivity;
import org.neo4j.cypher.internal.util.Selectivity$;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005us!B\t\u0013\u0011\u0003ib!B\u0010\u0013\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003\"B\u0015\u0002\t\u0003Q\u0003\"B\u0015\u0002\t\u00031e\u0001B,\u0002\taC\u0001\u0002S\u0003\u0003\u0002\u0003\u0006I!\u0013\u0005\t%\u0016\u0011\t\u0011)A\u0005'\"Aq(\u0002B\u0001B\u0003%\u0001\tC\u0003(\u000b\u0011\u0005q\fC\u0003f\u000b\u0011\u0005c\rC\u0003v\u000b\u0011\u0005c\u000fC\u0003y\u000b\u0011\u0005\u0013\u0010C\u0003~\u000b\u0011\u0005c\u0010C\u0004\u0002\"\u0015!\t%a\t\t\u000f\u0005ER\u0001\"\u0011\u00024!9\u0011\u0011J\u0003\u0005\n\u0005-\u0013a\b+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e\u000fJ\f\u0007\u000f[*uCRL7\u000f^5dg*\u00111\u0003F\u0001\u0004gBL'BA\u000b\u0017\u0003!Ig\u000e^3s]\u0006d'BA\f\u0019\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011DG\u0001\u0006]\u0016|GG\u001b\u0006\u00027\u0005\u0019qN]4\u0004\u0001A\u0011a$A\u0007\u0002%\tyBK]1og\u0006\u001cG/[8o\u0005>,h\u000eZ$sCBD7\u000b^1uSN$\u0018nY:\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005)\u0011\r\u001d9msR\u00191F\r \u0011\u00051\u0002T\"A\u0017\u000b\u0005Mq#BA\u0018\u0015\u0003\u001d\u0001H.\u00198oKJL!!M\u0017\u0003-5Kg.[7v[\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGNDQaM\u0002A\u0002Q\nA\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8uKb$\bCA\u001b=\u001b\u00051$BA\u001c9\u0003\u0015\tX/\u001a:z\u0015\tI$(\u0001\u0003j[Bd'BA\u001e\u0019\u0003\u0019YWM\u001d8fY&\u0011QH\u000e\u0002\u0015)J\fgn]1di&|g.\u00197D_:$X\r\u001f;\t\u000b}\u001a\u0001\u0019\u0001!\u0002\u00071|w\r\u0005\u0002B\t6\t!I\u0003\u0002D1\u00059An\\4hS:<\u0017BA#C\u0005-Ie\u000e^3s]\u0006dGj\\4\u0015\t-:\u0015K\u0016\u0005\u0006\u0011\u0012\u0001\r!S\u0001\u0005e\u0016\fG\r\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006\u0019\u0011\r]5\u000b\u0005mr%BA\u000b\u0019\u0013\t\u00016J\u0001\u0003SK\u0006$\u0007\"\u0002*\u0005\u0001\u0004\u0019\u0016AC:dQ\u0016l\u0017MU3bIB\u0011!\nV\u0005\u0003+.\u0013!bU2iK6\f'+Z1e\u0011\u0015yD\u00011\u0001A\u0005\r\u0012\u0015m]3Ue\u0006t7/Y2uS>t'i\\;oI\u001e\u0013\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u001cB!B\u0011Z9B\u0011AFW\u0005\u000376\u0012qb\u0012:ba\"\u001cF/\u0019;jgRL7m\u001d\t\u0003=uK!A\u0018\n\u00039%sG-\u001a=EKN\u001c'/\u001b9u_J\u001cu.\u001c9bi&\u0014\u0017\u000e\\5usR!\u0001MY2e!\t\tW!D\u0001\u0002\u0011\u0015A\u0015\u00021\u0001J\u0011\u0015\u0011\u0016\u00021\u0001T\u0011\u0015y\u0014\u00021\u0001A\u0003Y)h.[9vKZ\u000bG.^3TK2,7\r^5wSRLHCA4q!\r\u0011\u0003N[\u0005\u0003S\u000e\u0012aa\u00149uS>t\u0007CA6o\u001b\u0005a'BA7\u0015\u0003\u0011)H/\u001b7\n\u0005=d'aC*fY\u0016\u001cG/\u001b<jifDQ!\u001d\u0006A\u0002I\fQ!\u001b8eKb\u0004\"\u0001L:\n\u0005Ql#aD%oI\u0016DH)Z:de&\u0004Ho\u001c:\u0002C%tG-\u001a=Qe>\u0004XM\u001d;z\u0013Ntu\u000e\u001e(vY2\u001cV\r\\3di&4\u0018\u000e^=\u0015\u0005\u001d<\b\"B9\f\u0001\u0004\u0011\u0018a\u00058pI\u0016\u001c\u0018\t\u001c7DCJ$\u0017N\\1mSRLH#\u0001>\u0011\u0005-\\\u0018B\u0001?m\u0005-\u0019\u0015M\u001d3j]\u0006d\u0017\u000e^=\u0002I5|7\u000f^\"p[6|g\u000eT1cK2<\u0015N^3o%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d+za\u0016$2a`A\u000f!\u0019\t\t!!\u0005\u0002\u00189!\u00111AA\u0007\u001d\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00059\u00051AH]8pizJ\u0011\u0001J\u0005\u0004\u0003\u001f\u0019\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003'\t)BA\u0002TKFT1!a\u0004$!\r\u0011\u0013\u0011D\u0005\u0004\u00037\u0019#aA%oi\"9\u0011qD\u0007A\u0002\u0005]\u0011a\u0001;za\u0006Ibn\u001c3fg^KG\u000f\u001b'bE\u0016d7)\u0019:eS:\fG.\u001b;z)\rQ\u0018Q\u0005\u0005\b\u0003Oq\u0001\u0019AA\u0015\u00031i\u0017-\u001f2f\u0019\u0006\u0014W\r\\%e!\u0011\u0011\u0003.a\u000b\u0011\u0007-\fi#C\u0002\u000201\u0014q\u0001T1cK2LE-\u0001\fqCR$XM\u001d8Ti\u0016\u00048)\u0019:eS:\fG.\u001b;z)\u001dQ\u0018QGA\u001d\u0003\u000bBq!a\u000e\u0010\u0001\u0004\tI#A\u0005ge>lG*\u00192fY\"9\u00111H\bA\u0002\u0005u\u0012!\u0003:fYRK\b/Z%e!\u0011\u0011\u0003.a\u0010\u0011\u0007-\f\t%C\u0002\u0002D1\u0014\u0011BU3m)f\u0004X-\u00133\t\u000f\u0005\u001ds\u00021\u0001\u0002*\u00059Ao\u001c'bE\u0016d\u0017AG7bs\n,7*\u001a:oK2Le\u000eZ3y\t\u0016\u001c8M]5qi>\u0014H\u0003BA'\u00033\u0002BA\t5\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V9\u000baa]2iK6\f\u0017b\u0001;\u0002T!1\u00111\f\tA\u0002I\fq\"\u001b8eKb$Um]2sSB$xN\u001d")
public final class TransactionBoundGraphStatistics {
    public static MinimumGraphStatistics apply(Read read, SchemaRead schemaRead, InternalLog log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(read, schemaRead, log);
    }

    public static MinimumGraphStatistics apply(TransactionalContext transactionalContext, InternalLog log) {
        return TransactionBoundGraphStatistics$.MODULE$.apply(transactionalContext, log);
    }

    private static class BaseTransactionBoundGraphStatistics
    implements GraphStatistics,
    IndexDescriptorCompatibility {
        private final Read read;
        private final SchemaRead schemaRead;
        private final InternalLog log;

        @Override
        public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
        }

        @Override
        public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
            return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
        }

        @Override
        public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
        }

        @Override
        public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
            return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
        }

        @Override
        public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
        }

        @Override
        public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
            return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
        }

        public Set<Histogram> getHistograms(Set<LabelId> labels, Option<PropertyKeyId> propertyKey) {
            return GraphStatistics.getHistograms$((GraphStatistics)this, labels, propertyKey);
        }

        public Set<Histogram> getHistograms(RelTypeId typeId, Option<PropertyKeyId> propertyKey) {
            return GraphStatistics.getHistograms$((GraphStatistics)this, (RelTypeId)typeId, propertyKey);
        }

        public Option<Selectivity> uniqueValueSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            Option option;
            try {
                Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                option = maybeIndexDescriptor.flatMap((Function1 & Serializable)indexDescriptor -> {
                    long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                    if (indexSize == 0L) {
                        return new Some((Object)Selectivity$.MODULE$.ZERO());
                    }
                    double indexEntrySelectivity = $this.schemaRead.indexUniqueValuesSelectivity(indexDescriptor);
                    if (indexEntrySelectivity == 0.0) {
                        return new Some((Object)Selectivity$.MODULE$.ZERO());
                    }
                    double frequencyOfEntitiesWithSameValue = 1.0 / indexEntrySelectivity;
                    double indexSelectivity = frequencyOfEntitiesWithSameValue / (double)indexSize;
                    return Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
                });
            }
            catch (IndexNotFoundKernelException e) {
                this.log.debug("Index not found for uniqueValueSelectivity", (Throwable)e);
                option = None$.MODULE$;
            }
            return option;
        }

        public Option<Selectivity> indexPropertyIsNotNullSelectivity(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
            None$ none$;
            block7: {
                try {
                    double d;
                    IndexDescriptor.EntityType entityType = index.entityType();
                    if (entityType instanceof IndexDescriptor.EntityType$.Node) {
                        IndexDescriptor.EntityType$.Node node = (IndexDescriptor.EntityType$.Node)entityType;
                        LabelId label = node.label();
                        d = this.read.estimateCountsForNode(NameId$.MODULE$.toKernelEncode((NameId)label));
                    } else if (entityType instanceof IndexDescriptor.EntityType$.Relationship) {
                        IndexDescriptor.EntityType$.Relationship relationship = (IndexDescriptor.EntityType$.Relationship)entityType;
                        RelTypeId relType = relationship.relType();
                        d = this.read.estimateCountsForRelationships(-1, NameId$.MODULE$.toKernelEncode((NameId)relType), -1);
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    double entitiesCount = d;
                    if (entitiesCount == 0.0) {
                        none$ = new Some((Object)Selectivity$.MODULE$.ZERO());
                        break block7;
                    }
                    Option<IndexDescriptor> maybeIndexDescriptor = this.maybeKernelIndexDescriptor(index);
                    none$ = maybeIndexDescriptor.flatMap((Function1 & Serializable)indexDescriptor -> {
                        long indexSize = $this.schemaRead.indexSize(indexDescriptor);
                        double indexSelectivity = (double)indexSize / entitiesCount;
                        return Selectivity$.MODULE$.of(Math.min(indexSelectivity, 1.0));
                    });
                }
                catch (IndexNotFoundKernelException e) {
                    this.log.debug("Index not found for indexPropertyExistsSelectivity", (Throwable)e);
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public Cardinality nodesAllCardinality() {
            return new Cardinality((double)this.read.estimateCountsForNode(-1));
        }

        public Seq<Object> mostCommonLabelGivenRelationshipType(int typ) {
            return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(this.read.mostCommonLabelGivenRelationshipType(typ)).asScala().toSeq().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)));
        }

        public Cardinality nodesWithLabelCardinality(Option<LabelId> maybeLabelId) {
            long count = BoxesRunTime.unboxToLong((Object)maybeLabelId.map((Function1 & Serializable)labelId -> BoxesRunTime.boxToLong((long)this.read.estimateCountsForNode(labelId.id()))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
            return new Cardinality((double)count);
        }

        public Cardinality patternStepCardinality(Option<LabelId> fromLabel, Option<RelTypeId> relTypeId, Option<LabelId> toLabel) {
            return new Cardinality((double)this.read.estimateCountsForRelationships(NameId$.MODULE$.toKernelEncode(fromLabel), NameId$.MODULE$.toKernelEncode(relTypeId), NameId$.MODULE$.toKernelEncode(toLabel)));
        }

        private Option<IndexDescriptor> maybeKernelIndexDescriptor(org.neo4j.cypher.internal.planner.spi.IndexDescriptor indexDescriptor) {
            return Option$.MODULE$.apply((Object)this.schemaRead.index(this.cypherToKernelSchema(indexDescriptor), this.cypherToKernel(indexDescriptor.indexType()))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BaseTransactionBoundGraphStatistics.$anonfun$maybeKernelIndexDescriptor$1(x$2)));
        }

        public static final /* synthetic */ boolean $anonfun$maybeKernelIndexDescriptor$1(IndexDescriptor x$2) {
            IndexDescriptor indexDescriptor = x$2;
            IndexDescriptor indexDescriptor2 = IndexDescriptor.NO_INDEX;
            return indexDescriptor == null ? indexDescriptor2 != null : !indexDescriptor.equals(indexDescriptor2);
        }

        public BaseTransactionBoundGraphStatistics(Read read, SchemaRead schemaRead, InternalLog log) {
            this.read = read;
            this.schemaRead = schemaRead;
            this.log = log;
            GraphStatistics.$init$((GraphStatistics)this);
            IndexDescriptorCompatibility.$init$(this);
        }
    }
}

