/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.ResourceManagedCursorPool;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.DefaultCloseListenable;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.memory.MemoryTracker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005e4A!\u0005\n\u0001;!A1\u0006\u0001B\u0001B\u0003&A\u0006\u0003\u00050\u0001\t\u0005\t\u0015)\u00031\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\"B!\u0001\t\u0003\u0011\u0005BB$\u0001A\u0003&\u0001\n\u0003\u0004L\u0001\u0001\u0006K\u0001\u0014\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002)\t\u000bM\u0003A\u0011\u0001+\t\u000bU\u0003A\u0011\u0001,\t\u000b]\u0003A\u0011\u0001-\t\u000be\u0003A\u0011\t.\t\u000b\u0005\u0004A\u0011\t2\t\u000b\u0019\u0004A\u0011A4\t\u000b5\u0004A\u0011\t2\t\u000b9\u0004A\u0011I8\t\u000bI\u0004A\u0011B:\u0003#\u0015C\bO]3tg&|gnQ;sg>\u00148O\u0003\u0002\u0014)\u00059!/\u001e8uS6,'BA\u000b\u0017\u0003!Ig\u000e^3s]\u0006d'BA\f\u0019\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011DG\u0001\u0006]\u0016|GG\u001b\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AH\u0014\u0011\u0005})S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013aA1qS*\u00111\u0005J\u0001\u0007W\u0016\u0014h.\u001a7\u000b\u0005UA\u0012B\u0001\u0014!\u0005Y!UMZ1vYR\u001cEn\\:f\u0019&\u001cH/\u001a8bE2,\u0007C\u0001\u0015*\u001b\u0005\u0011\u0012B\u0001\u0016\u0013\u0005e\u0011Vm]8ve\u000e,W*\u00198bO\u0016$7)\u001e:t_J\u0004vn\u001c7\u0002\u001b\r,(o]8s\r\u0006\u001cGo\u001c:z!\tyR&\u0003\u0002/A\ti1)\u001e:t_J4\u0015m\u0019;pef\fQbY;sg>\u00148i\u001c8uKb$\bCA\u00199\u001b\u0005\u0011$BA\u001a5\u0003\u001d\u0019wN\u001c;fqRT!!\u000e\u001c\u0002\u0013A\fw-Z2bG\",'BA\u001c\u0019\u0003\tIw.\u0003\u0002:e\ti1)\u001e:t_J\u001cuN\u001c;fqR\fQ\"\\3n_JLHK]1dW\u0016\u0014\bC\u0001\u001f@\u001b\u0005i$B\u0001 \u0019\u0003\u0019iW-\\8ss&\u0011\u0001)\u0010\u0002\u000e\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005!\u0002\u0001\"B\u0016\u0005\u0001\u0004a\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0014aC0o_\u0012,7)\u001e:t_J\u0004\"aH%\n\u0005)\u0003#A\u0003(pI\u0016\u001cUO]:pe\u00069rL]3mCRLwN\\:iSB\u001c6-\u00198DkJ\u001cxN\u001d\t\u0003?5K!A\u0014\u0011\u0003-I+G.\u0019;j_:\u001c\b.\u001b9TG\u0006t7)\u001e:t_J\fqb\u00189s_B,'\u000f^=DkJ\u001cxN\u001d\t\u0003?EK!A\u0015\u0011\u0003\u001dA\u0013x\u000e]3sif\u001cUO]:pe\u0006Qan\u001c3f\u0007V\u00148o\u001c:\u0016\u0003!\u000baC]3mCRLwN\\:iSB\u001c6-\u00198DkJ\u001cxN]\u000b\u0002\u0019\u0006q\u0001O]8qKJ$\u0018pQ;sg>\u0014X#\u0001)\u0002\u0011%\u001c8\t\\8tK\u0012$\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\b\u0005>|G.Z1o\u00035\u0019Gn\\:f\u0013:$XM\u001d8bYR\t1\r\u0005\u0002]I&\u0011Q-\u0018\u0002\u0005+:LG/A\btKR\\UM\u001d8fYR\u0013\u0018mY3s)\t\u0019\u0007\u000eC\u0003j\u001b\u0001\u0007!.\u0001\u0004ue\u0006\u001cWM\u001d\t\u0003?-L!\u0001\u001c\u0011\u0003!-+'O\\3m%\u0016\fG\r\u0016:bG\u0016\u0014\u0018\u0001D2m_N,7)\u001e:t_J\u001c\u0018AG:fi\u000e+(o]8s\r\u0006\u001cGo\u001c:z\u0003:$7i\u001c8uKb$HcA2qc\")1f\u0004a\u0001Y!)qf\u0004a\u0001a\u0005\tbn\u001c;SKR,(O\\3e)>\u0004vn\u001c7\u0015\u0005m#\b\"B;\u0011\u0001\u00041\u0018AB2veN|'\u000f\u0005\u0002 o&\u0011\u0001\u0010\t\u0002\u0007\u0007V\u00148o\u001c:")
public class ExpressionCursors
extends DefaultCloseListenable
implements ResourceManagedCursorPool {
    private CursorFactory cursorFactory;
    private CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private NodeCursor _nodeCursor;
    private RelationshipScanCursor _relationshipScanCursor;
    private PropertyCursor _propertyCursor;

    public NodeCursor nodeCursor() {
        if (this._nodeCursor == null) {
            this._nodeCursor = this.cursorFactory.allocateNodeCursor(this.cursorContext);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._nodeCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._nodeCursor;
    }

    public RelationshipScanCursor relationshipScanCursor() {
        if (this._relationshipScanCursor == null) {
            this._relationshipScanCursor = this.cursorFactory.allocateRelationshipScanCursor(this.cursorContext);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._relationshipScanCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._relationshipScanCursor;
    }

    public PropertyCursor propertyCursor() {
        if (this._propertyCursor == null) {
            this._propertyCursor = this.cursorFactory.allocatePropertyCursor(this.cursorContext, this.memoryTracker);
        }
        if (AssertionRunner.ASSERTIONS_ENABLED && !this.notReturnedToPool((Cursor)this._propertyCursor)) {
            throw new AssertionError((Object)"assertion failed");
        }
        return this._propertyCursor;
    }

    public boolean isClosed() {
        return this._nodeCursor == null && this._relationshipScanCursor == null && this._propertyCursor == null;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            NodeCursor nodeCursorToClose = this._nodeCursor;
            RelationshipScanCursor relationshipScanCursorToClose = this._relationshipScanCursor;
            PropertyCursor propertyCursorToClose = this._propertyCursor;
            this._nodeCursor = null;
            this._relationshipScanCursor = null;
            this._propertyCursor = null;
            IOUtils.closeAll((AutoCloseable[])((AutoCloseable[])new Cursor[]{nodeCursorToClose, relationshipScanCursorToClose, propertyCursorToClose}));
            return;
        }
    }

    public void setKernelTracer(KernelReadTracer tracer) {
        this.nodeCursor().setTracer(tracer);
        this.relationshipScanCursor().setTracer(tracer);
        this.propertyCursor().setTracer(tracer);
    }

    @Override
    public void closeCursors() {
        this.closeInternal();
    }

    @Override
    public void setCursorFactoryAndContext(CursorFactory cursorFactory, CursorContext cursorContext) {
        this.cursorFactory = cursorFactory;
        this.cursorContext = cursorContext;
    }

    private boolean notReturnedToPool(Cursor cursor) {
        Cursor cursor2 = cursor;
        if (cursor2 instanceof TraceableCursor) {
            TraceableCursor traceableCursor = (TraceableCursor)cursor2;
            return !traceableCursor.returnedToPool();
        }
        return true;
    }

    public ExpressionCursors(CursorFactory cursorFactory, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.cursorFactory = cursorFactory;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this._nodeCursor = this.cursorFactory.allocateNodeCursor(this.cursorContext);
        this._relationshipScanCursor = this.cursorFactory.allocateRelationshipScanCursor(this.cursorContext);
        this._propertyCursor = this.cursorFactory.allocatePropertyCursor(this.cursorContext, memoryTracker);
    }
}

