/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.EntityNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalEntities;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TraversalDirection;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ComposedSourceCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.ListCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansion;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.RelationshipExpansionCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.DirectedTypes;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;

public class ProductGraphTraversalCursor
implements AutoCloseable {
    private final DataGraphRelationshipCursor graphCursor;
    private final RelationshipExpansionCursor relationshipExpansionCursor;
    private boolean initialized = false;
    private final DirectedTypes directedTypes;
    private final ComposedSourceCursor<List<State>, State, RelationshipExpansion> nfaCursor;
    private TraversalDirection direction = TraversalDirection.FORWARD;

    public ProductGraphTraversalCursor(Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker mt, PPBFSHooks hooks) {
        this(new DataGraphRelationshipCursorImpl(read, nodeCursor, relCursor, hooks), mt);
    }

    public ProductGraphTraversalCursor(DataGraphRelationshipCursor graph, MemoryTracker mt) {
        this.graphCursor = graph;
        this.relationshipExpansionCursor = new RelationshipExpansionCursor();
        this.nfaCursor = new ComposedSourceCursor(new ListCursor(), this.relationshipExpansionCursor);
        this.directedTypes = new DirectedTypes(mt);
    }

    public State targetState() {
        return this.nfaCursor.current().targetState();
    }

    public State currentInputState() {
        return this.nfaCursor.currentIntermediate();
    }

    public long otherNodeReference() {
        return this.graphCursor.otherNodeReference();
    }

    public long relationshipReference() {
        return this.graphCursor.relationshipReference();
    }

    public RelationshipExpansion relationshipExpansion() {
        return this.nfaCursor.current();
    }

    public boolean next() {
        if (!this.initialized) {
            if (!this.nextRelationship()) {
                return false;
            }
            this.initialized = true;
        }
        while (true) {
            if (this.nfaCursor.next()) {
                if (!this.evaluateCurrent()) continue;
                return true;
            }
            if (!this.nextRelationship()) break;
        }
        return false;
    }

    private boolean nextRelationship() {
        this.nfaCursor.reset();
        return this.graphCursor.nextRelationship();
    }

    private boolean evaluateCurrent() {
        RelationshipExpansion expansion = this.nfaCursor.current();
        Direction expansionDir = switch (this.direction) {
            default -> throw new IncompatibleClassChangeError();
            case TraversalDirection.FORWARD -> expansion.direction();
            case TraversalDirection.BACKWARD -> expansion.direction().reverse();
        };
        return this.graphCursor.direction().matches(expansionDir) && (expansion.types() == null || ArrayUtils.contains((int[])expansion.types(), (int)this.graphCursor.type())) && expansion.testRelationship(this.graphCursor, this.direction) && expansion.endState(this.direction).test(this.graphCursor.otherNodeReference());
    }

    public void setNodeAndStates(long nodeId, List<State> states, TraversalDirection direction) {
        this.direction = direction;
        this.initialized = false;
        this.nfaCursor.setSource(states);
        this.relationshipExpansionCursor.setDirection(direction);
        this.directedTypes.clear();
        while (this.nfaCursor.next()) {
            RelationshipExpansion expansion = this.nfaCursor.current();
            Direction expansionDir = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case TraversalDirection.FORWARD -> expansion.direction();
                case TraversalDirection.BACKWARD -> expansion.direction().reverse();
            };
            this.directedTypes.addTypes(expansion.types(), expansionDir);
        }
        this.nfaCursor.reset();
        this.graphCursor.setNode(nodeId, RelationshipSelection.selection((DirectedTypes)this.directedTypes));
    }

    public void setTracer(KernelReadTracer tracer) {
        this.graphCursor.setTracer(tracer);
    }

    @Override
    public void close() throws Exception {
        this.nfaCursor.close();
    }

    public static class DataGraphRelationshipCursorImpl
    implements DataGraphRelationshipCursor {
        private final Read read;
        private final NodeCursor node;
        private final RelationshipTraversalCursor rel;
        private final PPBFSHooks hooks;

        public DataGraphRelationshipCursorImpl(Read read, NodeCursor node, RelationshipTraversalCursor rel, PPBFSHooks hooks) {
            this.read = read;
            this.node = node;
            this.rel = rel;
            this.hooks = hooks;
        }

        @Override
        public boolean nextRelationship() {
            this.hooks.cursorNextRelationship(this.node.nodeReference());
            return this.rel.next();
        }

        @Override
        public void setTracer(KernelReadTracer tracer) {
            this.node.setTracer(tracer);
            this.rel.setTracer(tracer);
        }

        @Override
        public void setNode(long nodeId, RelationshipSelection relationshipSelection) {
            this.hooks.cursorSetNode(nodeId);
            this.read.singleNode(nodeId, this.node);
            if (!this.node.next()) {
                ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
                throw new EntityNotFoundException(gql, "Node " + nodeId + " was unexpectedly deleted");
            }
            this.node.relationships(this.rel, relationshipSelection);
        }

        public long relationshipReference() {
            return this.rel.reference();
        }

        public long originNodeReference() {
            return this.rel.originNodeReference();
        }

        public long otherNodeReference() {
            return this.rel.otherNodeReference();
        }

        public long sourceNodeReference() {
            return this.rel.sourceNodeReference();
        }

        public long targetNodeReference() {
            return this.rel.targetNodeReference();
        }

        public int type() {
            return this.rel.type();
        }
    }

    public static interface DataGraphRelationshipCursor
    extends RelationshipTraversalEntities {
        public boolean nextRelationship();

        public void setNode(long var1, RelationshipSelection var3);

        default public RelationshipDirection direction() {
            return RelationshipDirection.directionOfStrict((long)this.originNodeReference(), (long)this.sourceNodeReference(), (long)this.targetNodeReference());
        }

        public void setTracer(KernelReadTracer var1);
    }
}

