/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.time.temporal.TemporalAmount;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherMath {
    private CypherMath() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static AnyValue add(AnyValue lhs, AnyValue rhs) {
        boolean lhsIsListValue;
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).plus((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof ArrayValue) {
            lhs = VirtualValues.fromArray((ArrayValue)((ArrayValue)lhs));
        }
        if (rhs instanceof ArrayValue) {
            rhs = VirtualValues.fromArray((ArrayValue)((ArrayValue)rhs));
        }
        if ((lhsIsListValue = lhs instanceof ListValue) && rhs instanceof ListValue) {
            return ((ListValue)lhs).appendAll((ListValue)rhs);
        }
        if (lhsIsListValue) {
            return ((ListValue)lhs).append(rhs);
        }
        if (rhs instanceof ListValue) {
            return ((ListValue)rhs).prepend(lhs);
        }
        if (lhs instanceof TextValue && rhs instanceof TextValue) {
            return ((TextValue)lhs).plus((TextValue)rhs);
        }
        if (lhs instanceof TextValue) {
            if (rhs instanceof Value) {
                if (!(rhs instanceof TemporalValue || rhs instanceof DurationValue || rhs instanceof PointValue)) {
                    return Values.stringValue((String)(((TextValue)lhs).stringValue() + ((Value)rhs).prettyPrint()));
                }
                return Values.stringValue((String)(((TextValue)lhs).stringValue() + rhs));
            }
        } else if (rhs instanceof TextValue && lhs instanceof Value) {
            if (!(lhs instanceof TemporalValue || lhs instanceof DurationValue || lhs instanceof PointValue)) {
                return Values.stringValue((String)(((Value)lhs).prettyPrint() + ((TextValue)rhs).stringValue()));
            }
            return Values.stringValue((String)(lhs + ((TextValue)rhs).stringValue()));
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).plus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue) {
            if (rhs instanceof TemporalValue) {
                return ((TemporalValue)rhs).plus((TemporalAmount)((DurationValue)lhs));
            }
            if (rhs instanceof DurationValue) {
                return ((DurationValue)lhs).add((DurationValue)rhs);
            }
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.addTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.addTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue subtract(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).minus((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof TemporalValue && rhs instanceof DurationValue) {
            return ((TemporalValue)lhs).minus((TemporalAmount)((DurationValue)rhs));
        }
        if (lhs instanceof DurationValue && rhs instanceof DurationValue) {
            return ((DurationValue)lhs).sub((DurationValue)rhs);
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.subtractTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.subtractTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue multiply(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                return ((NumberValue)lhs).times((NumberValue)rhs);
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof DurationValue && rhs instanceof NumberValue) {
            return ((DurationValue)lhs).mul((NumberValue)rhs);
        }
        if (rhs instanceof DurationValue && lhs instanceof NumberValue) {
            return ((DurationValue)rhs).mul((NumberValue)lhs);
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.multiplyTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.multiplyTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }

    private static boolean divideCheckForNull(AnyValue lhs, AnyValue rhs) {
        if (rhs instanceof IntegralValue && rhs.equals((Object)Values.ZERO_INT)) {
            throw new org.neo4j.exceptions.ArithmeticException("/ by zero", null);
        }
        return lhs == Values.NO_VALUE || rhs == Values.NO_VALUE;
    }

    public static AnyValue divide(AnyValue lhs, AnyValue rhs) {
        if (CypherMath.divideCheckForNull(lhs, rhs)) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return ((NumberValue)lhs).divideBy((NumberValue)rhs);
        }
        if (lhs instanceof DurationValue && rhs instanceof NumberValue) {
            return ((DurationValue)lhs).div((NumberValue)rhs);
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.divideTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.divideTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue modulo(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            try {
                if (lhs instanceof FloatingPointValue || rhs instanceof FloatingPointValue) {
                    return Values.doubleValue((double)(((NumberValue)lhs).doubleValue() % ((NumberValue)rhs).doubleValue()));
                }
                return Values.longValue((long)(((NumberValue)lhs).longValue() % ((NumberValue)rhs).longValue()));
            }
            catch (ArithmeticException e) {
                throw new org.neo4j.exceptions.ArithmeticException(e.getMessage(), (Throwable)e);
            }
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.modulusTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.modulusTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }

    public static AnyValue pow(AnyValue lhs, AnyValue rhs) {
        if (lhs == Values.NO_VALUE || rhs == Values.NO_VALUE) {
            return Values.NO_VALUE;
        }
        if (lhs instanceof NumberValue && rhs instanceof NumberValue) {
            return Values.doubleValue((double)Math.pow(((NumberValue)lhs).doubleValue(), ((NumberValue)rhs).doubleValue()));
        }
        if (lhs instanceof Value) {
            Value lhsVal = (Value)lhs;
            throw CypherTypeException.powerTypeMismatch((String)lhsVal.prettyPrint(), (String)lhs.getTypeName(), (String)rhs.getTypeName(), (String)CypherTypeValueMapper.valueType(lhs), (String)CypherTypeValueMapper.valueType(rhs));
        }
        throw CypherTypeException.powerTypeMismatch((String)String.valueOf(lhs), (String)(lhs == null ? "NULL" : lhs.getTypeName()), (String)rhs.getTypeName(), (String)(lhs == null ? "NULL" : CypherTypeValueMapper.valueType(lhs)), (String)CypherTypeValueMapper.valueType(rhs));
    }
}

