/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingIntArrayList;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.NodeData;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.PathTracer;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.TwoWaySignpost;
import org.neo4j.internal.kernel.api.helpers.traversal.ppbfs.hooks.PPBFSHooks;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class SignpostStack {
    private final HeapTrackingArrayList<TwoWaySignpost> activeSignposts;
    private final HeapTrackingIntArrayList nodeSourceSignpostIndices;
    private final PPBFSHooks hooks;
    private NodeData targetNode = null;
    private int dgLength = -1;
    private int dgLengthToTarget = -1;

    SignpostStack(MemoryTracker memoryTracker, PPBFSHooks hooks) {
        this.activeSignposts = HeapTrackingArrayList.newArrayList((MemoryTracker)memoryTracker);
        this.nodeSourceSignpostIndices = HeapTrackingIntArrayList.newIntArrayList((MemoryTracker)memoryTracker);
        this.hooks = hooks;
        this.nodeSourceSignpostIndices.add(-1);
    }

    public boolean hasNext() {
        return this.nodeSourceSignpostIndices.notEmpty();
    }

    public void reset() {
        this.targetNode = null;
        for (TwoWaySignpost sp : this.activeSignposts) {
            sp.deactivate();
        }
        this.activeSignposts.clear();
        this.nodeSourceSignpostIndices.clear();
        this.dgLength = -1;
        this.dgLengthToTarget = -1;
    }

    public void initialize(NodeData targetNode, int dgLength) {
        this.targetNode = targetNode;
        this.dgLength = dgLength;
        this.nodeSourceSignpostIndices.add(-1);
        this.dgLengthToTarget = 0;
    }

    public TwoWaySignpost headSignpost() {
        return (TwoWaySignpost)this.activeSignposts.last();
    }

    public NodeData headNode() {
        return this.activeSignposts.isEmpty() ? this.targetNode : ((TwoWaySignpost)this.activeSignposts.last()).prevNode;
    }

    public NodeData target() {
        return this.targetNode;
    }

    public int size() {
        return this.activeSignposts.size();
    }

    public TwoWaySignpost signpost(int index) {
        return (TwoWaySignpost)this.activeSignposts.get(index);
    }

    public NodeData node(int index) {
        return index == 0 ? this.targetNode : this.signpost((int)(index - 1)).prevNode;
    }

    public int lengthToTarget() {
        return this.dgLengthToTarget;
    }

    public int lengthFromSource() {
        return this.dgLength - this.dgLengthToTarget;
    }

    public PathTracer.TracedPath currentPath() {
        PathTracer.PathEntity[] entities = new PathTracer.PathEntity[this.activeSignposts.size() + this.dgLengthToTarget + 1];
        int index = entities.length - 1;
        entities[index--] = PathTracer.PathEntity.fromNode(this.targetNode);
        for (TwoWaySignpost signpost : this.activeSignposts) {
            if (signpost instanceof TwoWaySignpost.RelSignpost) {
                TwoWaySignpost.RelSignpost relSignpost = (TwoWaySignpost.RelSignpost)signpost;
                entities[index--] = PathTracer.PathEntity.fromRel(relSignpost);
            }
            entities[index--] = PathTracer.PathEntity.fromNode(signpost.prevNode);
        }
        Preconditions.checkState((index == -1 ? 1 : 0) != 0, (String)("Traced path length was not as expected (expected " + entities.length + " but found " + (entities.length - (index + 1)) + ")"));
        return new PathTracer.TracedPath(entities);
    }

    public boolean pushNext() {
        int currentIndex;
        NodeData current = this.headNode();
        int nextIndex = current.nextSignpostIndexForLength(currentIndex = this.nodeSourceSignpostIndices.last(), this.lengthFromSource());
        if (nextIndex == -1) {
            return false;
        }
        TwoWaySignpost signpost = current.getSourceSignpost(nextIndex);
        this.activeSignposts.add((Object)signpost);
        this.dgLengthToTarget += signpost.dataGraphLength();
        this.nodeSourceSignpostIndices.set(this.nodeSourceSignpostIndices.size() - 1, nextIndex);
        this.nodeSourceSignpostIndices.add(-1);
        signpost.activate();
        this.hooks.activateSignpost(this.lengthFromSource(), signpost);
        return true;
    }

    public TwoWaySignpost pop() {
        this.nodeSourceSignpostIndices.removeLast();
        if (this.activeSignposts.isEmpty()) {
            return null;
        }
        TwoWaySignpost signpost = (TwoWaySignpost)this.activeSignposts.removeLast();
        this.dgLengthToTarget -= signpost.dataGraphLength();
        signpost.deactivate();
        this.hooks.deactivateSignpost(this.lengthFromSource(), signpost);
        return signpost;
    }
}

