/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.cypher.internal.runtime.memory.ParallelScopedMemoryTracker;
import org.neo4j.cypher.internal.runtime.memory.WorkerThreadDelegatingMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!4A!\u0005\n\u0005?!AQ\u0006\u0001B\u0001B\u0003%a\u0006C\u00033\u0001\u0011\u00051\u0007C\u00047\u0001\t\u0007I\u0011B\u001c\t\r\t\u0003\u0001\u0015!\u00039\u0011\u001d\u0019\u0005A1A\u0005\n\u0011Ca\u0001\u0013\u0001!\u0002\u0013)\u0005\"B%\u0001\t\u0003R\u0005\"\u0002,\u0001\t\u0003:\u0006\"B-\u0001\t\u0013Q\u0006\"B.\u0001\t\u0003b\u0006\"B/\u0001\t\u0003R\u0006\"\u00020\u0001\t\u0003z\u0006\"\u00021\u0001\t\u0003b\u0006\"B1\u0001\t\u0003b\u0006\"\u00022\u0001\t\u0003\u001a\u0007\"B3\u0001\t\u00032'!\u000f)s_\u001aLG.\u001b8h!\u0006\u0014\u0018\r\u001c7fY\"Kw\r[,bi\u0016\u0014X*\u0019:l)J\f7m[5oO^{'o[3s\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u000b\u0005M!\u0012AB7f[>\u0014\u0018P\u0003\u0002\u0016-\u00059!/\u001e8uS6,'BA\f\u0019\u0003!Ig\u000e^3s]\u0006d'BA\r\u001b\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u00111\u0004H\u0001\u0006]\u0016|GG\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0015\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!K\u0016\u000e\u0003)R!a\u0005\u000e\n\u00051R#!D'f[>\u0014\u0018\u0010\u0016:bG.,'/\u0001\u0005eK2,w-\u0019;f!\ty\u0003'D\u0001\u0013\u0013\t\t$CA\u0012X_J\\WM\u001d+ie\u0016\fG\rR3mK\u001e\fG/\u001b8h\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u0002\rqJg.\u001b;?)\t!T\u0007\u0005\u00020\u0001!)QF\u0001a\u0001]\u0005I\u0001.Z1q+N\fw-Z\u000b\u0002qA\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0007CR|W.[2\u000b\u0005ur\u0014AC2p]\u000e,(O]3oi*\u0011q\bJ\u0001\u0005kRLG.\u0003\u0002Bu\tIAj\u001c8h\u0003\u0012$WM]\u0001\u000bQ\u0016\f\u0007/V:bO\u0016\u0004\u0013!\u00045jO\"<\u0016\r^3s\u001b\u0006\u00148.F\u0001F!\tId)\u0003\u0002Hu\tQ\u0011\t^8nS\u000eduN\\4\u0002\u001d!Lw\r[,bi\u0016\u0014X*\u0019:lA\u0005a\u0011\r\u001c7pG\u0006$X\rS3baR\u00111*\u0015\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\u0005+:LG\u000fC\u0003S\u000f\u0001\u00071+A\u0003csR,7\u000f\u0005\u0002M)&\u0011Q+\u0014\u0002\u0005\u0019>tw-A\u0006sK2,\u0017m]3IK\u0006\u0004HCA&Y\u0011\u0015\u0011\u0006\u00021\u0001T\u0003]\u0019w.\u001c9vi\u0016tUm\u001e%jO\"<\u0016\r^3s\u001b\u0006\u00148\u000eF\u0001L\u0003EAW-\u00199IS\u001eDw+\u0019;fe6\u000b'o\u001b\u000b\u0002'\u0006)!/Z:fi\u00061r-\u001a;TG>\u0004X\rZ'f[>\u0014\u0018\u0010\u0016:bG.,'\u000fF\u0001)\u0003A)8/\u001a3OCRLg/Z'f[>\u0014\u00180A\nfgRLW.\u0019;fI\"+\u0017\r]'f[>\u0014\u00180\u0001\bbY2|7-\u0019;f\u001d\u0006$\u0018N^3\u0015\u0005-#\u0007\"\u0002*\u0010\u0001\u0004\u0019\u0016!\u0004:fY\u0016\f7/\u001a(bi&4X\r\u0006\u0002LO\")!\u000b\u0005a\u0001'\u0002")
public class ProfilingParallelHighWaterMarkTrackingWorkerMemoryTracker
implements MemoryTracker {
    private final WorkerThreadDelegatingMemoryTracker delegate;
    private final LongAdder heapUsage;
    private final AtomicLong highWaterMark;

    public void close() {
        super.close();
    }

    private LongAdder heapUsage() {
        return this.heapUsage;
    }

    private AtomicLong highWaterMark() {
        return this.highWaterMark;
    }

    public void allocateHeap(long bytes) {
        this.delegate.allocateHeap(bytes);
        this.heapUsage().add(bytes);
        this.computeNewHighWaterMark();
    }

    public void releaseHeap(long bytes) {
        this.heapUsage().add(-bytes);
        this.delegate.releaseHeap(bytes);
    }

    private void computeNewHighWaterMark() {
        long current = -1L;
        long newValue = -1L;
        do {
            newValue = this.heapUsage().sum();
            current = this.highWaterMark().get();
            if (current < newValue) continue;
            return;
        } while (!this.highWaterMark().weakCompareAndSetVolatile(current, newValue));
    }

    public long heapHighWaterMark() {
        return this.highWaterMark().get();
    }

    public void reset() {
        this.delegate.reset();
        this.heapUsage().reset();
    }

    public MemoryTracker getScopedMemoryTracker() {
        return new ParallelScopedMemoryTracker(this);
    }

    public long usedNativeMemory() {
        return this.delegate.usedNativeMemory();
    }

    public long estimatedHeapMemory() {
        return this.delegate.estimatedHeapMemory();
    }

    public void allocateNative(long bytes) {
        this.delegate.allocateNative(bytes);
    }

    public void releaseNative(long bytes) {
        this.delegate.releaseNative(bytes);
    }

    public ProfilingParallelHighWaterMarkTrackingWorkerMemoryTracker(WorkerThreadDelegatingMemoryTracker delegate) {
        this.delegate = delegate;
        this.heapUsage = new LongAdder();
        this.highWaterMark = new AtomicLong();
    }
}

