/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005A4AAE\n\u0005A!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00033\u0001\u0011\u00051\u0007\u0003\u00048\u0001\u0001\u0006I\u0001\u000f\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001d\t\r\r\u0003\u0001\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015y\u0005\u0001\"\u0011I\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u00159\u0007\u0001\"\u0011b\u0011\u0015A\u0007\u0001\"\u0011b\u0011\u0015I\u0007\u0001\"\u0011k\u0011\u0015Y\u0007\u0001\"\u0011m\u0005m\u0001\u0016M]1mY\u0016d7kY8qK\u0012lU-\\8ssR\u0013\u0018mY6fe*\u0011A#F\u0001\u0007[\u0016lwN]=\u000b\u0005Y9\u0012a\u0002:v]RLW.\u001a\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035m\taaY=qQ\u0016\u0014(B\u0001\u000f\u001e\u0003\u0015qWm\u001c\u001bk\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"SA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB(cU\u0016\u001cG\u000f\u0005\u0002+Y5\t1F\u0003\u0002\u00157%\u0011Qf\u000b\u0002\u0014'\u000e|\u0007/\u001a3NK6|'/\u001f+sC\u000e\\WM]\u0001\tI\u0016dWmZ1uKB\u0011!\u0006M\u0005\u0003c-\u0012Q\"T3n_JLHK]1dW\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00025mA\u0011Q\u0007A\u0007\u0002'!)aF\u0001a\u0001_\u0005iAO]1dW\u0016$g*\u0019;jm\u0016\u0004\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\r\u0005$x.\\5d\u0015\tid(\u0001\u0006d_:\u001cWO\u001d:f]RT!aP\u0013\u0002\tU$\u0018\u000e\\\u0005\u0003\u0003j\u0012\u0011\u0002T8oO\u0006#G-\u001a:\u0002\u0017Q\u0014\u0018mY6fI\"+\u0017\r]\u0001\n?&\u001c8\t\\8tK\u0012\u0004\"!O#\n\u0005\u0019S$!D!u_6L7MQ8pY\u0016\fg.\u0001\tvg\u0016$g*\u0019;jm\u0016lU-\\8ssR\t\u0011\n\u0005\u0002K\u001b6\t1JC\u0001M\u0003\u0015\u00198-\u00197b\u0013\tq5J\u0001\u0003M_:<\u0017aE3ti&l\u0017\r^3e\u0011\u0016\f\u0007/T3n_JL\u0018AD1mY>\u001c\u0017\r^3OCRLg/\u001a\u000b\u0003%V\u0003\"AS*\n\u0005Q[%\u0001B+oSRDQA\u0016\u0005A\u0002%\u000bQAY=uKN\fQB]3mK\u0006\u001cXMT1uSZ,GC\u0001*Z\u0011\u00151\u0016\u00021\u0001J\u00031\tG\u000e\\8dCR,\u0007*Z1q)\t\u0011F\fC\u0003W\u0015\u0001\u0007\u0011*A\u0006sK2,\u0017m]3IK\u0006\u0004HC\u0001*`\u0011\u001516\u00021\u0001J\u00035!\bN]8x\u0013\u001a\u001cEn\\:fIR\t!+A\tiK\u0006\u0004\b*[4i/\u0006$XM]'be.$\u0012\u0001\u001a\t\u0003\u0015\u0016L!AZ&\u0003\u000f9{G\u000f[5oO\u0006)!/Z:fi\u0006)1\r\\8tK\u00061r-\u001a;TG>\u0004X\rZ'f[>\u0014\u0018\u0010\u0016:bG.,'\u000fF\u00010\u0003!I7o\u00117pg\u0016$G#A7\u0011\u0005)s\u0017BA8L\u0005\u001d\u0011un\u001c7fC:\u0004")
public class ParallelScopedMemoryTracker
implements ScopedMemoryTracker {
    private final MemoryTracker delegate;
    private final LongAdder trackedNative;
    private final LongAdder trackedHeap;
    private final AtomicBoolean _isClosed;

    public long usedNativeMemory() {
        return this.trackedNative.sum();
    }

    public long estimatedHeapMemory() {
        return this.trackedHeap.sum();
    }

    public void allocateNative(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateNative(bytes);
        this.trackedNative.add(bytes);
    }

    public void releaseNative(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseNative(bytes);
        this.trackedNative.add(-bytes);
    }

    public void allocateHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateHeap(bytes);
        this.trackedHeap.add(bytes);
    }

    public void releaseHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseHeap(bytes);
        this.trackedHeap.add(-bytes);
    }

    private void throwIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Should not use a closed ScopedMemoryTracker");
        }
    }

    public Nothing$ heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        long heapUsage;
        long nativeUsage = this.trackedNative.sumThenReset();
        if (nativeUsage != 0L) {
            this.delegate.releaseNative(nativeUsage);
        }
        if ((heapUsage = this.trackedHeap.sumThenReset()) != 0L) {
            this.delegate.releaseHeap(heapUsage);
            return;
        }
    }

    public void close() {
        if (!(this.delegate instanceof ScopedMemoryTracker) || !((ScopedMemoryTracker)this.delegate).isClosed()) {
            this.reset();
        }
        this._isClosed.set(true);
    }

    public MemoryTracker getScopedMemoryTracker() {
        return new ParallelScopedMemoryTracker((MemoryTracker)this);
    }

    public boolean isClosed() {
        return this._isClosed.get();
    }

    public ParallelScopedMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
        this.trackedNative = new LongAdder();
        this.trackedHeap = new LongAdder();
        this._isClosed = new AtomicBoolean(false);
    }
}

