/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.profiling;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.profiling.KernelStatisticProvider;
import org.neo4j.cypher.internal.profiling.OperatorProfileEvent;
import org.neo4j.cypher.internal.profiling.ProfilingTracerData;
import org.neo4j.cypher.internal.profiling.QueryProfiler;
import org.neo4j.cypher.internal.v4_0.util.attribution.Id;
import org.neo4j.cypher.result.OperatorProfile;
import org.neo4j.cypher.result.QueryProfile;

public class ProfilingTracer
implements QueryProfiler,
QueryProfile {
    private final Clock clock;
    private final KernelStatisticProvider statisticProvider;
    private final Map<Integer, ProfilingTracerData> data = new HashMap<Integer, ProfilingTracerData>();

    public ProfilingTracer(KernelStatisticProvider statisticProvider) {
        this(Clock.SYSTEM_TIMER, statisticProvider);
    }

    ProfilingTracer(Clock clock, KernelStatisticProvider statisticProvider) {
        this.clock = clock;
        this.statisticProvider = statisticProvider;
    }

    @Override
    public OperatorProfile operatorProfile(int operatorId) {
        ProfilingTracerData value = this.data.get(operatorId);
        if (value == null) {
            return OperatorProfile.ZERO;
        }
        value.sanitize();
        return value;
    }

    public long timeOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).time();
    }

    public long dbHitsOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).dbHits();
    }

    public long rowsOf(Id operatorId) {
        return this.operatorProfile(operatorId.x()).rows();
    }

    @Override
    public OperatorProfileEvent executeOperator(Id operatorId) {
        return this.executeOperator(operatorId, true);
    }

    @Override
    public OperatorProfileEvent executeOperator(Id operatorId, boolean trackTime) {
        ProfilingTracerData operatorData = this.data.get(operatorId.x());
        if (operatorData == null) {
            operatorData = new ProfilingTracerData();
            this.data.put(operatorId.x(), operatorData);
        }
        if (trackTime) {
            return new TimeTrackingExecutionEvent(this.clock, this.statisticProvider, operatorData);
        }
        return new ExecutionEvent(this.statisticProvider, operatorData);
    }

    private static class TimeTrackingExecutionEvent
    extends ExecutionEvent {
        private final long start;
        private final Clock clock;

        TimeTrackingExecutionEvent(Clock clock, KernelStatisticProvider statisticProvider, ProfilingTracerData data) {
            super(statisticProvider, data);
            this.clock = clock;
            this.start = clock.nanoTime();
        }

        @Override
        public void close() {
            long pageCacheHits = this.statisticProvider.getPageCacheHits();
            long pageCacheFaults = this.statisticProvider.getPageCacheMisses();
            long executionTime = this.clock.nanoTime() - this.start;
            this.data.update(executionTime, this.hitCount, this.rowCount, pageCacheHits, pageCacheFaults);
        }
    }

    private static class ExecutionEvent
    extends OperatorProfileEvent {
        final ProfilingTracerData data;
        final KernelStatisticProvider statisticProvider;
        long hitCount;
        long rowCount;

        ExecutionEvent(KernelStatisticProvider statisticProvider, ProfilingTracerData data) {
            this.statisticProvider = statisticProvider;
            this.data = data;
        }

        @Override
        public void close() {
            long pageCacheHits = this.statisticProvider.getPageCacheHits();
            long pageCacheFaults = this.statisticProvider.getPageCacheMisses();
            this.data.update(-1L, this.hitCount, this.rowCount, pageCacheHits, pageCacheFaults);
        }

        @Override
        public void dbHit() {
            ++this.hitCount;
        }

        @Override
        public void dbHits(int hits) {
            this.hitCount += (long)hits;
        }

        @Override
        public void row() {
            ++this.rowCount;
        }

        @Override
        public void row(boolean hasRow) {
            if (hasRow) {
                ++this.rowCount;
            }
        }

        @Override
        public void rows(int n) {
            this.rowCount += (long)n;
        }
    }

    public static interface Clock {
        public static final Clock SYSTEM_TIMER = System::nanoTime;

        public long nanoTime();
    }
}

