/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.cypher.internal.runtime.ResourceMonitor;
import org.neo4j.cypher.internal.runtime.ResourcePool;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.kernel.api.AutoCloseablePlus;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u001b\t1B\u000b\u001b:fC\u0012\u001c\u0016MZ3SKN|WO]2f!>|GN\u0003\u0002\u0004\t\u00059!/\u001e8uS6,'BA\u0003\u0007\u0003!Ig\u000e^3s]\u0006d'BA\u0004\t\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011\u0011BC\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0007SKN|WO]2f!>|G\u000e\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u001diwN\\5u_J\u0004\"!F\u000e\n\u0005q\u0011!a\u0004*fg>,(oY3N_:LGo\u001c:\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0016\u0001!)\u0011$\ba\u00015!91\u0005\u0001b\u0001\n\u0003!\u0013!\u0003:fg>,(oY3t+\u0005)\u0003c\u0001\u0014,[5\tqE\u0003\u0002)S\u0005!Q\u000f^5m\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0002/i5\tqF\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0005I\u001a\u0014AB6fe:,GN\u0003\u0002\u0006\u0011%\u0011Qg\f\u0002\u0012\u0003V$xn\u00117pg\u0016\f'\r\\3QYV\u001c\bBB\u001c\u0001A\u0003%Q%\u0001\u0006sKN|WO]2fg\u0002BQ!\u000f\u0001\u0005Bi\n1!\u00193e)\tYd\b\u0005\u0002\u0010y%\u0011Q\b\u0005\u0002\u0005+:LG\u000fC\u0003@q\u0001\u0007Q&\u0001\u0005sKN|WO]2f\u0011\u0015\t\u0005\u0001\"\u0011C\u0003\u0019\u0011X-\\8wKR\u00111I\u0012\t\u0003\u001f\u0011K!!\u0012\t\u0003\u000f\t{w\u000e\\3b]\")q\b\u0011a\u0001[!)\u0001\n\u0001C!\u0013\u0006\u0019\u0011\r\u001c7\u0015\u0003)\u00032aS*.\u001d\ta\u0015K\u0004\u0002N!6\taJ\u0003\u0002P\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003%B\tq\u0001]1dW\u0006<W-\u0003\u0002U+\nA\u0011\n^3sCR|'O\u0003\u0002S!!)q\u000b\u0001C!1\u0006)1\r\\3beR\t1\bC\u0003[\u0001\u0011\u0005\u0003,\u0001\u0005dY>\u001cX-\u00117m\u0001")
public class ThreadSafeResourcePool
implements ResourcePool {
    private final ResourceMonitor monitor;
    private final Collection<AutoCloseablePlus> resources;

    public Collection<AutoCloseablePlus> resources() {
        return this.resources;
    }

    @Override
    public void add(AutoCloseablePlus resource) {
        this.resources().add(resource);
    }

    @Override
    public boolean remove(AutoCloseablePlus resource) {
        return this.resources().remove(resource);
    }

    @Override
    public Iterator<AutoCloseablePlus> all() {
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.resources().iterator()).asScala();
    }

    @Override
    public void clear() {
        this.resources().clear();
    }

    @Override
    public void closeAll() {
        java.util.Iterator<AutoCloseablePlus> iterator = this.resources().iterator();
        Throwable error = null;
        while (iterator.hasNext()) {
            try {
                AutoCloseablePlus resource = iterator.next();
                this.monitor.close(resource);
                resource.setCloseListener(null);
                resource.close();
            }
            catch (Throwable t) {
                error = Exceptions.chain(error, (Throwable)t);
            }
        }
        if (error != null) {
            throw error;
        }
        this.resources().clear();
    }

    public ThreadSafeResourcePool(ResourceMonitor monitor) {
        this.monitor = monitor;
        this.resources = new ConcurrentLinkedQueue<AutoCloseablePlus>();
    }
}

