/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.planDescription;

import org.neo4j.cypher.internal.ir.v3_5.ProvidedOrder;
import org.neo4j.cypher.internal.ir.v3_5.ProvidedOrder$;
import org.neo4j.cypher.internal.runtime.planDescription.Argument;
import org.neo4j.cypher.internal.runtime.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.runtime.planDescription.PlanDescriptionArgumentSerializer$;
import org.neo4j.cypher.internal.v3_5.expressions.DummyExpression;
import org.neo4j.cypher.internal.v3_5.expressions.Expression;
import org.neo4j.cypher.internal.v3_5.expressions.SemanticDirection;
import org.neo4j.cypher.internal.v3_5.expressions.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.v3_5.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_5.logical.plans.NestedPlanExpression;
import org.neo4j.cypher.internal.v3_5.util.DummyPosition$;
import org.neo4j.cypher.internal.v3_5.util.InputPosition;
import org.neo4j.cypher.internal.v3_5.util.attribution.IdGen;
import org.neo4j.cypher.internal.v3_5.util.attribution.SequentialIdGen;
import org.neo4j.cypher.internal.v3_5.util.attribution.SequentialIdGen$;
import org.neo4j.cypher.internal.v3_5.util.symbols.CypherType;
import org.neo4j.cypher.internal.v3_5.util.symbols.package$;
import org.neo4j.cypher.internal.v3_5.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001f\t1\u0003\u000b\\1o\t\u0016\u001c8M]5qi&|g.\u0011:hk6,g\u000e^*fe&\fG.\u001b>feR+7\u000f^:\u000b\u0005\r!\u0011a\u00049mC:$Um]2sSB$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\taaY=qQ\u0016\u0014(BA\u0006\r\u0003\u0015qWm\u001c\u001bk\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!\u0001\u0003wg}+\u0014BA\r\u0013\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!C\u0005C\u0005\u0019\u0001o\\:\u0016\u0003\t\u0002\"a\t\u0013\u000e\u0003QI!!\n\u000b\u0003\u001b%s\u0007/\u001e;Q_NLG/[8o\u0011\u00199\u0003\u0001)A\u0005E\u0005!\u0001o\\:!\u0011\u001dI\u0003A1A\u0005\u0004)\nQ!\u001b3HK:,\u0012a\u000b\t\u0003Y=j\u0011!\f\u0006\u0003]Q\t1\"\u0019;ue&\u0014W\u000f^5p]&\u0011\u0001'\f\u0002\u0010'\u0016\fX/\u001a8uS\u0006d\u0017\nZ$f]\"1!\u0007\u0001Q\u0001\n-\na!\u001b3HK:\u0004\u0003")
public class PlanDescriptionArgumentSerializerTests
extends CypherFunSuite {
    private final InputPosition org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos = DummyPosition$.MODULE$.apply(0);
    private final SequentialIdGen idGen = new SequentialIdGen(SequentialIdGen$.MODULE$.$lessinit$greater$default$1());

    public InputPosition org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos() {
        return this.org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos;
    }

    public SequentialIdGen idGen() {
        return this.idGen;
    }

    public PlanDescriptionArgumentSerializerTests() {
        this.test("serialization should leave numeric arguments as numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.DbHits(12L))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Rows(12L))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.EstimatedRows(12.0))).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(Number.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("ExpandExpression should look like Cypher syntax", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*..5]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)None$.MODULE$))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 3, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)5))))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*3..5]->(b)"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.ExpandExpression("a", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LIKES", "LOVES"})), "b", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 3, (Option)None$.MODULE$))).should(this.$outer.equal("(a)-[r:LIKES|:LOVES*3..]->(b)"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize nested plan expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.neo4j.cypher.internal.v3_5.logical.plans.Argument argument = new org.neo4j.cypher.internal.v3_5.logical.plans.Argument(Predef$.MODULE$.Set().empty(), (IdGen)this.$outer.idGen());
                DummyExpression expression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTNode())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTBoolean())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTList((CypherType)package$.MODULE$.CTString()))), DummyPosition$.MODULE$.apply(5));
                NestedPlanExpression nested = new NestedPlanExpression((LogicalPlan)argument, (Expression)expression, this.$outer.org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Expression((Expression)nested))).should(this.$outer.equal("NestedPlanExpression(Argument)"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("projection should show multiple expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Expressions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)new SignedDecimalIntegerLiteral("42", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)new SignedDecimalIntegerLiteral("56", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$PlanDescriptionArgumentSerializerTests$$pos()))}))))).should(this.$outer.equal("{1 : 42, 2 : 56}"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize something that includes a regex should work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String value = "GenericCase(Vector((any(  x@40 in n.values where   x@40 =~ Literal(^T-?\\d+$)),SubstringFunction(ContainerIndex(FilterFunction(n.values,  x@106,  x@106 =~ Literal(^T-?\\d+$)),Literal(0)),Literal(1),None))),Some(Literal(1))) == {p0}";
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.KeyNames((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{value}))))).should(this.$outer.equal("GenericCase(Vector((any(x in n.values where x =~ Literal(^T-?\\d+$)),SubstringFunction(ContainerIndex(FilterFunction(n.values,x,x =~ Literal(^T-?\\d+$)),Literal(0)),Literal(1),None))),Some(Literal(1))) == {p0}"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("serialize and deduplicate variable names with regexy symbols", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.KeyNames((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 >=   version$@40, 2 <=   version$@352"}))))).should(this.$outer.equal("1 >= version$, 2 <= version$"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.KeyNames((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1 >=   version\\@40, 2 <=   version\\@352"}))))).should(this.$outer.equal("1 >= version\\, 2 <= version\\"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should serialize point distance index seeks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.PointDistanceIndex("L", "location", "p", "300", false))).should(this.$outer.equal(":L(location) WHERE distance(_,p) < 300"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.PointDistanceIndex("L", "location", "p", "300", true))).should(this.$outer.equal(":L(location) WHERE distance(_,p) <= 300"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should serialize provided order", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanDescriptionArgumentSerializerTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Order(new ProvidedOrder((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{new ProvidedOrder.Asc("a"), new ProvidedOrder.Desc("b"), new ProvidedOrder.Asc("c.foo")})))))).should(this.$outer.be().apply((Object)"a ASC, b DESC, c.foo ASC"));
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Order(ProvidedOrder$.MODULE$.empty()))).should(this.$outer.be().apply((Object)""));
                this.$outer.convertToAnyShouldWrapper(PlanDescriptionArgumentSerializer$.MODULE$.serialize((Argument)new InternalPlanDescription.Arguments$.Order(new ProvidedOrder((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProvidedOrder.Asc[]{new ProvidedOrder.Asc("  FRESHID42")})))))).should(this.$outer.be().apply((Object)"anon[42] ASC"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

